prompt --application/set_environment
set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback
--------------------------------------------------------------------------------
--
-- Oracle APEX export file
--
-- You should run this script using a SQL client connected to the database as
-- the owner (parsing schema) of the application or as a database user with the
-- APEX_ADMINISTRATOR_ROLE role.
--
-- This export file has been automatically generated. Modifying this file is not
-- supported by Oracle and can lead to unexpected application and/or instance
-- behavior now or in the future.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_imp.import_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.8'
,p_default_workspace_id=>86787081506856920547
,p_default_application_id=>37118
,p_default_id_offset=>0
,p_default_owner=>'WKSP_NEERAJKUMAR'
);
end;
/
 
prompt APPLICATION 37118 - TOOL LENDING LIBRARY
--
-- Application Export:
--   Application:     37118
--   Name:            TOOL LENDING LIBRARY
--   Date and Time:   08:09 Saturday November 1, 2025
--   Exported By:     126156094@SASTRA.AC.IN
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     14
--       Items:                   37
--       Validations:              7
--       Processes:               23
--       Regions:                 33
--       Buttons:                 24
--       Dynamic Actions:          5
--     Shared Components:
--       Logic:
--         Items:                  2
--         Build Options:          1
--       Navigation:
--         Lists:                  3
--         Breadcrumbs:            1
--           Entries:             10
--       Security:
--         Authentication:         5
--         Authorization:          5
--       User Interface:
--         Themes:                 1
--         Templates:
--       PWA:
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--   Version:         24.2.8
--   Instance ID:     63113759365424
--

prompt --application/delete_application
begin
wwv_flow_imp.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_imp_workspace.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'WKSP_NEERAJKUMAR')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'TOOL LENDING LIBRARY')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'TOOL-LENDING-LIBRARY')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt=>'119F8E31A300E77466EA13736C5F16DA2214CB8402282CE7676C8AB1741AF4ED'
,p_bookmark_checksum_function=>'SH512'
,p_compatibility_mode=>'24.2'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'FLOW_PRIMARY_LANGUAGE'
,p_allow_feedback_yn=>'Y'
,p_date_format=>'DS'
,p_timestamp_format=>'DS'
,p_timestamp_tz_format=>'DS'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication_id=>wwv_flow_imp.id(102685641588483579766)
,p_application_tab_set=>0
,p_logo_type=>'T'
,p_logo_text=>'TOOL LENDING LIBRARY'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'Release 1.0'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_substitution_string_01=>'APP_NAME'
,p_substitution_value_01=>'TOOL LENDING LIBRARY'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_files_version=>11
,p_version_scn=>15665216724351
,p_print_server_type=>'INSTANCE'
,p_file_storage=>'DB'
,p_is_pwa=>'Y'
,p_pwa_is_installable=>'N'
,p_pwa_is_push_enabled=>'N'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_imp_shared.create_user_interface(
 p_id=>wwv_flow_imp.id(37118)
,p_theme_id=>42
,p_home_url=>'f?p=&APP_ID.:1:&APP_SESSION.::&DEBUG.:::'
,p_login_url=>'f?p=&APP_ID.:LOGIN:&APP_SESSION.::&DEBUG.:::'
,p_theme_style_by_user_pref=>false
,p_built_with_love=>false
,p_global_page_id=>0
,p_navigation_list_id=>wwv_flow_imp.id(95883178125372758925)
,p_navigation_list_position=>'TOP'
,p_navigation_list_template_id=>2526754704087354841
,p_nav_list_template_options=>'#DEFAULT#:js-tabLike'
,p_nav_bar_type=>'LIST'
,p_nav_bar_list_id=>wwv_flow_imp.id(95883179869824758928)
,p_nav_bar_list_template_id=>2847543055748234966
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(95883178125372758925)
,p_name=>'Navigation Menu'
,p_list_status=>'PUBLIC'
,p_version_scn=>15665206946434
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95883196664318758942)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'HOME'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-home'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95885885196691544064)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'TOOL ISSUE'
,p_list_item_link_target=>'f?p=&APP_ID.:8:&APP_SESSION.::&DEBUG.:::'
,p_list_item_icon=>'fa-forms'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'8'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(96023914581776960904)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'TOOL RETURN'
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-forms'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(102906884667178204678)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'TOOLS'
,p_list_item_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95887787880435568550)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'TOOLS ISSUED'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95922495442482851088)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>'DASHBOARD'
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-dashboard'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'11'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(96269333864952061856)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'MEMBERS'
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-header-sidebar-left'
,p_security_scheme=>wwv_flow_imp.id(102701685134187973773)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(96271818323958834254)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Member Registration'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-forms'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(96278961340283097445)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'ADMIN ONLY'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table-pointer'
,p_security_scheme=>wwv_flow_imp.id(102701685134187973773)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'22'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(96019490647994441139)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'TOOLS ENTRY'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table-pointer'
,p_security_scheme=>wwv_flow_imp.id(102701685134187973773)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'14'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_bar
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(95883179869824758928)
,p_name=>'Navigation Bar'
,p_list_status=>'PUBLIC'
,p_version_scn=>15659873373708
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95883200085378758945)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'&APP_USER.'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-user'
,p_list_text_02=>'has-username'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95883200871939758945)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_disp_cond_type=>'USER_IS_NOT_PUBLIC_USER'
,p_parent_list_item_id=>wwv_flow_imp.id(95883200085378758945)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95883201593315758946)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Sign Out'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_item_icon=>'fa-sign-out'
,p_list_item_disp_cond_type=>'USER_IS_NOT_PUBLIC_USER'
,p_parent_list_item_id=>wwv_flow_imp.id(95883200085378758945)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/home_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(102186974460832000125)
,p_name=>'Home Navigation'
,p_list_status=>'PUBLIC'
,p_version_scn=>15664500885659
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(102186974649892000127)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Member Registration'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(102186975006981000127)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tools Issue'
,p_list_item_link_target=>'f?p=&APP_ID.:8:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(102186975408671000128)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tools Return'
,p_list_item_link_target=>'f?p=&APP_ID.:17:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/listentry
begin
null;
end;
/
prompt --application/shared_components/files/icons_app_icon_32_png
begin
wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table;
wwv_flow_imp.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000020000000200806000000737A7AF400000301494441547801EC956B4F13411486DF966EB9D8D2D29616C4565408723315281749247E35D1C46834F1F20B4CFC3F464C8C1FFC0B4613132522092AD872A921';
wwv_flow_imp.g_varchar2_table(2) := 'C61470A1B5E5520ABD6E773D33151492B2DB044362BAE999EE9C9D39E7D9F7CCCCEA23F76E29C7697A1CF35506282B505640B30292A2209A4E23924A63339B854CFD623B389DCF232C2B58D1E98A0DD9F36B0658DCDE81E3EA35B43C7C04C7EDBB487776';
wwv_flow_imp.g_varchar2_table(3) := '23B31766FFCD86D902CFE5110879196A976680B36613D65FBDC4EA877154592C700D0EC3307009F9034A306572990C44BF1F562850BB540172B2CCC33031ED820135C1592C8FBDE571ADA4C21649CD3BD4B0E4AC444D5216F5893804BD6A78A88E886773';
wwv_flow_imp.g_varchar2_table(4) := '887B9AB14575A51C88E724D4B5B422E29F42722D0AA9E60473734896DC595D850A0DB5E793A8510560C1EC177B60BB79079B0E2774ED9D38D1D0089916628DBD1E1004BE20C3C9145C2526A7FCEA0A588C02229F3EA2DA6687FBFA0DB847AE20169C87F5';
wwv_flow_imp.g_varchar2_table(5) := '5C2B9B8FDAAE6E88C9244FAE2FE1CDF9646AF46487FE58D0AAC510BE53DD33B91C1FEBBCE0E540ACE3E8E842DDD03012541AD62FD55401584093A102D68520C467A3987FF11C22C1247E2CB147DC1AFB0650D1DB47100540EED4D8680260B1D88A16E43C';
wwv_flow_imp.g_varchar2_table(6) := '9CA7DC644D487F5BC0F2FB31F6885BA36F10F0F660BB442534036C64B2A86EEB80C9E54268721256CF69E463518813E31C803527E95C50086247925857936902E0C969F59B1A5C589AFA0CB7D78BB82842F819862E307D0062088AB71729297F3400ECDC';
wwv_flow_imp.g_varchar2_table(7) := 'AF6C3B0F334B3E3D050F6DC9ED6814A9B919D41A0C300B024010FBCAD13F884C5B3B727488A951E8D50648B4D76DCDCD58F27F81A7A71789F02A4F6E351AF7A6D612846E36406BE21DF74D3C7D82863E1FB67EEF1AEE2CD2E88BF8FFB87585DB33BE7EC4';
wwv_flow_imp.g_varchar2_table(8) := '574424D919F057F2C253809D172088D09BD7F0DD7F80D8DC6C419DDD0145FE550184580C622080959900D25F83B0555616090530558CB43B42A38F61A4B2188FE25BC0DECCBE1E836D8DEC90E4BB546C4DB8E848D6929CCD5155800DFA975606282BF0FF';
wwv_flow_imp.g_varchar2_table(9) := '2BA0B6837E010000FFFFB1D04B5900000006494441540300222D5B30F35A6D5B0000000049454E44AE426082';
wwv_flow_imp_shared.create_app_static_file(
 p_id=>wwv_flow_imp.id(95883182100175758931)
,p_file_name=>'icons/app-icon-32.png'
,p_mime_type=>'image/png'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/icons_app_icon_144_rounded_png
begin
wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table;
wwv_flow_imp.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000090000000900806000000E746E2B800001000494441547801EC9D79701BD77DC7BFBB200002A4789320A993A4EE8BB20E5BB25C5BF121CB8923C79668EBAAA5DA63274ED2C49DB69399F68F1ED3CEF48FA6';
wwv_flow_imp.g_varchar2_table(2) := '634F138FEBA4B1ADEAB043D9F2913AF115DBD16559910F293A2C8AA2A883F77D1304B0F9FD160045F002B10B1058E081FB7617BBEFED7BEFFB3EF8BD6B7729437C84023A141000E9104F0405044082025D0A088074C927020B800403BA141000E9924F04';
wwv_flow_imp.g_varchar2_table(3) := '160009067429A019205DB18AC071A38000286E8A323A1911004547F7B8895500143745199D8C0880A2A37BDCC42A008A9BA28C4E460440D1D13D6E629D7C8026205DE3631BA734EC2ACBAFDFF94849FD8E074BEB776CBEB57E47D93D755B377D3B111CE7';
wwv_flow_imp.g_varchar2_table(4) := 'B55ECD33E59D34602D5893094837E95EA20A9002484D5B37CD6FD8BE6967FD8E4DCFD56DDFFCC7FAED9B9D9E7E4B8732A0D4C2E5BE08C5F425141C81A2BC27C9D25B520238CEAB37CF9477D280B5604D581B9F463F6F20CD583BD61051FC4C2A40B56565';
wwv_flow_imp.g_varchar2_table(5) := 'B9753BCA36366CDBFCEFF5DBCBDE6FD8BEB9D52D4BE714482F41919E928015A485999C584657C0ECD3E8FBAC196BC71A7AB5DCF46F6C9DAF9695658D1E343247270D20059024B372ABA4283F5124FC03A0DC0D209D9C58F429401A2A772B90FE5192E59F';
wwv_flow_imp.g_varchar2_table(6) := '982DCAAD0A409C61523E11074879F24973DDF64D4F346CDB745E92F006805BC98925220A286B899CB7C92A9DABDB56F6386B1F9168865C34A200353D5A36B5BEBBE59804E90548D2DC21F18ADDC82A304F92945FD677B51CE5664324A38A1840B5DBCB16';
wwv_flow_imp.g_varchar2_table(7) := 'BADDCA71C9DBAE89641EC4B5C750802CFE4AD9EA3956BB75D3A231BCE83E1C11801AB696DD2643394AA99B4A2E4C8BB88C260514A94496A5238D5BCBEED0143E48A0B003C49647919577295E6ADCD15A2CB1A040BA4756DE8984250A2B40354F7EDB4E96';
wwv_flow_imp.g_varchar2_table(8) := 'A79C14B393134B6C2960274BF42A975138931556804CDDD6E728710BC98925361558E42BA3B0A52E6C00356C2BDB45A9DA494E2CB1ADC04E5F59852595610188463F6D8AA4FC575852242E127105A8AC7E1AAEAA2C2C00592C1EB63C9911CFB988205C0A';
wwv_flow_imp.g_varchar2_table(9) := '6499BA2D8F86E362BA01F20E9B4B4F87233111BA86B8EC280A48C08FBC6537CAC9100EE906A87147D9BD14DF3C72623190020AA405BEB2D3956ADD00290A84F581313FE1283B5D0055EDDA954CB3EAF718533E916A2E3BEE00E951421740C9AEAED514B9';
wwv_flow_imp.g_varchar2_table(10) := 'AE6B5078B1444F0139C9AADCA2277A5D856F522406484FFC226C9415D05B86BA0052A00880A20C80DEE8F596A1668014807A82B80D71FC4990ACE932029A016ADC55E62081B3C989C5D80A383A1E7D5073396A06C8D4EFD11CA9B1F58EBFD40F0CC8F95A';
wwv_flow_imp.g_varchar2_table(11) := '73A51920A7AC885B36B4AA1E63E1F494A56680E0310980620C04CDC9D151969A01329960D39C601130A61430CB4A92D604690648F1882A4CABE8B116CE23499A1FE6D40C902C0B0B342608063BA1C718680648F168A7D660FA4634B94E8F0757BBBB71BD';
wwv_flow_imp.g_varchar2_table(12) := 'BB27A2F18C77713DC6403B4092C7355EA2C4B9F115182070AE1134E7DB3AD0D2EF44537F3F2E7576810668C70F18636735031463F91835393D2E17EA7A7B51DDD58D8AF60EFCA9B50D675ADB71B1A3135C788D7D7DE81A98DCDF814B5150D3D383B36DED';
wwv_flow_imp.g_varchar2_table(13) := '682668CC562B4A4A4B91959787CE81014A57F7A87989D583710790870A88C1F89A80A92050EA7BFBD0E674A29FECB43D271796CC4C3893CC6AE1D5F4F4A2B2B35305AAD7E58E6819B9295DB514DF3902A7B1AF1FD6641B66972E43E9BD1B9053321B5905';
wwv_flow_imp.g_varchar2_table(14) := '53D5F84D12CF10A9BB8658C515400D04CB39AA12180CB7D98282454BB0E0FE8D58F5C4F7B0E6C77F8BD29D8F61F9634FE0961FFE186BFEFA69CC5DBF0159B38AD04D96EA424787DA16610B11899263A01BC8E2596D36CC59BE02CB366C40764909E42413';
wwv_flow_imp.g_varchar2_table(15) := 'E05170EDC27935DADCE464756B94956C9484064B67BB7300B5545DB9140FD20B0AB1EA073F42C97DDF42F6FC85B0A66760F8C7644D46DED26558B8F9112CDBFEA81A86DB22E7C942705532DCBFDEEFDCE6494D4BC7D20DF711B4B300F986F4CD572EA38F';
wwv_flow_imp.g_varchar2_table(16) := 'D29E63B5C23CE4B8DE382723FC8D5C4C466C118C23DD624601FDBA65AA02DA6B6B707AF78BE8AEAB9D508CA904DC1282A8E48E75704BB2DA98EDA0F6C8840287E0C9641A456EB63EE7CEA957C9B319CBFA70A247C9111F36A6CBB325637E7A1A322D1674';
wwv_flow_imp.g_varchar2_table(17) := '3636E08B3D2FA3E2376F61A067620DD38255ABB16CCB562459ACA8A21E115BB5482BD17AF58A61AD0F6B1357007186B80A98919A8239695360A3F996FAF36771F217CFE3FAA7C7A078823794530BA761E1771E84445509F7DEB8EAE1EB46C2D1001EAE92';
wwv_flow_imp.g_varchar2_table(18) := 'F5912081E18F441C91BEA61CE908A2757D7B5212E692359A9E6207A8875575F8137CFEBFBF40FBE54B4193943663164AD6DD0985FEB8411E34C0043D747575E1C2A14383EEEB4F3E462F59C76CABC5706D1F7F9665FF4EBC6EB3A8613A2F230DDC40ED6D';
wwv_flow_imp.g_varchar2_table(19) := '6FC3E903BFC6B9D7CBE1A45ED77879CE5FBE526D58F310008F168FE737D839AE0ED98F9BDA55AD54B5FA5D7B6B0BACB2C9B0D687F314F700712693240953C912CD238B944296A9F95225BEF8BF17D1DBD2CCA7C7745357DDAC9E6BA1013F7547C38AE1E1';
wwv_flow_imp.g_varchar2_table(20) := '06792AC5BB243303A55999016E3EC1CDD5AE864BC744908400C8AF7432B5896653DB288FC65A06A8DB5C7BE2B8FFD4A8DBACB9F361260BD6D63F30EAF9600787C253342515DC430C16C668E70D09100FFCB1D32BB6392535E82532A6CF403F35BE436D4C';
wwv_flow_imp.g_varchar2_table(21) := '4F323C41F311290F8604A8862621793E8B0B29D4F60983C023C226B319F9372D0FAAAB3D3757F5134A3C9C2EAEB6B8BA8C57CBA38A422B4302E4A279254A3BB89078369B7B4A3CD7C4C782399E8F623F336E5983A116A8BDAA127527FF08C5776DF6C3CE';
wwv_flow_imp.g_varchar2_table(22) := '92EAB552FDEEE043003C937E89C68F385D0C4F719C565BAC8BDF1916201B4D4FCCB9EB1E9869F0B091E69818A4608D5D9E9D6FA589555B7A3AA6AE0E7CDFF9D9B7DEC0C58F3EC0C95F3E8FAEDAEB7E7D60F1557313B140D5D44DE7699044818745927965';
wwv_flow_imp.g_varchar2_table(23) := '34C733EE0ACD79396E5A8195DFFD3EA6AF5C058F2CD164680F2ED02CFC58B768F86FDA9A73F7FA11595EF49D8760A799FABEF676B45CBC38789EAB3AFEC271F27634C796E732C1C323D789040F6B21F3CA688E476EE1F1A8C99693CC98B9EE2EACA059F6';
wwv_flow_imp.g_varchar2_table(24) := 'DC3973D14B554D656727B840875A0D1ECFE9A173D945C5482B2A51C3F28ABBF22D155F236D6611963FFE5D946ED986197F71079FF2BA61559AF7E08D35C3C39687E1E1C1CB44A8B66EE41E302440B62413FAE817EF71DDE85E5BA94A9BF7C04358B67507';
wwv_flow_imp.g_varchar2_table(25) := 'D21CF9E002E57B6FB87DC41689DB3EB2C984E261D6A7EAFDF770F6CD8338BD77377A9A1A3165DA8CA1FA40B658D4EF34E7A96E87AFAE7475AB71B1E529498036CFF0FC1B12203B81C01969ABAAE24D804B9D3A0D4BFF7217E6DFF72D24A74E01B78FD822';
wwv_flow_imp.g_varchar2_table(26) := 'B1352ABEFD1B60D08606285ABF1E5964957806FFE2EFDE197A4ADD4F251879A7D735F2CE45B6726CD9EC34486854CBC379D3E30C09509AC5ACE6B9F1DC19753BDA2A67D112ACFCDE0F30E79EF5C82E2EC1826FDE8FFC152B07BDBAFBFB507FEA4B246764';
wwv_flow_imp.g_varchar2_table(27) := '61E1A687B164F3C32819669D54CFA624D83332C1D55F2FCDA9A9C76855EDB33C0C4F225A1E92405D64756DB0D514B3193C87D474E1029C54958D977C47E9722C78A80CD90B170778AB39F1192ADEFB9D3A53DF565981F459C548C92F08F0E3FF52B87C85';
wwv_flow_imp.g_varchar2_table(28) := 'BA7BADC7FBE404C3E3B73C890C0F8B62488038E1B9362BCD952BB8465D6FFE1EAA2BA479AEC2254BD14F93AA670EBE3E62FC67E8F5F26962356BFA4CF03000F7F2FCF0246AB535541BC302946DB582E7B66ABE3E8FF6F36787E66942FB266B328AEFFD26';
wwv_flow_imp.g_varchar2_table(29) := '96FFD5E358B0F1014892346EB8D954055A5352D45E1E5B3FB63CA62061C6BD609C9C342C40ACFF0C2A50DE9E7BF7B7E8A9ADE1DD909D2D3B075934691A2CA065CA142C7E641B18229E1BE3D1E6606112E1BCA101B25177BED06E836B6000A77EBD1F1D57';
wwv_flow_imp.g_varchar2_table(30) := '2E47B4CC6C59D958B2653B2C369BFAAC195765118DD00017373440AC2F3F06C337D3AB101D28C7F56387E9300FEFD126024B726696808875F539C303C4F9E0FB89A7DAED80C78DAA2387F1F9CB2FA2B5BA9A4F45C471B5272C9157DAB80088B392936C45';
wwv_flow_imp.g_varchar2_table(31) := '09B553F846FA9EC6069C29DF8F633F7B06E7DF7E03578F1D51C77CB8BBDE456D25274D7570183D8E215A4CD31E895E9DC50D400C43AAD97B23FDCCD414A4D158919B66E99BA897567DE4903AE6F3A783AFE14B9AB2F8EC7F7E8EC3FFF91F38FBEA7ED47F';
wwv_flow_imp.g_varchar2_table(32) := 'F9393C43A644F83A1375F6EC5CB5616D4E4EDC36515C01E42FF80C8B057C23D7A2CC0CF0580DF7D61CB664FF69D87CBDB796ABD5A8F8E03D9C78FE39D49D3C01D00CFFA0A709EED87372A94DB40D890A515C02E42F7BBE999E47AD79EAA3D3E99D78CD76';
wwv_flow_imp.g_varchar2_table(33) := 'E463E9BD1BB08AC67E16ACB91585C525AA05BAF8D1873845D6C9D5D7EB0F3EE16D224314D70031017C1FCFA5CE2EF05C56569E03C5ABD7F061C834019A565080E9CB9661E99D77614A5A3A3AEAEAF0E5EE97D0DBDAACFA096565674BF4C856F5267CFF54';
wwv_flow_imp.g_varchar2_table(34) := '4728E18DEA37AE01F2280A2A191E9A4967784AC8E2C8A69159E6DB56E7AFFB060A6956BEAFA31DA7F7ED416F7353C8656ACFCDC3E287B7A8105DE9EA515F2B8338FF8C543358860D729EE1512D4F1078FCD991695072FA4D376176E94D70F6F6E2F42B7B';
wwv_flow_imp.g_varchar2_table(35) := '354194E22850214AB25A900810C525407E78F8D11FD5F250B535DCF2F050E3B553A7D071ED9A9F21759B5D528C39CB970F42D4DFD6AA1E0F6595E283C8940010C51D4043E1C9C8CD4509C343D66528000CCFA5A34771FD6205DA1AEA879E52F7B36615A1';
wwv_flow_imp.g_varchar2_table(36) := 'B8B45485E8D4FE3DE86B6D518F87B252212A7B04268B39AEA73DE450448975BF0C0F3F93C59687E199B3662D35964D01C9563C1E541C3A84A6BA5A64529B65DAD26501E7F98B7BC085E62B577917FDDDDD6A75A6C512A5E61762F1E6879144C30AF15A9D';
wwv_flow_imp.g_varchar2_table(37) := 'C50D407E78BAA8CD934196674C788E1C01BFDC2093E099B37624600C4FC5E143E0171FF078128F2131446C89344154384D85882D513C421417007195C496275478243930FB1E822F009ED414645A2D9849DB704024D34879BC4114A8A06AB48DB59A083C';
wwv_flow_imp.g_varchar2_table(38) := '1E971B153ECB934503896C794683E702F919B43C048DE493822D11BF674837449BCA106F104D2240BED208E3C60F0F3F0D9A9E9D83D1AA2D159EA3DE6A8BE1994D634123E171438587C67EF85D8B3386C0E34F2EBF67482F44FCC8D0E23883C8B000313C';
wwv_flow_imp.g_varchar2_table(39) := 'D55D5DEACBB9199EB96B47B667FCF0B43535E2063C7EBBE24543F543B3F5ED3E7866A6A622D087D71FAFC30A11F50CB93AE3E7D7F8DA46758604C80F0F8B7F039EA4803250C120CB331178DA1A1BC17366E3C1E3BF3843342DC5AEF6CED486757B9BFFD4';
wwv_flow_imp.g_varchar2_table(40) := '84B76C89163DB809324154DDD5ADBEA77AC28163CCA32101BA4AA28F0F8F0B153E78720A0AE1ADB602ED8AC7EDC145B23C0C0FDFFAC1B3F6813EC62E29BEA19F6F60E336D1E9FD7BD14FD31F63FB1EFD0C3F4ABDF08107D5274BB803C0AF9D19DD676C1F';
wwv_flow_imp.g_varchar2_table(41) := '351C407C1F32BF61233D2B0B73D772B535DCF2B8D4F60C5B9E9CC2A9285EB306922C0594025BA7CA6347A93BDFA8DE37C4B77E047898C0979C642B0AED36F47575E2340D366A8128BDA80445B7DD0E37CDD935F6F54F20D6D8F3622880F857CAFF24C564';
wwv_flow_imp.g_varchar2_table(42) := '3663F6EA3554058C06CF61707B862D4FF1CDB78C68CFB0E5A9FCF4185A68049AAB2D2DF0F884E86463000006BE494441548BD17F3F765F677088AE9D3C81A33F7B167C435B6F6BABFF122858BE02B2C984D67EE7E03123ED180A20B63EFC6B9DB9780992';
wwv_flow_imp.g_varchar2_table(43) := '92930374F6D0188EB727D58CDC312C0F07180ACF2CEA6DF1313D8EEFC7E69BFA07211AA34D7485AA544F5F2FF896DABA535F0C46295BACE0771DB934DCCC36789128EE1801A04179FCCFA6A7E6785F3B37788276EA2B2A54CB93376D3A8A56AF1E6179C8';
wwv_flow_imp.g_varchar2_table(44) := '0BB579C8F2D4D781DF98CAF0C85260D5C67EB4388628DF46D5195B229AC51FAD3AB365640C5EDA9A953DB8CF3B1E77F0B79FB1BF5874860288DFB0C1225A7CB7A4F2BEDF654F9F8E19F31760D6CD378F0A4FE5B16368AEAD51E1E16A2B5CF0F8E3E75B66';
wwv_flow_imp.g_varchar2_table(45) := 'F9EDAF83966858C37A018DFF4CBB7D1D4AA8E15CB8A4D41F0C3C3DC2EFAFB6CAA6C16346DA311440FC28338BDBDFEB7DC901EFFB1DDF1456B070E10878148F828B34F3DE44F0F03B7C22018F3F0D05D4A8CEA5C6B50AD1BE3D18FAF447B23D05B36E5E8D';
wwv_flow_imp.g_varchar2_table(46) := '8239F3FCDED56DE587EFA95B9E3251770CB6321440FC242AEBDBD7DEC19BE08EE0B97CE2389A69E69DE1E1AE7AB82DCFF04414DAEDE0C635F7CE828D135D3D72082D55553051559A4DE0C1801F4301946EB18001A8A9B80037C131AEDE74BE8AE069B87E';
wwv_flow_imp.g_varchar2_table(47) := '1D93058F3F3DDCBD572D1155635FEC7E112D155FFB4FD15641D3F97338435DFF6A1A87A203E081497E0080F78DE60C05108BCC3D9E6E9A76B8F8F9E770BA794C7AA4E41E9A3CF5C3634F4AC264589EE1A9604BC4B782284EA7FA0ABDE3D485FFEAE55FE1';
wwv_flow_imp.g_varchar2_table(48) := 'F87F3F83F3BF7913ADD7BD77424E258BC593B5C3C31BE5BBA100625179008FA168BB7219673EFA004DF50DEAFFDBA2B138B87A7BD1595F8F331F7E00BFE52989E27B0BB95D332F3D4DADD22CAE0174D39CDC407F3F2CB24CC7AC5890910ECE0FE7CBA8CE';
wwv_flow_imp.g_varchar2_table(49) := '7000B1D0FCFF2EB8DB3CD0D1894A6A477CF5DB77F0D9C1D77092B6678F1C465F4FB73A4ACCFEB8CAE330D172FC8F540AA971CD69F1FFB31506872D148314AD74852B5E43022451EEB9DB3C3F234D6D3F707B834795B9F1CAB75CCCF7FDEA213E1157403B';
wwv_flow_imp.g_varchar2_table(50) := '408A34B22F1DF1E40646C0BF609ED8E45F33B773F897CEB3E5FCAB0FF429BE8DA780C783D01FC7F55D503340921C7D807C79101B9D0AE8294BCD00D1E8BB666A75E657040FB3027ACA52334090DD51AFC2C2AC63E25E4E47596A06C8E2115558BC10A7A7';
wwv_flow_imp.g_varchar2_table(51) := '2C3503E49294F8ADC2E2858C09E6434F596A0648B298441536C1028A756F7ACA523340572C99CD244C1F39B1185B813E5F596ACA85668056BEF0C28022E1B8A65845A0985180CB90CB526B823403C411D288F0C7BC15CEB80AE82D435D00790001108CFD';
wwv_flow_imp.g_varchar2_table(52) := 'D15B86BA00EA4B4AFD94E413ED2012C1A04B9FAF0C35275F1740452FBDD4A740795373EC7117D05819E2B2E332D4936A5D007923569EF16EC5DA780AE82F3BDD00E5EF7D9DAB31D11B331E3DC77D65A72BE5BA01E2D81505C20AC1589F709559580072D4';
wwv_flow_imp.g_varchar2_table(53) := '341D20F9BC37F9D28E58625E81EBBE32D39DD0B000247DFCB18B88FEA1EED4880B4C8A028A47798ACB2C1C918505204E48FEBE036F4A8AF22CEF0B17BB0A7019E5EF7FEDED70A5306C0071827253B3FF5E827482F7850B498149F12CD1C02F975138230B';
wwv_flow_imp.g_varchar2_table(54) := '2B4012CD8FB9DDA6872981A1BFB68B028925A20AD42B1EF3162EA370C6125680386105AFBC7259722B7702CA65FE2E5C4C28500DC97DAF63FFFE91AFE5D799BCB003C4E9C97BE5B52F064C9E9580F401C427BA0A28F8FD80C9BDC2B1E7E0579148484400';
wwv_flow_imp.g_varchar2_table(55) := 'E2844EDB7DB039CF890DB4FF3C39B14447819FE60D48EBB92C22157DC400E2044BE5E56EC7DE034F5175460E4E3E26DCA428D0AB40DA42DAFF1D974124638C2840FE843BF6BEF6BCC9241503D23FD1049EF7BF98407C22A0C03528F867D27A4EFEDEF257';
wwv_flow_imp.g_varchar2_table(56) := '2370FD11979C148038D69CDDE5D71D7BCBFFD5E1948B00E92172EF824C1339B1E8508082BA25497A5B96A4FBF39CD22CC7BE03FFC25AD3F14959260D207F6ED8A4124807C96D303BA54C49F1DCA148D2D374FE6572A7C9B9C889657405589BD36465762B';
wwv_flow_imp.g_varchar2_table(57) := 'C0DFC81E699D6C7566E6ED29DF98BBA7FCFF595B4CF267D2011A9ABFACF2F2F6BC7DAFFF217F4FF9B38EBD0776915B4ACE4CA2A44966A90049A6D9D4FD5C06096B2149EB69087E632238CE2BD43CBB97B106AC056BC2DA905BEAD8776067FEDE03CFE4EE';
wwv_flow_imp.g_varchar2_table(58) := '2FFF24F7576F750ED574B2F7A30AD058996551F25E2AAF73BCFC6AA583BA9F8E3D078E3AF694BFCF43F089E038AFDE3C1FFC8A35602D5893B1F48AE6F19804289A8288B843534000149A5EC2F730050440C304115F43534000149A5EF1E33B4C39110085';
wwv_flow_imp.g_varchar2_table(59) := '49C844BD8C0028514B3E4CF916008549C844BD8C0028514B3E4CF916008549C844BD8C0028514B3E4CF916008549C8C4B94C604E0540817A886F212A20000A5130E13D50813F030000FFFFF3DE279E00000006494441540300F15875B7ED5ACE38000000';
wwv_flow_imp.g_varchar2_table(60) := '0049454E44AE426082';
wwv_flow_imp_shared.create_app_static_file(
 p_id=>wwv_flow_imp.id(95883182579598758931)
,p_file_name=>'icons/app-icon-144-rounded.png'
,p_mime_type=>'image/png'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/icons_app_icon_192_png
begin
wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table;
wwv_flow_imp.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000C0000000C0080600000052DC6C0700001000494441547801EC5DF97B14C7997E47D26866748C0E10022421848404421C0683B121891DDB21976D6C2771E224BBD964733FD9DD679FFD61FF8CECE3C4C926';
wwv_flow_imp.g_varchar2_table(2) := '5E1C3BF8247662C70E06E7C9E6706C2E8341DC208484242440B734926674A4BE9EE99E9A6146D333EA91A6BB3F414D5557575757BDF5BD555F7DD55D9DD5F3D52FCCB0630CEC2A0359E03F46C0C60830016CDCF85C758009C052606B049800B66E7EAEBC';
wwv_flow_imp.g_varchar2_table(3) := '8D09C08DCF08B00AC4326073047804B0B900D8BDFA4C00BB4B80CDEBCF04B0B900D8BDFA4C003B4A00D759438009A041C1013B22C004B063AB739D350498001A141CB023024C003BB63AD759438009A041C1013B20105D47264034227C6C2B049800B66A';
wwv_flow_imp.g_varchar2_table(4) := '6EAE6C34024C806844F8D8560830016CD5DC5CD968049800D188F0B1AD10B011016CD5AE5C599D0830017402C5C9AC890013C09AEDCAB5D28900134027509CCC9A083001ACD9AE5C2B9D083001740265EA645CF8B8083001E242C327EC800013C00EADCC';
wwv_flow_imp.g_varchar2_table(5) := '758C8B0013202E347CC20E083001ECD0CA5CC7B8083001E242C327AC8040A23A30011221C4E72D8D0013C0D2CDCB954B8400132011427CDED20830012CDDBC5CB9440830011221C4E72D8D80850960E976E3CA19840013C02020391B7322C0043067BB71';
wwv_flow_imp.g_varchar2_table(6) := 'A90D4280096010909C8D3911600298B3DDB8D40621C0043008C88CCA860BA31B0126806EA838A11511600258B155B94EBA116002E8868A135A11012680155B95EBA41B0126806EA838A1191048B68C4C806411B361FAC0F4343A477D38D33F889EB1714B';
wwv_flow_imp.g_varchar2_table(7) := '21C004B054731A5B1955F0CF0D0CE1D6C4042667A6D13D36862E9FCFD81B2D606E4C8005043F536F1D2DF833988928EACDF109CB90800910D1B4C103BF18F2FB27FCB8EE1BC3D591115C1A1CC2B9814134F70FE0645F3FCE8AF00511776968181D423518';
wwv_flow_imp.g_varchar2_table(8) := 'F0FB45EF182924C19CCCF5AB0A3ED58F7A7C59F02B56D5A2A26EB5562122018D065A8449034C8050C38D4F4D29FAAD2AECEDA3A3B8313E8E417F003E718E48313D13147212144AEF9B9C44AF500DDA4646857E3C808B82147DE23894A5693CAA0F115915';
wwv_flow_imp.g_varchar2_table(9) := '7CB9E0E52BAAB179D76750B969132A376CC0F29A1AED3491403B3069C0420448AD05A8F7A6DE9C1CF56824ECA9E5048C09A25C13230209D24D411E9530A9E697EEEB48F069724BE52522CBF72BAFACC21D0FEEC2CA3BEF84333F4F3B1590085E9093A3C5';
wwv_flow_imp.g_varchar2_table(10) := '9B35605B02508F7E657804D47B536F2E37A0C75B84CA2D5B517BDFFD687C7837367DE56BD8F6DD1F62E77FFDB7E26F7CE22B68F8F46751BDFD1E945655CB972A6112AC2EA13E9D1723C248605289CBB41F2228093EA93A72D9CA962FC7A6FB1FC4CA6DDB';
wwv_flow_imp.g_varchar2_table(11) := '905B58209FC284A8CFCDAE2E2D6EA9C7A385CD1AC8326BC1E7526EEAE949A71F0E04B46C72727351B16933EEF8A76F60CB77BE8F9542F897091294D6AF41414525720B0B95B4E4170AA12F6BDA80AA9D1F47A320C33DFFFE9F58F3D9CFA36C75BD9246FD';
wwv_flow_imp.g_varchar2_table(12) := '2122B40C0F2B7309352E537C22A85C9645E54BB1E9930F60D5F6BBE12AF222D65FD7F9B35AB4D7E98427275B3B366B20CBAC054FB5DCB7840523DA96BD5208F2B61FFC08350F7C0AF94B96269D759633178B1B9BD0F0C863D8FAEDEF6149C39A883C682E';
wwv_flow_imp.g_varchar2_table(13) := '41730B2244C4890C39587FDF2751B763075CC54588F747BDFF8DCE4EEDB4157A7FAA8CED0890ED7050BD235CCFE9660C775C8B884BF5C055548CFA877663F33F7F33423DA2B9C5656135CA4412E4959424ACAE157B7FAAB4ED0850E2CA45A598D4C94418';
wwv_flow_imp.g_varchar2_table(14) := '1BE847F36F5EC5B9D7F76142840998B9BABCB2258A7A54FB89FB80AC6C253B9A771009C857228CFA49733E56EDFD0936DB11802ABDC8E5C25A31DC97B95D70887F1447AEF74A0B3E7CF619B4FFF5CF989E0CCF0FE85CAA6ED9D6BBC424FA49B80B0A942C';
wwv_flow_imp.g_varchar2_table(15) := '48F8890413C262A44498E0A753D2FD0B2DA2FBABB0DB920054791A0196E7E5A1A1A810D4A814476E5A0866FB914338FECC2F70EB4C3345CDD9152CABC0A66F7C0B9EE2A0AA416A50EBF02832DD4C4A151F1796B29B92EEBFCC02961FAA97EA6C4B001500';
wwv_flow_imp.g_varchar2_table(16) := '577636561516A04638B708ABF1E323C338BFFF6D34BFF03C7CB76EAAD129FB396E0F9ABEF8049C2E9792C7C4F454465A8794C2493FD7CF9ED68EA8A3B082E547AB9008D89E000203E53F99F5EA85F9AF428C0A343A2891E267F07A174E3CB707570EEEC7';
wwv_flow_imp.g_varchar2_table(17) := 'E4C4DC9E84A409F25AB1AEE0703844CE00D9E047C56AB27290813FFE9111C8961FABF5FE0439138050083912CBC5625EB046CC0F168B9EDA119A1FCCCCCCA0EBD4497CF8CB9FA3FBF831913AF848840824FDDF5B5D83DA7BEFD7AE6B1F597855E8F0EBAF';
wwv_flow_imp.g_varchar2_table(18) := '21963B71F08056CE4CEDFDB502A618C84AF13A4B5F96237AE80A61296A10F30379B93F303E8ECB7FFA238EEF7906239D1D2963B074CB9DF02E0DAE37D0A4387A512AE58C755E480B813A936AC9ACD8FB53E5980084421C47F3835A6FA1323F7065656BA9';
wwv_flow_imp.g_varchar2_table(19) := '7C7DBDF8E8A5BDB8F8F61B295B8B2A857548CD909EC3A189B17A9C4E9F843F7A2170B6FB6589CEA0DCE3B6C4AA6FAC7A320162A1121547F38335C55E2CCFF38004423D7DE3DC399CF8D51E4C07FC6A946EBFB4612D3C45455A7A7A284F3B4853801EEF96';
wwv_flow_imp.g_varchar2_table(20) := '859FCCC11B4B4B309B5B5F520CABACFAC6829509100B953871656E3768FD80E6076A9231B170D679F8907A9894BF7CF3162DFDC044F224D22ED61120E1A74732D4A424FC9542CD538FEDEA3301926C79757E505D90AF5D39D076550B271358BC761D2054';
wwv_flow_imp.g_varchar2_table(21) := '0C883F7A5482E6032268F87F527B58F863C36A6202C4AED07CC53AB3C2D04D4ACFC827737F675E3EBC4BCAB54BD2310A90F047AB3DDCF36B9023DC8AE138D386860201D0CE0534DC4F09D3653A2BD2ED1BD3B22FAEACD2C2C9064A56ADD22E317A4D8070';
wwv_flow_imp.g_varchar2_table(22) := '60E1D7E08D19B0140106957773A7955719CF0F0C29AF2BC6ACF51C2307FD018C480B58E55BC2BA7CB2592FAA6FD02E999C9ED6C2730D90F0B3DA9318454B11C03F1516A0C99969E585757A4FD7C89E9596C0BAA46D4196AD5B8FBC456589918E9322AF4C';
wwv_flow_imp.g_varchar2_table(23) := 'A840A179807F9A728F933089E82E313AC9C25F1A7A0236892C6C93D4520488F57019BDA77B79685879F5D1085BFB2DB118E60FF5D439B92E54DF7B5F4C61196ABF8AB3AFBD8A9BCD27639E9723738575898E89B473A500093FBDEE48F99123E1AFCA0F4F';
wwv_flow_imp.g_varchar2_table(24) := 'D8298E5D18014B116052D2FB2B366D86FA1C3E5597ECECF40E2CA906B18842691239CABF5BDA19AD6ADB76E478C22F8CCBD75F3E78007DAD5770E1C07E9CDAFB2B8C765F974F4784734204A0485D6A10258CE1A86EB2F093A993853F065052549614367D';
wwv_flow_imp.g_varchar2_table(25) := '509EF856DEB303DBFEF5BB2893746CAA20A906F4B27A7F0A76779AF84E8748E6292A46C5F6BB29CB986E4A5A1C1BEAEEC689BDCFE1FAD1D8EB05392EB796873ABA68113A0364EDA1BAA9C949F8D9DAA3A211DFB72C01E8B9FE5CAF170D0F3F0ADAD5C11B';
wwv_flow_imp.g_varchar2_table(26) := '7AF686A02055A87D7454D9C747EFFC606C722A62525D7BFF0394555CB7E1C9AFA3B4266CE1A18457DFFF3B79B7B9ACEC7033A804BB2DD12C11A4F6C8D61E527B58F867014C3A15465E8A346BD0018756F499A9292D4CBB3A6CF8DA37B0E6339F83BB20B8';
wwv_flow_imp.g_varchar2_table(27) := 'BB039D4C667ED0214D7C4B5754A378551D6511D7B9C408D1F8F897D0F4E8E3707B8B94744515958A6FE40F09BFACF690F0B3DAA31F614B11C02DF7A4A189AA0CC56261B1D9F2DD1FA0FAEE9DC8713AB553343F20B588D488583D309DA75DE0E802872059';
wwv_flow_imp.g_varchar2_table(28) := '4D9CDEDF3F3C8CAE238731D6D74B4915575CBB1A777EE7FBD8F8E527D1F885279438A37E58F8E78EA4A508404F6FAA908CF7F7A9C108DFE170A06AC74E6CF9F6F7504E8F2284CE92E0931A4144889E1FD0E432940CCB376C8467516CB3E785375EC795BF';
wwv_flow_imp.g_varchar2_table(29) := 'FE3F3EDCF34BB48AC9EF94F4024D61E50A358BDB7C22D56D91092288AC72CF4F3ABF1D7AFE04B0247DDA6204085767B0BD7D56309C79F958FDB987B0F95FBE85126925579D1FD03E3EB4E0459BE3AA1353A7B0D6AC8863F6A49B052481EF14E6CF63BFFC';
wwv_flow_imp.g_varchar2_table(30) := '39065A2ED1A9595D962BF89A2425A2FB933F9B23E127B2AA6948F859E757D148CE0F4B4C72D765646AF999FD7E9DFBFCD022D6BA2F7F55D902912C3B6AC5E8E134127E22811AB7F2639F40766E5858D578D56FFAD29311BBC3D10B34E7DF7A533D1DD777';
wwv_flow_imp.g_varchar2_table(31) := '7AC25B0CD2643B6E4271824623167E018441FF2D4580026778B3565F4F37E41E39115EA5F56B14B588F6F1714A3DB27ADD0A61F32FDF78877A18D3A76D131B1E790C1BBEF8043CA58B9434F94B9628FE6C3F05D2037144BC7869A9E76753673C74528BB7';
wwv_flow_imp.g_varchar2_table(32) := '1401E8094D7A794585A2E74C784703352E914FFBF86CFDDE0FB172E7C7505ABD12159B3683D4A4151FBF37E6A501DFA898F81E8AD839C25B5D832DDFFCB632F15DFF95AFC7BC4E8E2CA90D5B9468B21D6B1420E1E79E5F46CD98709631D9644E2EA552EF';
wwv_flow_imp.g_varchar2_table(33) := 'DD75EC28E885F6644B97E5CC45E5F61D68FCE29795FD42494D8A97C7A5DFBF2926BE7FC6F15FFD1F2EEF7F0B81B1F0E783669BF8CAF9B98A4B345329C55F136B14F2231164ED9185BFD425CAC72FB310547376262280BEBA7A739DC87104ABE51F1A44CF';
wwv_flow_imp.g_varchar2_table(34) := 'B933FA2E4C31D5C4E8887665B7187168E7885E692735ED648240C51D9BB514B43E7133F4C80509BF6CED21E1AFE2677B34ACE61A084ACA5C73C9A0EB1DA22C2424C253FE77BCF737C54FD74FFDE71F8AE8BD27FD7E5C7CE70F49BF2C4FAA577E68DE4065';
wwv_flow_imp.g_varchar2_table(35) := 'ED191F57BECC280B3F597B58F8091DE39CE50840D09479DCDA28302E4681B683EF50745A5CFE92A5CA42D7CA7B7622DB195C5C236B52564E309CCC4DD73CB25B5BA0A37509DA384BBD9E48CDA64E150DE3FC2CE3B2CA9C9C82EFED864D8BD74E7D84FE96';
wwv_flow_imp.g_varchar2_table(36) := 'CB692D60A520C0966F7E074484F54F7E2DA57B79C402DBDA8777DF766D716E2EB8E7BF0D1643222C490042868446B6085D38F0074C088B0D9D4B972333281121DBE54EF9164535B5582748E08043CB83BE6413FD1927ED2407E68480650940A85415E423';
wwv_flow_imp.g_varchar2_table(37) := 'DB1114A4499F0F675F7E0164B6A47399EC4AC49A44E3EEC780D0647E6A6606F4520F930086FF599A00A40AC97AF3685F1F4EBEF03CC607070C07D2E80C4BEA5663DD238F422641CBD008980430F4CFD20420A44815AA926CE6E3838338F5E25E8CF6DEA2';
wwv_flow_imp.g_varchar2_table(38) := 'D319ED88044DBB1F151C0836D3E4CC348F0406B75810598333CDB4EC4A5D2EAC906CE77E61BB3FB9F779B41DFE0053D3E1F70632ADDC549EE2DAE048E0C80A3615BDF576796898470202C7001744D5808C323D0BFA3618EDE6E6084D2EA7037E5CFBDB5F';
wwv_flow_imp.g_varchar2_table(39) := 'C40AEE1EDC4CF0E4E842D78D4990BE16B00D0108425287EABC05706767D3A1E226FA7A7161DF4B3821D4A29E33CD9834E8DB604AE606FE10091A1F7E14421F02FDD96524A0BAA6D3D98A0004645E4E0E1A8ABC58E276D361D0092BCB6857072EED7F1B87';
wwv_flow_imp.g_varchar2_table(40) := '9FFE094E0BFF7A7B1B46C56AAC5FDA002B9878E17E694EC0136363F1B71D0154F896E57950EFF5C2238D06746EC63F81013112B4BC2A4685A79FC251E1DEFFD94F706CCF2F706AEF7338F7FA3E5C79F71D741C7A1FB7CE9EC6E88D1EBA6CDE1C91A0F1A1';
wwv_flow_imp.g_varchar2_table(41) := '87B5FBD1C498AD431A1C49076C4B0042CA93938D7A311AD047F2483DCA7238283AECC4049908312D26CDE3C2843AD47D1DBD575AD075F2235C7DEFAF38FF87B770E2F96771EC7F7F8AD6770F60A8AD1510969A7006E909958A7582A6471F873A312612F0';
wwv_flow_imp.g_varchar2_table(42) := 'C43835AC6D4D001532FAFE154D901B8B8B402653FA2C12BD5D761B21D40BA2FCF1E161749E1FBDB8C100000C4B494441543C8153FB5E1164783AF81DB1341321D69C804782A886D171C8049040A255633299D26791E88B30F47594A69262AC11A344B4AA';
wwv_flow_imp.g_varchar2_table(43) := 'E4C92F90AE0C07C7474694EF881DFBC5CFD0F3D1F1B48E08A40EC973021A099804E1B6D013CA6002E8297EFAD31029683B447A465FBDDBA2A5CBB061D72EDCF5D8E368FAC47D58B9AE09F9855EF5B4E2D3A870E98F0771EAD7CF61723CBC95BA72D2C01F';
wwv_flow_imp.g_varchar2_table(44) := '224193582C13FA90922B9180D521050A5D3F4C800430B58D8C82F605529391F0D7DD738F7A88FC45A5286F6840D3830F62E3FD0FA2527ABD91120D8949F247CFED81AFF7261DA6C5158BC53299046C22D50F33136016AC6E13FEF2A5A89B653F50B75095';
wwv_flow_imp.g_varchar2_table(45) := '2A366EC41D0FEEC2A2F2722D671A0D4EBDF0EBE024598B35364024687CF8112D532201AB431A1C71034C8018D0D0FBB8B4258ADCF3970AE1AFBD5BF4FC598E18574446E51616A06EC74ED46DBC038ED0139D937E3F4EBFFE1B0CB6B6442636F0A8747583';
wwv_flow_imp.g_varchar2_table(46) := 'B215235B87F483CA0488C28A84BF4D4C64E5FD8048F8EB84F03B7408BF9CDDA2DA5568DC197E538C36EC3DF3BBD7D34A8262A10ED1C45825018D043C27905B2532CC0490F03052F8D56C0BCACAD0F4F17BE1142BD014A78B0494700E8E49A01F3C264008';
wwv_flow_imp.g_varchar2_table(47) := 'AB74087F286BD0DCA051588BA249A02C9CA9890CF69904FA006502089C62097F594585D0E37708EB62629DBFE7E2459CDCBF1F036D6D22B7D8FF1512448F04BF7D2DED1363568762B7871A6B7B0290F05F1D1E81ACF32F5EBE1C35776D4762D1073A4F37';
wwv_flow_imp.g_varchar2_table(48) := 'E3AA70E3633E5C693EA5E21AD3778B95E675D24830353989334C829858CD57A4ED09D02EECFCF47D6115F03221FCB5C2D4A957F83B44EFAF5E5BB9BA5E0DC6F55DC254DA28460235C17C91801FA556118FF46D4B00EAF95B45CF2F9B3A172F133DFFB6ED';
wwv_flow_imp.g_varchar2_table(49) := '9108C539A29E3F42F8EBEBB1442C88C5491E117DE34AE4162D2A09863BDA23D21979A0AE1867BA75C8C83AEBC9CBB60488D9F393DAA3C3D4194BF82B9AD6EBC11BEDC78FE3FAD5AB5A5A7AD4820E8804A75FDB8774928026C63C1210DA61673B02CCDAF3';
wwv_flow_imp.g_varchar2_table(50) := 'A75DF83F14C2DFAAA14F2FE5D0CB39B9EAFBBE8100D24D021E0934F89580AD0840C24F135E59E727B567D53CF4FC6DC78E09E10FF7FC24FCF4520E6DE95EE72DC47C92804602B60E29F20FDB1060A185BFBB3D6C2255853FD8040093404562FEFDACF9BF';
wwv_flow_imp.g_varchar2_table(51) := 'E5FCDF3193855F45231E0946BA3AD42486FB3C1220934600C3DB57C9309384BFCCED02A93D4AC162FCC424C16F5E05932006580645597A048825FC4B2A2B315F3ABFACF690F02FCFCB4BD86CD124509E22651224C42DD5049625403CE15FB9F52E5D8F37';
wwv_flow_imp.g_varchar2_table(52) := 'CCC5D44913DE54845F6D4426818A44FA7DCB12801E6996AD3DE59555A821E1772406D558E177434FCF1F5D2A2201BD9B4C3E9D534782D19EEB749816A7CE09440FA1E46F8747A92D4700EAF96985577EB687D49EEAADDBA0E7E11E6385DF2584DF8354FF';
wwv_flow_imp.g_varchar2_table(53) := 'C8344A26D20812BCFA32D24D027ABDD2A1AE4DCCCCE08A58312732A45A8F4CBECE520420E18FB6F393F02B6A4F1A7B7E21239893DA338B84449320303181D3F34002799D20303D8DB691D1594A69DE53962240F4E30D4BE743ED11AC6B3B7A0473D1F913';
wwv_flow_imp.g_varchar2_table(54) := '89CF4291A0E153BBB4A2D1576A7A425FAED4222D10B00C013A467D11BB3750CFBF22CD6A0FF5FCAD470FA3A7E39A260A8B5DA4F6E469C746051682048B9B36A26253F8F3AD4400FA789F5175CA847CB232A110732D03F54EBD423550F359BC7C396AB609';
wwv_flow_imp.g_varchar2_table(55) := '6B4F1AD51EBA57DBB1A3B8D1115EA822E1AF903EC641698C744482DAC20265E598F22575A899D4A19B37E8302DAEE6FE07E014A4A6CC673083E1C024052DE32C4180EBBEF0C6532EB7072B37DFA9AB81529DF02A3DFF11D1F35F0B3FBE9C6EE1572BE4CA';
wwv_flow_imp.g_varchar2_table(56) := 'CE46C4C45810FFF42B2FC197240966C67CB8F4E66FF1FE533FC6073FFD1F5CFEFD1B9889B58197230B4BA5275D87027EB52896F04D4F80B1C929C8BBB6ADDABA15D9B9CE848D3317E1BF2AD49EF9ECF9A32B43230191204708279D0B08C16D2612DCD2BF';
wwv_flow_imp.g_varchar2_table(57) := 'F9D6A577F6A3E7E2054C4F8C636A6C0CDD17CEA1E540ECEF292FDB222C687423E1C605DEC233ECFF4267647A020C4A3D525E4929BC656509313552F81709F5209D6A4FBCCA044950800812BCFC227C3A49D0DB1E7E3255BDC72DE9813D358EFC5CAF174E';
wwv_flow_imp.g_varchar2_table(58) := '31B25278867E2CE44C4F009FD42315EB10FEEE0BE711FD26578534C4C76B5B6A789AF0CA3D3F09BFFC15CA78D7A62B3EA80EDD4E82B1347C00703AF4E59C6902225D155A807C4D4F00B251ABB815942D518371FD6BE7CF6BE72AEBEBA15BF885CE7F539A';
wwv_flow_imp.g_varchar2_table(59) := 'F02EB4F0AB95884D82173096602FD2C5D52BD52C34BFACBA5A0BCB8189817E4C4D0627BFD362222C9F337BD8F404F08B451AB511F24A4BD4605C7FC5DAB5CAB9AAFA065DC24F89DB8E1C41260A3F958D5C3409FC42A76F16EAD06C2341DDAECF6059C31A';
wwv_flow_imp.g_varchar2_table(60) := 'E4B8DC707AF2B06CCD5AACFAD4A729BBDBDC2DA9D37065995E6422EA6799DA381C0ECC84268511358C3A2817824FDB9A2F6F6A8A3A13E3508CF7AD873E88B0F3674ACF1F5DDA982478E5453112C4FE1EB243087DED43BBB1FD47FF81BB7EF86FA8FDFC23';
wwv_flow_imp.g_varchar2_table(61) := '7084F4FCE8BCFBA497F88B7273A34F9BFA780109600C6ECE90D0CF08DBE4D8C88831998A5C6684F0B71C3E841B5D5DE228F83F53853F583AE03612F87C687E99D4A1D82450AF9BCDA797F407BB3AB524453A2C6C5A6213044C4F00774EB80AE38303C640';
wwv_flow_imp.g_varchar2_table(62) := '2E84BFF5C821DCBA1E16FE52572E1672C2ABB762B79180D4211A09FA7BF5661191AEE5DD03DA71A1D3A92DC26991260F84A5C7A415A146518B3ED82F266B4278D5E3947C71FD1521FC37A59E9F84BF2A3F3FA5EC16E2222241ADB700D9422DA4FBFB9591';
wwv_flow_imp.g_varchar2_table(63) := 'E0458C4884A6F8D95CC0378A93BF7E1623BD61E298A10398AD4EB1CE999E00F4413BB562C3C24AD33B073548557B64E12F113AAF99845FC5C29D9DADAC18ABEB04FE5121D02FED45A798D300B3DB32E91B06279E7D06C33DE14FC02EF578406B0F6AFE56';
wwv_flow_imp.g_varchar2_table(64) := 'F14D4F00EAEDD45160DA3F81CEA347E00B04926F1FD1F3C7527B561498A7E78FAE349180460267C87233232C66ADEFFD05675E7A41F99225ED4E4D3DFD94580DA670C7FBEFE1ECAB2FA1F9B57D204B929A1F7502E51EB77A6829DFF404A0D6908766BF98';
wwv_flow_imp.g_varchar2_table(65) := '07B49DF808E35353744A979B9C98C025D1F8F3D6F3EB2A9531898804ABBD85C81323829A637F67072EFFE98F38B5EF151C7EFA297CF0D48F95F05581415FD46A303DE364E64E40AD733CDF1204A0A1B95AEAA9873ADA71FADD77D1DBD707611C8A577725';
wwv_flow_imp.g_varchar2_table(66) := '7EF87A374E1D3C80BE1BE1272A8B85DA63A546A711A0AEC8AB4CE2092BE8F8A351B5DEEBC5423CE6A1A3788625B10401080D125A7924981293B896BFFC192DA79BD13B368E21FF24E8B109DFA80F7DD7AEA1E3C4099C7BF720CE7EF0770424958926BC32';
wwv_flow_imp.g_varchar2_table(67) := '99286F2B387A329CCCB86B8B8B50535800526B6874C80A4D9489248461557E1E1A459A55228D2727DB0A559FB50E962100D5921AB8B6B050B37ED0DA40EFA58BB8BCFF6D9C7BEB0D34BFF93B341FD88F4B629ED0D97A0543C3C37499E21C70A0222F0F55';
wwv_flow_imp.g_varchar2_table(68) := '26B2F628054FE1C72BCC9934C2D1BEA4EB4B8AB151ACA093D013F14B5D2ECB993A6783C85204A08A163873400D4BBD191DEB71793939A82F2AC462B74B4F724E6321042C47006A1B1ACEA937A3C91F99EFA8C7A3E13E5B0CF734E4BBB2B241E653DAA393';
wwv_flow_imp.g_varchar2_table(69) := 'D4014A47E7E95A76E94520D372B724015490A96727F31D09798398043689E19E86FC35C55ED40ACB086D5348E450D3B36F3F042C4D00FB3527D73859049800C922C6E92D850013C052CDC9954916012640B288717A4B21308F04B0146E5C198B20C004B0';
wwv_flow_imp.g_varchar2_table(70) := '4843723552438009901A6E7C954510600258A421B91AA921C004480D37BECA22083001E6A321F91E198B001320639B860B361F083001E60365BE47C622C004C8D8A6E182CD07024C80F94099EF91B108300132B669AC51B04CAF051320D35B88CB975604';
wwv_flow_imp.g_varchar2_table(71) := '980069859733CF7404980099DE425CBEB422C004482BBC9C79A623C004C8F416E2F2A51581341220ADE5E6CC190143106002180223676256049800666D392EB7210830010C819133312B024C00B3B61C97DB1004980086C01895091F9A06012680699A8A';
wwv_flow_imp.g_varchar2_table(72) := '0B9A0E049800E94095F3340D024C00D3341517341D083001D2812AE7691A049800A6692A7314D46CA5640298ADC5B8BC8622C00430144ECECC6C083001CCD6625C5E43116002180A27676636049800666B312EAFA10818480043CBC5993102F382001360';
wwv_flow_imp.g_varchar2_table(73) := '5E60E69B642A024C804C6D192ED7BC20C004981798F926998A001320535B86CB352F0830018C8099F3302D024C00D3361D17DC0804980046A0C8799816012680699B8E0B6E04024C002350E43C4C8B0013C0B44D971905377B29FE010000FFFF1177F1B0';
wwv_flow_imp.g_varchar2_table(74) := '0000000649444154030026F1E575845B00710000000049454E44AE426082';
wwv_flow_imp_shared.create_app_static_file(
 p_id=>wwv_flow_imp.id(95883182821203758932)
,p_file_name=>'icons/app-icon-192.png'
,p_mime_type=>'image/png'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/icons_app_icon_256_rounded_png
begin
wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table;
wwv_flow_imp.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000001000000010008060000005C72A86600001000494441547801EC7D097C1CD599E7F7BA5B92751FB6D4926F902CDF37108C39CC11C0C012F031015B9C1972CC6C7E33BBC9FC323B3BC932497637BF9DEC6E76';
wwv_flow_imp.g_varchar2_table(2) := '3293830C60B065606419DB408081190CE18EEF43966F593E64DDF7ADEEDAEF2BA9AAAB5BDDEAABBABABAEB93EA75BD7AF5CEFF7BDFFF7DEFBDAA5736E03F468011B02C024C0096AD7A2E382300C004C0AD8011B030024C0016AE7C2EBAB511A0D2330110';
wwv_flow_imp.g_varchar2_table(3) := '0A6C18018B22C00460D18AE762330284001300A1C08611B028024C0016AD782EB6B511504ACF04A020C16746C08208300158B0D2B9C88C808200138082049F19010B22C00460C14AE7225B1B016DE99900B468B09D11B018024C0016AB702E2E23A04580';
wwv_flow_imp.g_varchar2_table(4) := '09408B06DB19018B21C00460B10AE7E25A1B01DFD23301F822C2D78C8085106002B05065735119015F0498007C11E16B46C04208300158A8B2B9A8D646C05FE99900FCA1C26E8C8045106002B04845733119017F083001F84385DD18018B20C00460918A';
wwv_flow_imp.g_varchar2_table(5) := 'E6625A1B8140A5670208840CBB330216408009C0A792A5EFAE4D6B7FF2A1BCA6273716B73EF5C88C8EC7365ED3B469FD9C86CD1B17343EBA7E4973C5BA15CD9B36AE6463420CB06EA88EA8AEA8CEA8EEA80EA92EA94EA96E7DAADBF297962480C6AF7FBD';
wwv_flow_imp.g_varchar2_table(6) := 'B471D386758D9BD7FF5DE3E60DBBD01C4473198DD4D496393034EC689786A58691A191FA41B7744E12E2940DA4E3601387DD926DBF5B48FBD8981003AC1BAA23AA2BAA33AA3BAA43AA4BAA53AA5BAA633454D754E7BBE436406D61D3BA6BADC806962080';
wwv_flow_imp.g_varchar2_table(7) := 'A64D1B9735566CF861E3E68D1F366EDED0030ED71910500D207E04005F43B30CCD54347C580301AA6BAA73AC7B6C03D41684ED2CB58DAB151BF65EDDB4E16F1B2B1E5E9A2C504C548EA42480E31B37A6366D5A7F5F63C5FA5F5DDDBCBE5E12D24190E0C7';
wwv_flow_imp.g_varchar2_table(8) := '00D2AD0846261A3E18017F08640A096E13027E0292FD1012C2396C47BFB8BA79C39DD4A6FC054874B7A42280A68A8D655859FF634AAAACB6BF0592F88E003123D12B89F31F3704AEC1A1C45F0880F7A94D356DDAF0DFA98DC52D37314838E109A069E3C6';
wwv_flow_imp.g_varchar2_table(9) := 'ACA6CDEB9F4615FF0F92249DC6CAFA2F88D334347C30027A22304D12F037D4C61A376FF8A869D3C627A9EDE999403CE24A680268DCBCF1612955FA5C02F13C4870733C00E4342D89C02D38AC7CD19D2AED6DDCB4FE1E3323102C6F0949000D151BD6A0F0';
wwv_flow_imp.g_varchar2_table(10) := '7F8663FA9D58C08568F860040C4700B5CD9520C43BD416A94D1A9E011D124C28022095ABA962C32B36093E40E1BF5187F273148C800E084837529B6CDCBC612BB5511D22342C8A8421001CE3DF84EAFE614982470C4387136204C243A0424A731FA287C4';
wwv_flow_imp.g_varchar2_table(11) := 'C20B163FDF09410028FC8F83DCEB83251FD6885FF3E094C3464012A56E217D2AB7D9B003EB1B2094D84C4D00128068C2A51714FE970020150D1F8C402220904A6DB669F3869F983DB3A625007AF00201DC414B2F660791F3C708F843003BB0BF6DDCB4E1';
wwv_flow_imp.g_varchar2_table(12) := '256ACBFEEE9BC1CD940420AD59E3284C95AA11A07568F86004121701018F4F4995AAA84D9BB110A62480A669535E46F67CC08C80719E188108107810DBF48B11848B3848A8014D47003879F233CCFCA368F860049209818AB1B66DAA32998A00AE6EDEF0';
wwv_flow_imp.g_varchar2_table(13) := '973879F2035321C4996104F44240821FC86D5CAFF87488C73404D0B879DD6A01F0BF75281347C1089816016CE33F6F7A74A3691E5B370501C8B3A442D0529F29F263DAD6C3194B0604EC924D7A516EF3312A4D38D19A42E0A6A4493F064994869371F6CB';
wwv_flow_imp.g_varchar2_table(14) := '0824300265729B374101E24E00571F7B781148F07D1360C15960048C4300DBFCD5CD1B171B97A0FF94E24E00C26DFF2966CD8E860F46C04A08D80548717F5230AE0480CB2237618D7F0D0D1F8C801511F89ADE1382E18218570240D5FFEFC3CD30FB6704';
wwv_flow_imp.g_varchar2_table(15) := '920901B75D220D386E458A1B013456AC7F084B4D1A009EF86004AC898090E0B6A68A8DF7C6ABF471230009C45FC6ABD09C2E23602604DC20FD75BCF2131702B8B269DD2C643EDAA23B5EE5E6741901D32040B270F5B18DD7449BA148C2C78500EC36DB53';
wwv_flow_imp.g_varchar2_table(16) := '985981860F468011001042929E8038FC194E001200AE7EC093C07F8C0023E0414082C765D9F0B81862339C001A37AFFB0A966C161A3E180146C083C03563B2E17131C06638010861A3D97F038AC6493002898500CA46C4AB019196D41669C088C349C2F0';
wwv_flow_imp.g_varchar2_table(17) := '42469C570EC8081889800486CB86A104D0FCC8235301A4254662CA6931020984C00D6D1B37E61A995F430940B2B9EEC6C2F1EC3F82C00723E00701319422ADF5E31E332763094048FC359F985525479C0C0808016B20CCBF68BC1B4A0098D16568F86004';
wwv_flow_imp.g_varchar2_table(18) := '1881C008182A23861180F4ECB394168FFF03573CDF61040881C563B242F6981B12CA98274209349F3A4EC29F4E76368C00231010818CD69347CB03DED5F98661042009378FFF75AE3C8E2E3911181122E46140B40818460000C6150AF88F11486004840D';
wwv_flow_imp.g_varchar2_table(19) := '9292006603FF31028C407004249817DC933E3E0CD400A0589F2C732C8C40B223200CEB2C0D2400890920D9DB2D974F27044293153D123384009E1D5D029CAC4786390E46C002081418B514680801FC79FD814CAC34071A3E180146203802290DFBF74F0A';
wwv_flow_imp.g_varchar2_table(20) := 'EE2D7A1F861080C36DE37DFFA3AF2B8EC14208A44FB6A71A515C430860D0250C298C1180711A8C801108049319BDF2600801D825C11A805E35C6F1580201A364C61002181A71F1F8DF12CD960BA9170246C98C21046003D600F46A181C8F3510304A666C';
wwv_flow_imp.g_varchar2_table(21) := '46C0694B4BE321801140731A4983C04432A367210D2100BB1B781250CF5AE3B860D0E54A6A146C1218D2691A420043495D555C38231168191884131D9D50DBD905E7BB7BC02D4946266F585AC3D250F2108061A871424989000979F3C000D4A0E05FEEEB';
wwv_flow_imp.g_varchar2_table(22) := '8321B75B2E67D7F0B04C02C94901721163FE63880610F3527002498900097E53FF00F6F85D70A5AF1F86C7045F5BD89E91114B9180B6EC7AD89900F44051A7385CA8CE760E0D0335FA8BBDBD70B6AB1B4EA2AA7BBCBD130EB7B5C3D1F60EB91724B73378';
wwv_flow_imp.g_varchar2_table(23) := 'EF0AF6863DC3233AA56E9E680887C631C16FE8EF871169B4C7A71CDA1D0E9839771E144D9B4697B2E9464DE0424F8F6CE79FF0106002080FAF98F8EE181A927BB16328E075D890A9D1B70D0E01F56E0338D9A50800F588D40B925B2FF67CCD381E3EDBDD';
wwv_flow_imp.g_varchar2_table(24) := '0D14AEBEA717129D0C48F01BB0A72755FFAA1FC19F513E1796DDB3164A162E8459D7DF0039059EF7CB8838099B9854501247CA0410A7CAA5C67AA9B74FEED52FA0F0D27836D2AC90E0B4238910199C428DA11DC923D2B8E2116E04359F2B6382DF84637D';
wwv_flow_imp.g_varchar2_table(25) := '223A251FC2668319E5E528F8F7C2D4458BC09136BAA06443F7ACBC3CC51BA4E2750A1AD5812D2121C00410124CFA792261BD82AA3BF572AD8383E366B1D37373A1E09A6BB1975B0C336FB8114A6FBF13E63FF0202C7A681D94DD7197ECE69CBF00F2A74D';
wwv_flow_imp.g_varchar2_table(26) := '077B4ACAB88CF5A3C6508FC3078A9F7AC5711E4CE640B3FAC751F369F6157C2160FA9C39B0E2DEB528F88B51F0D3BC72EE42FF57CE9F53DD9CE986BC3CA7A6170F4B2CD264028805AA01E22481AFEDE8826654DDB55ED2F3F261E65756C18AA7BE012B9F';
wwv_flow_imp.g_varchar2_table(27) := 'F90E2C58FF2750BAF67E9879EB1A2859793D4C9EB700F2CACAA178C575B2DB9CFB1F84858F56C0AABFF81E2C5AB701A62D5D0E19F9F9DA28E509331A4E9076413DACD74D135D90AAAFCD8E1028F8657350F0EF83698B978063927FC16E3871020035070A';
wwv_flow_imp.g_varchar2_table(28) := '4BBD7F419A3741903B9BE008300104C748171F2488A4F28F6826B4D2737261EEBDF7C1CA3FFD26CCBCE536C8985C18765A79D796C1355FBD07567CE35BB0E44F1E819C62EF8D97687EE124928E59B501D288944297CC9A352AF84B50F027E8D1875183BA';
wwv_flow_imp.g_varchar2_table(29) := 'CCBDBF025B54672680A8E00B3D70FF88CF936B363BCCBAF916285CB404231168A23F7266CE8625154FC282071FF2D2088874481B68C32147F4A9C42E86A2D239E09840F095941B6AB1F71FBBE0DE7F0C88084F4C001102176EB0A2741F15D5ED82DADFBF';
wwv_flow_imp.g_varchar2_table(30) := '09C75ED9067DAD2DE14637A1FF82F279B0E2E96760FAB2E55EFE2EE2A4238DB9BD1C13EC6218CBD070E1829AEBE2746B7C6B462DB0CE1626009D010D141D8D5117E4E5426EAAF7C45DC7E54B7070CBF370EEBD776064702050F0F0DD850D66DF750FCCBF';
wwv_flow_imp.g_varchar2_table(31) := 'FF3F80CDEE79AA949EA44B6412B872A2C66BEC9F37B62A103E401C8210600220140C32B44C353B2B0B4AB3B361924628259CCCBA72F810ECFFDD6FE0EA817D981BFD1E6E9D3C7F212CDDFC184CCACAC678470F2281669C451FBD4A9C5FEAFDAF5EAC5733';
wwv_flow_imp.g_varchar2_table(32) := '4C33FFFA0C9ED4282D67610288439567A538A03C3707A66766804378AA601885F2CCBFBF0F075EF867E8BEE469E810E55F6651312CD9FC38A44C4A5763BA82EBEED13C7BA04664A0E572CD71AFDE3F9F67FEA346DFD3FAA28E8A23080701EAB92663039E';
wwv_flow_imp.g_varchar2_table(33) := '9797038593D240E0BF12BEAFAD150EBFBA1D4EEEAE86A1AE2EC539AA732A6A1D0B1E5E07C2E6A9725A95D03E74135502310E3CD4DD038D9ADE9FC6FE22C6699A25FA58E6C3D31A62990AC71D1001BB1030352303E6E6664396C3E1E5AFF9F469D8FFC273';
wwv_flow_imp.g_varchar2_table(34) := '50FF870F015CD13FF39F3D6D0694DD79979A063D8D488FDEAA0E71B60C7476406F4BAB5F537FECA89A3B9AF9CF4F4B55AFD91239024C009163A76BC8349C1328CDC9069A2348C325422572D7C808D47FF119ECFBDD6FA1855460E5468467E7D215F28343';
wwv_flow_imp.g_varchar2_table(35) := '4AF0165C1AA4F70A946B23CFBEDAC7C9FDFBE0D8477BFD9AD6862B6AD6A8F7572FD81215024C0051C1A77F605A25988BC382125CDEB2A176A0A430D0D38DCB866FC0D1CA97A1AFA559718EE83C1BB500EDA4E0C59E3ED06FDA31B42C517AB4A14768BE3D';
wwv_flow_imp.g_varchar2_table(36) := 'BE881CB9F7F7E011AD8D09205A0463109EC6B645E993603E2E1B16F8A8BA9DD8131EC065C3F3EFFF6BC4290B9B1DA65F7F831A7ED0ED82CE21E3F66DA29E9F849FDE765433118285264C69E23404AF49E325D60561028835C251C4EF400D6046662694E7';
wwv_flow_imp.g_varchar2_table(37) := 'E44086CFFCC0E54307A0A6EAB588632F5E793DA46664AAE1E99161F522861645F8E91D7E25199AFB589C9F074B0BF227340BF37381565094707C8E1E012680E8318C790CE90E3BCCC1F981994806F42C819260DB85F3D07870BF7219F679DA8AEBD4309D';
wwv_flow_imp.g_varchar2_table(38) := '43C3E3DE4C546FEA68A9EBE995F73950A224E1A7B90FED7047B9C7E7D823C004107B8C754B81C6BEF37273202F35558DF3EA91C3AA3D5C4BE182855E4162FD5CC0395CCAD3F6FCD92929704D7696571EF8C2580498008CC53BEAD4A8A7A4894225A2E181';
wwv_flow_imp.g_varchar2_table(39) := '7EC51AF63915871659530AD570A405A8173A5B687B335FE1BF16859FCAA3735249139D11056102D001651A3FC752787CB3D8AAD94F203D27D7F77658D705D796AAFEFB70C951BDD0C942637E127EED841FF5FC24FC3A25C1D1448100134014E05150DAC0';
wwv_flow_imp.g_varchar2_table(40) := '93DEF5AFEBE981D39D5D10EB3575221AAD304D9E3B8FB211B129282B53C32ADB6DAB0E515A48F87D67FB69CC3F3BCB33F91865121C3C4A049800A204B04FF3845E9FCB0567BABA8108819EB28B32EA71C169EDFC4A5F9FEA3E2927079C4BBD5FF9556F86';
wwv_flow_imp.g_varchar2_table(41) := '68C99A3A0D00571B60EC4FAF7C535E7D855FEEF9713293D5FE31B04D70620288B21246DCD4D4BD23A121017DB986B6BBA25ED0FB6EE4572D0303EA473128966BD7DC01C26E27EB3833D0DE36CECDBF838054CDB65B7A680184C8392442ADA642C24F137E';
wwv_flow_imp.g_varchar2_table(42) := 'F48C83FF7CB0AB1601A3EC36A3124AD674B45B5A3970565B2927093EED6D4F7BF8132128EEE19F8B710000100049444154919E472409283E257CC18C995050EE5FFDEFAC3B07FB9E7F0EF63DF76B683D715C0912F09C929EA1DE8B5603A072FB0A7F0EE2';
wwv_flow_imp.g_varchar2_table(43) := '42637E167E1566D3589800A2AC0A2D0194DFF700CC5A75136889807A541A129CC61E91F6F38F34B9C6BE7E50D212369BBC0F60A0B89A8E8F0AFD4057279C78EB0D38B4E5F9095F2F4ECDF48CC9A32100EAF9FDA9FDB371B63F505ED93DBE0830014489BF';
wwv_flow_imp.g_varchar2_table(44) := 'B7C00898B1FA5658F1F437C1396F8157CC34C34EDA007DF1877A73AF9B412E8838E8A51DC5DBB4A5CB205DF3510CC55D394F993347B1CAE79E9666F9F5E2966347E46BDF1F475A9AEA34EC6748A3DE0C62E19E3F084026BCCD041045A5283DB21285E41E';
wwv_flow_imp.g_varchar2_table(45) := 'DDF893DEBD9FF3C083B0BCE209C82E2C526ECB67FAE24F6D47A7FCF92FEA3165C7203F977B3D137FB4A9C7CCDB6E9F30443E0E0D966D7E6CDC0EC1CDA74EF90F17A56E4EE5F0B7D4C73DBF7FB883B91A799F09200AB469365B80506370E32A807A8196CC';
wwv_flow_imp.g_varchar2_table(46) := 'E21258FAC4D3F2D6DF691A359B88833EFF753284EDBA7D97FD66DF720BD81C2918FBC44756C9347987E0F90F3E04E979F9B267E742EF27FF6447FA2109A673048682FAF6FC3CE1170190710AC2041005F002C3A6D93D10BA7BFD7FA0B270D11258F9EDFF';
wwv_flow_imp.g_varchar2_table(47) := '287FFC833E6E89C1E483DEC2A3E707A8F71CF4210FF240C2A55DF6236DC2B97405DD1A6768E7A0133BABE4CD43DC23C3EAFDC9A80DACFCD36FC1CDDFFF6B28983B5F75D7C3E26FC28F855F0F648D8BC3D37A8D4B33A952D26EEED9D7D414B06CA42DD0C7';
wwv_flow_imp.g_varchar2_table(48) := '3F563EFD0C14CE29F7F247CB65B46C48AA3E6907CA4DDF65BFD2BBEE566E8D3B5FF8F003683D7756DE3C8436176D3B553BCE4F40074154A6DC25DA51EC81CF24FCBE137E3CDB1F182FB3DE610288B266B404D0D1E0D9B52650B4A939B930F76BEB60E923';
wwv_flow_imp.g_varchar2_table(49) := '9B40FB1C3EF9A789BE13383FD0323008F419B12B38F34FEE649CD87B674D9B4E56BF6658B3A5F8207D1B70CF2E208DC0AF671FC754CD32E080CBF3296E1F6FEA6520E1A7757ED5135B2242C0E8404C005122AE1D02F4767484BCB77FF6F499B0ECC96FC0';
wwv_flow_imp.g_varchar2_table(50) := '9CAFDE0334B1A764833400DAB69B36EC54DCE8FEAC357728977ECFF31E5A0753972CF5BA276B041FEDF572F377E1C848579D69B542BDF06361E1F7034A023B310144597934E6D546D1511FDE76DEF428EFF5DFFE3398BE7CA5361AD59E9A9E0E8BBFFE08';
wwv_flow_imp.g_varchar2_table(51) := 'D0CA82EAE8C76273A4C0B577AF85A58F5640E6E4C9AA8F2C9F6F05AA373496CC22A77A450434ECF6AF0590F0D32BBD3464510290DACF3DBF8246E29D9900A2AC33DAD5373F35558DA5318427EF54CF631612DED9777E15AE7FE6DB50BC7031280FE63817';
wwv_flow_imp.g_varchar2_table(52) := '2C8215DFF82664147A04742C887AEA6D6C50ED64C9C661C2F2A79E81B23BEE82796BEF87029C0424F7894C9EE68D40F247C30F3A6B8D22FCDA979D58F8B50825A69D0940877A2BD03C48D37EEA24F4767644146B5A6E1E94A1D0DEF09DEFCAB3F673EE7B';
wwv_flow_imp.g_varchar2_table(53) := '001C933CEAB96FA4A7DFDC0307B7BE045FFCF2FFC2952F3FF7BA5DBCE23A988264E2E518E08208287FC64CF56E53FFA0FC7971C5C19FF093E6C3EBFC0A42FA9CE3118B2D1E89265B9AB44F1DED55AF94ABFEF34F156B4CCFED75E7E5F8870707E11C8EF5';
wwv_flow_imp.g_varchar2_table(54) := 'F73DF72B683B7D52760BF7A764B96779510209681E82E20824FCA4F60BF2C026A1116002D0A9FAE82B3F4A546D276AA01F67E295EB589D67DF7A9B57D4035D5D50B3FB75E8AC3BE7E51ECA050D15B45A003D804486C6FC5AB59F7A7E7EB127144413C30F';
wwv_flow_imp.g_varchar2_table(55) := '13804EF53465521A281B764A232370E6FD77758A397034454B96C18A279E866CCD241EF91ED6EC1940D7A19A396B71C891EA792F801E52D20A3F8FF943453271FC3101E85457F4A0CF54CD725AE7E95370398A1D7B43CD564661112C7DFC29285D733B38';
wwv_flow_imp.g_varchar2_table(56) := 'D2D22077EA349CF89B0B91FCA5E6E4C0BCFBEEF71B94849FC6FCC2EF5D768C168178856702D01179DAAD57BB6167DD871F404F73A38E29048EAAE4BAAFC08DDFFD4FB078D36340937A817D4E7C27AFAC1C4AFDBC6C441A0E0BFFC4D825E25D26009D6B6D';
wwv_flow_imp.g_varchar2_table(57) := '5A4606903640D1D250A076D74E70F57BDEE62377B39B92EBBF0265B7DDE195CD3ADACF7F78C4CB8D2F121F0126009DEB90E601A66A8602039D9D50BB7D2BB802BC28A473F2BA45577CFD0D507AFB9D6A7CB41A70BEA7077A9804544C92C1C20410835AA4';
wwv_flow_imp.g_varchar2_table(58) := '15019A2D57A26E6F6F87A3955B61A8B35D714A8873C9CAEB99040CA8A97826C1041023F4699D5C4B023D5D9D7078DB56E86F6D8E518AB1899648A0ECF6BBD4C8154D40BB3AA0DE644BC221C00410A32AA3093322019A3D579218C4B98043DB5E86FA4F3E';
wwv_flow_imp.g_varchar2_table(59) := '02DFCD43143F663C17AFBC0E7C49E05C774FCCBF8160462C922D4F4C0031AC5122015A3AD3AE0CB88687A1FEB34F61FFF3BF85A653B52049A1BD7F1FC36C86143593404830259C2726801857994C02595940138336CDC61B835D5D706ACF2E38B0E57968';
wwv_flow_imp.g_varchar2_table(60) := 'D8F7058C44F18DBF1817418D9E48A0D46762903501159E882CF10EC40460500D144E9A04F37273803E8DA54DB2BFB505CEEEFD00BEF8F53F42CDCE1DD08C5A816B6C7351AD3FB3D8FDCD09300998A576C2CF071340F898451C8296084B73B2617AA6E759';
wwv_flow_imp.g_varchar2_table(61) := '012532C9E582B67367E0246A059FFD9FBF873FFEE69FE0D0D617A1A6BA0ACEBEF37BA8FF682F5C3DB00FDA4E9F82DEA6AB308CF3094A58A3CFB226A0795888260699048CAE057DD26302D007C7B062A165C20579B9321164D8ED7EC30EF674434F6323B4';
wwv_flow_imp.g_varchar2_table(62) := '9D3F0B0DC78E40FD979FC3997F7F1F6A76EF84832F6F812FFEE91FE0CB5FFD03D02BC12D35C76044B32598DF087576941F16F2591D6012D0196403A263023000647F49D8713E8088600E0E0BE6A2A121824384571D437D7DD0585B03B5BF7F133EFFE52F';
wwv_flow_imp.g_varchar2_table(63) := 'E0F86BDBA1FBF2457FC9C5C48D3581E8603543E8F05A9C19729C8479A08D45699270617E2E2CCCCF032284D2EC6C98959509CEF44910EA5FFBC57A38FC4A259CA8FE17E86B0EBC4371A8F185E28F34019E180C052973FAB199335BD6CD950335032204DA';
wwv_flow_imp.g_varchar2_table(64) := '64841E24EA1EF2ECF14FA8E44E9E022BEF7F0016DD722BCC5EB810F20BBDBF3C447E5ACF9F83032FBF386E9720BA170B53E2E789411A0E04DB60341679E138C3438009203CBC0CF3AD4CACF5E1E4A09228097FF9EAD5E0484B83CCC24270CE9D07E5B7DC';
wwv_flow_imp.g_varchar2_table(65) := '022BEE590B33CBE7426A8A676F4290247997A013B8B220B962FF120F9180EFC34267BB7B804940A93D739E6DE6CC96B57345C2EF2B3C8AF0DB1C8E71E0A4E0AA42C9A245B074ED7DA8152C06474A8AEAA71557160EBEF4220C46B84FA11A5108169A1360';
wwv_flow_imp.g_varchar2_table(66) := '1208012800308B2F2600B3D4C4583E020BFFCDE04FF8C782C9279BC38E5A41392C438DA078D66CD98D7EFADA5AE1100E09BAEAEBE832A68648A074CDED6A1AFECAA3DE644BDC116002887B157832E04F583C3DBFDDE33188CD9E9A02B356AE446D6091EA';
wwv_flow_imp.g_varchar2_table(67) := '93360E3D565D05469040C9755F19F7EE80AF46A3668C2D7145800920AEF07B1227E1F79D38F308FF78B5DF1332B0CD39772ECCBBEE06D503BD80641409C89A809FC786794E40AD0E535898004C500D8AF06B5FB18D56F89562E5CE9C01F357DD04B6B167';
wwv_flow_imp.g_varchar2_table(68) := '0C8C2401DF8941174E4CB22600A0D48D19CE4C0071AE053D847FB877E22DC7724A4A60DE8D3782C07F2AAE9124409A004F0C12EAE6344C0071AC9768851F3B5438FBF96770E0DDB7A1F6C3893F029A8D2430FFE69B9102845C6226011906CBFF3001C4A9';
wwv_flow_imp.g_varchar2_table(69) := '09E821FC673EF9185AAE5C914BD0D9DA0A23FDFDB23DD04F7651112C58BDDA5424D03FE20A945D7637000126000340F64D8284FF7CB7F78E3AA363FEE04B7D14971B85E6CC277F80B626CF96E3CE1933C1919E4EB72734594E279026A07852358108BE26';
wwv_flow_imp.g_varchar2_table(70) := 'A4C411EA998603BE8F0D9FEDEE062B9140A85819E58F09C028A4C7D25184BF67C4F374DEA8F0AFC6757EFB98AFC027B7CB2DABFD6D4D9E67FD271797E0B2DF75810369EE486E091ACF9CD1B880BC3DD9D1D7AB23FAA4985744215CA81383627428323A31';
wwv_flow_imp.g_varchar2_table(71) := 'C82410027431F1C204101358FD473AB1F0075FEA9385FFB34FBD7A7E12FED21B5781B08D0A94FF94475D49F869CEA0F56AC3A883E65772B9E0984124409AC09CBBEE0610A37976E164066B0210973F260083608FB7F003F6FCBEC24FBB13D1873E150888';
wwv_flow_imp.g_varchar2_table(72) := '048EEE344613702E5D0E4C020AF2F13B33011880BD8469D098DFBFDA6F4CCF7F06570BB43D3F093FED5A4C6F1CD2ABC70204E6120FB7719A80D54800D135DDC10410E32A895AF8DD38E6F755FB9DC5108DDAAF08BF6D4C05A7578F4913106324409AC031';
wwv_flow_imp.g_varchar2_table(73) := '8386034C02316E8041A2670208025034B715E1EF1EF6BCD3EF99F00BDEF3CB63F6CF3EF31AF3171439A17455E4637E5FE157CAC724A02061AD3313408CEA5B17E147B5BDADF1AA9AC351E1BF09842D78B5C9E481E1FDA9FD4ACFAF463C6661121803C242';
wwv_flow_imp.g_varchar2_table(74) := 'A7E02DC94260E85554BD845F2BBC8AF0DBECC1ABCC9FF0673A1C4063FE40C2AF94DD8C2430802B144AFE12F56CD67C076F4D66CDB949F345C27FA1A707A252FB7D7A6E3D849FC6F8C1845F81542101C5BF3227D071F6B4E2256667BF73025D3DC024101B';
wwv_flow_imp.g_varchar2_table(75) := 'C8990074C45511FE4ECD3E7E618FF9E32CFC0A1CFE48E0F8EED7211E243022E1442893805235BA9E99007484937AFE78093FADF39FF3210F9AF00BA7E7F785421E36646581AA09E08AC4B15DC69140D99D5F051002E88F48E04C57370CF27080E0D0CD30';
wwv_flow_imp.g_varchar2_table(76) := '01E80025F5FC75A8F6EB29FCF9858538DB7F13843AE63FFFC72FA045F3849F2CBCD91EE18DB498BE9A00606F6C942650BC6CC5B88785CE77F722D711E29196C8F870664E91094087DAA9EFE9053D853F0F85BF6CD5EA90841FA501EA50F89B2E5F564B42';
wwv_flow_imp.g_varchar2_table(77) := 'C21F4DCFAF463466F18D4F224DE0F56A683B553BE62376279A13285B73A79AC0A0DB051783EC7FA07A664B50049800824234B1878BBDBDD03134A47A0A77CC7F0E85573BDB4FC23F8784DF11FCC520127EEAF99B6228FC4AC17C4980DC6BDED803ED6762';
wwv_flow_imp.g_varchar2_table(78) := '3F3148EF0E4C5FBE9292940DE1DD323028DBF9273A049800A2C0AF796000DA0623177EEAB95B34C21B8EF04B6E098C127E05A2712480C3819A3DC6CC09CCBEF32EC89F365DC90A34F4F7030F04543822B6300144081D6D6E79A5CFB30147765E1E94AF0E';
wwv_flow_imp.g_varchar2_table(79) := 'ED7D7E6AB8BEC21B8EF053967DC38F134EF21403E39B8E44C3019C188CBD2620A0F4DEFB409914A497AB7A873DAF548349FFCC9E2D2680086B482BFCB4E166E90D3702EDCB1F2C3A097BEEBA2F3E87E6687A7E9FF0BE42192C0FD1DE1F971E6902BB7642';
wwv_flow_imp.g_varchar2_table(80) := 'DBC91361472D0DF4C3F9B7DF822F7EFD8FF0C92F7E0EC75FD906BD97EAFDC63329BFC04B0BE8D23C62ED37003B06458009202844E33DD00E36DA1D7C672D5E0C695999E33DFAB8C8C28F637EED983DAC9E9FC8C327FC3861F449335697BEE94AA890D7BC';
wwv_flow_imp.g_varchar2_table(81) := 'B11B5A6B6BC24AB2EEBD77E1F2F1A330DCDB03D2C808B45FBE04B54826D290FF317EF1D2656AFCA485A9176C89080126800860A349282558F69442282C2B532E039EA3157E0A1F2FB53F50A17C4980FCD5BEF54658AB034D172E50302FD38F732BEDF5E3';
wwv_flow_imp.g_varchar2_table(82) := 'DDC9534671319D642349349892ADFC1321024C001100A725006769198810E2B8B07F1F78F5FC93A740A8B3FDD4CCEBF67DE915DE9FF085900DDDBDF8E68384F2C49EDD381C084D13184161F797A991FE017FCEB296A0DC702B16939E13215B4C0061D6D2';
wwv_flow_imp.g_varchar2_table(83) := '08F63A4338F1A5044BCDCA52AC01CF3D2D2DD078D133AECD25E15F8DEBFC212CF551CF4F73064D972EA9F1FB0A0CBA617000000C5F494441549D7A234E16DFFCD070E0C41BA80984301CC82D28F09BEBEC2953FCBAF72396CA0DAC0AC5CAE70811600208';
wwv_flow_imp.g_varchar2_table(84) := '13389746F84108480D61ECEF4849515321E12F5F4DC2EF50DD025964E137C9983F501E1577BF24F0667012988D2B27E976BB128D7C9E553E17D24BA6CA76DF9F8EBA3AD529C5168AEEA57A678B1F046C7EDCD8690204481D576E0B6CB802824338293717';
wwv_flow_imp.g_varchar2_table(85) := 'E6ADBA09AE5DB418970A43137EC03F7A4E403B6CF01532F462AAC3377F124850F3E61E683D713C603EB3E6CE8715DFFC0ECCBBFB5E28BBF53658F16805CC78F0E180FE3B349A544EAA87580306E01B132210BCF54E18DC7A371D360F6412CE5A0FF5F785';
wwv_flow_imp.g_varchar2_table(86) := '04426E490914969743B04F7CCB91E16CFF795CEA4B24E197F38D3FBE24804E700227065B6B8E91D5AF1199593065C93228BE611564681EF6F1F5DC8DCB83FD5D9DAA738E46B3521D4D6249946C785A73A2E438CEF974A0DAAFCD425F4787F6327A3B09FF';
wwv_flow_imp.g_varchar2_table(87) := '1FBD27FC321C0ED0F3D9FEE83339710C7E4900D7FA5B23784E404D4972C3E977DF562F536D3648430D4C75604B4408300144005B86A6E1F56A7AA408A2F20A42935AA34B7D9E093F12FE521DDEEAF34AC8808B71248085AB0D321C089C2D094EEED9057D';
wwv_flow_imp.g_varchar2_table(88) := 'EDEDAA97928C74D5CE96C81160028800BBDCD4543554EB853A18D4E389349C5CA8F3D3F327A2F02BE0100968F32F2F11E270A0EEDFDE53BC84743EF5C61E683E7D4AF54B5B99E769EA40BDC196B0116002081B3280FCB454B08D0D055CFDFD70E1E8517A';
wwv_flow_imp.g_varchar2_table(89) := '312F8298468360E708E749F82F5D1C75C0DF44EDF931EB5E87BF725C3AB81F0E3CFF1CF4357B3E6FE61568ECA2A7E132ECFFE7DF429366E89066B3C3CC10565EC6A288CB299112650288A0B65270FC39252D4D0DD95E771E5A9A9BD5EBB02C4ACFAF117E';
wwv_flow_imp.g_varchar2_table(90) := 'DF9E33ACF84CE89948A02C3B1B0837257B7DED6D70E0A517E0C00BBF83536FEE86065CEEECAC3B277F9FF0D2E79FC2916D5BE050E556E8EFF0A8FD34EE2FCDC902DF7918254E3E878F001340F898C9219CE993807A23F9027FEAF77D098D8D4D61690223';
wwv_flow_imp.g_varchar2_table(91) := '8343405FEC69D2083F094B224DF861D1433AD21D7628CFCD01DAA64C1BA0AFAD159A6A4FC0D90F3F80A33BFE4536751F7F045D573DDBA1937F87B041698E3789903B9BE810600288103F1A02CC425554809063700D0C40DDA71FC399438760208439814E';
wwv_flow_imp.g_varchar2_table(92) := '6CE047DE7B175A1BAEC8E1E9270367FBB56366724B26433D370931E1A6D506262AA31D875A44B673F37280348089FCF2BDF0116002081F3335443AF66A333233D46BC0C17CFBF9B370E4EDDF43CDC77F80FA9A1AA0CF78F7634FDFDDDE0157CF9E85B35F';
wwv_flow_imp.g_varchar2_table(93) := '7E0907DF79076A3FFD0486353B0991DA9F8C3DBF071C8F8D26F016E4E5C2ECAC2CC8C7C93C7A12D08E824E3E8858494B284E4F87521C362CCACF03B21379D07DB39B44CB1F13409435461382D490A9E12A51492323D0DDD4040DA8DA9E4622388233DF35';
wwv_flow_imp.g_varchar2_table(94) := '1FFC1B5C387C085A50DD1FEAEB55BCCA677AA0857A46450864470BFCE4A6A6C8137A343420415F5A900F8B51E0090BEAF56943520BC010D7223201E8003F35E439383EA59E2D9CE8680E8134886B709D7F7420114E68F6CB08448F001340F418CA314CB2';
wwv_flow_imp.g_varchar2_table(95) := 'DB81C6B6F351B5259555FBB090EC61EC8726B326E30A0209FD3C1CD716A07DEC169F1801C3116002D019729AA822F5750ECE78933A4B8440DAC15CBC5E88EAEDC2FC5C988EF306A4F6EB9C344717670412317943082045802B11C18936CF342F40849081';
wwv_flow_imp.g_varchar2_table(96) := 'B3FBA421F04456B4885A27BCDD96EAD96E3A86C5368400DC16258018D61B479DE408B807070DE9348D2100830A93E46D828B672104DC202511011854180BB50F2EAAC910D03B3BA90EBB211F3D30440330AA307A5702C7C708C40B019748220DC0E1707B';
wwv_flow_imp.g_varchar2_table(97) := '3EA1132F44395D4620811048B34BC9330998D79BD29740D873561981B8236094CC18320410555543206030EEA8720618811820A07B94282BB2CCE81EF1F8080D2100395909BCDFEF941DF987116004C62160A0AC184700C00430AEA2D98111F0838024C0';
wwv_flow_imp.g_varchar2_table(98) := 'F3F10388ED1F13406CF1E5D81981F0119024C3B465E30840406DF848700846C0DC08C422774288E4D30024371C02FE63041881A00818292B8669000E496202085AF5EC8111003052566C46013E79EE62DAD8DD6D547A9C0E2390A008F48DC98A21D9378C';
wwv_flow_imp.g_varchar2_table(99) := '00C4B3CF92F09F36A4549C0823600002314AE2E898ACC4287AEF680D23004A560289870104041B4620300286CA88A1042000F602FF31028CC0040818DB491A4A000E90DEC4924B68F860041881F108483657CA9EF1CEB1733194002657EEBC04208E00FF';
wwv_flow_imp.g_varchar2_table(100) := '3102098E406CB22F8E14BEFAAAE74B31B149C42B564309404E5948EFC867FE610418016F04E2201B8613002E05300178573B5F3102320292E4DE255B0CFC319C008A330A3EC1F25D40C30723C0087810A8775E6EDBE7B934C666380188E79E1B06015B80';
wwv_flow_imp.g_varchar2_table(101) := 'FF188104452026D916F0A2D8BBD7907D00B5F9379C00287197DBFD229E79350041E083114004465C42BC8067C38FB810C0D4ED3B710820FED5F0D272828C803911786BEAD6AAFA78642D2E044005750BE9677466C308581D01B7805F409CFEE2460025DB';
wwv_flow_imp.g_varchar2_table(102) := '76EC0510EF02FF3102098480FE5915EF8ECA82FE31871263DC0840CE9C18F9817CE61F46C0A208E044D85FC5B3E8712500E7B6D70F63E177A3E18311B02202BB8B2BAB8EC6B3E07125002AB810E2FB78EE41C307236025047A61C4FEBD781738EE0450B4';
wwv_flow_imp.g_varchar2_table(103) := 'ADEA0CAA413F8C37109C3E23100C017DEF4BDF77BEF6DA597DE30C3FB6B8130065D939247E09023E263B1B4620F911109F382BAB7F6386729A82004455954B80780A01E1A10082C047522380AABFED09B394D014044060D0500084F424DADD68F8600492';
wwv_flow_imp.g_varchar2_table(104) := '11016CDBE23133A8FE0AB8A62100CA90735B75356A02FF95EC6C18013321A0475E2480EF392BAB5ED7232EBDE230150150A18A2AAB7E264940EF0AD0251B462029101092F4FF8A2B77C4ED89BF40209A8E0028A3CEAC826F8104EF919D0D23900408BC5E';
wwv_flow_imp.g_varchar2_table(105) := '58BEF83F9BB11CA624007A65D89535F81002B6130D1F8C402223B0DB95395861E456DFE180654A02A0024C7DEE8DBEA2CA1D1B04C04FE99A0D23102F04224D17C7FCFF13DBF0C3D496238D23D6E14C4B005470147E0901FC2108A0651317B9B161041200';
wwv_flow_imp.g_varchar2_table(106) := '812190A002C7FC7F436DD8CCF935350128C039B7ED7859B249ABF1FA241A3E1801332370D4866DD5B97D47A59933A9E42D210880325BBCB5FA8BBE94AC65A80DFC1D5E0FA3E18311301302C3D8EBFFA428B36065E1D66AC3F7F68B14888421002AE0355B';
wwv_flow_imp.g_varchar2_table(107) := 'B60CA036F0ACCD6E5F24847883DCD83002B1442084B871A80F3BB03D2EC05EFF4734811D4218D37849280250502B7CF9B55345DBAA1E0470DF0C20689761E03F46C06804707CBF57B8A495CECA1D1BB13D9E313A7D3DD24B4802500AEEACDCF989B3B2EA';
wwv_flow_imp.g_varchar2_table(108) := '6609DCAB00A4AD383C1854EEF199118809020206B19DE1F8DE7D7351E58EDB8B5EAD3E1893740C8A34A10940C1A8B872E7E7CECAEAC75DAE94E9380EFB2B1052DC5FB354F2C6E7A441E01C96E4072E6C63380CAD7062E783D7097F24050128B530F59557';
wwv_flow_imp.g_varchar2_table(109) := '5A701CF673E7B6EA3290A47BD1FD57124817F1CC072310360272DB11D2AF4188BB9D953B4AD1FC2F6A63614764E2004945005A9C9DDBABDFC50AFBF3E2CAEA99205CCB24097E08203E02805E347C3002FE10C0B6816D44C08F84249653DBC1CEE4CF9CDB';
wwv_flow_imp.g_varchar2_table(110) := 'AA92F6B1F4A425006DEDD2DE83C5DB77FC14E70B6E4352C802C95D8A4385F5386FF063F4477B121EC2B3A15F65C5F4F8881F0254D754E758F7D28FE5B630622FA3B621B7916D3B7E52B4BD8AEEC72F8706A56C0902F0C5D2B97DE739E7F61D3B9D95D5FF';
wwv_flow_imp.g_varchar2_table(111) := 'CD59B9E32134CBD14C43238A0A7A27A5A68CE48B1451E24875CC4CB3896B852495BB412C04B7B4D426DC2B6D92B88E8D0931C0BAA13AA2BAA23AA3BAA33AA4BAA43AA5BAA53A4643754D758E758F6D80DA8209B6E7F26DA7465C5B9200260256FCF2EDC1';
wwv_flow_imp.g_varchar2_table(112) := 'FC2DBB3A8AB6545D9DFCE2AB17F3B6569D2FDA5E7DBAA4B2AAC6F94AF591C26D3B0F146EAFDACFC6841860DD501D515D15619D51DD511D525D529D52DD4E54F7DA7B56B1330158A5A6B99C8C801F049800FC80C24E8C8055106002B04A4D733919013F08';
wwv_flow_imp.g_varchar2_table(113) := '3001F801859DAC8D80954ACF0460A5DAE6B232023E083001F800C2978C8095106002B0526D735919011F0498007C00E14B6B2360B5D2330158ADC6B9BC8C80060126000D186C6504AC86001380D56A9CCBCB0868106002D080C1566B2360C5D2330158B1';
wwv_flow_imp.g_varchar2_table(114) := 'D6B9CC8CC018024C006340F08911B022024C0056AC752E332330860013C018107CB23602562D3D1380556B9ECBCD0820024C0008021F8C8055116002B06ACD73B919014480090041E0C3DA0858B9F44C0056AE7D2EBBE5116002B07C136000AC8C001380';
wwv_flow_imp.g_varchar2_table(115) := '956B9FCB6E790498002CDF04AC0D80D54BFFFF010000FFFF102420C5000000064944415403005312E80F7660D8490000000049454E44AE426082';
wwv_flow_imp_shared.create_app_static_file(
 p_id=>wwv_flow_imp.id(95883183608820758933)
,p_file_name=>'icons/app-icon-256-rounded.png'
,p_mime_type=>'image/png'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/icons_app_icon_512_png
begin
wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table;
wwv_flow_imp.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000200000002000806000000F478D4FA00001000494441547801ECBD897F134996EFFB4B4996ACC50BFB620C3606B3154B51400145552FB55055DD5DBDF7F44C4FF74CDF997BDFBBF7F3DEFB77DEBB77EE2C3D';
wwv_flow_imp.g_varchar2_table(2) := 'BDEF7BD7BE75D742B1EF3B186CB031061B2F922C59965F1C55411BB03223652995A9FC19094B199111E77C239D71E2C489C840FFB7BE36C53719F01AE035C06B80D700AF017F5D0301F0870448800448800448C06704001A00BE6B722A4C022440022440';
wwv_flow_imp.g_varchar2_table(3) := '023400780D9000099000099080EF0888C2F4000805BE49800448800448C067046800F8ACC1A92E099000099080DF097CAC3F0D808F39F07F12200112200112F015011A00BE6A6E2A4B0224400224E0770277F5A7017097047F93000990000990808F08D0';
wwv_flow_imp.g_varchar2_table(4) := '00F051635355122001122001BF13F8ABFE3400FECA829F48800448800448C037046800F8A6A9A928099000099080DF094CD79F06C0741AFC4C022440022440023E214003C0270D4D35498004488004FC4EE07EFD6900DCCF83DF48800448800448C01704';
wwv_flow_imp.g_varchar2_table(5) := '6800F8A299A924099000099080DF093CA83F0D800789F03B09900009900009F880000D001F343255240112200112F03B8187F5A701F030131E21011220011220819A274003A0E69B980A920009900009F89DC04CFAD30098890A8F91000990000990408D';
wwv_flow_imp.g_varchar2_table(6) := '13A00150E30D4CF5488004488004FC4E6066FD6900CCCC854749800448800448A0A609D000A8E9E6A5722440022440027E27504C7F1A00C5C8F03809900009900009D430011A0035DCB8548D0448800448C0EF048AEB4F03A0381BA69000099000099040';
wwv_flow_imp.g_varchar2_table(7) := 'CD12A00150B34D4BC5488004488004FC4EC04C7F1A006674984602244002244002354A8006408D362CD5220112200112F03B0173FD690098F3612A09900009900009D424011A0035D9AC548A0448800448C0EF04ACF4A701604588E92440022440022450';
wwv_flow_imp.g_varchar2_table(8) := '83046800D460A35225122001122001BF13B0D69F06803523E620011220011220819A234003A0E69A940A910009900009F89D808EFE34007428310F09900009900009D418011A0035D6A054870448800448C0EF04F4F4A701A0C789B948800448800448A0';
wwv_flow_imp.g_varchar2_table(9) := 'A608D000A8A9E6A4322440022440027E27A0AB3F0D005D52CC470224400224400235448006400D352655210112200112F03B017DFD6900E8B3624E12200112200112A8190234006AA629A908099000099080DF09D8D19F06801D5ACC4B02244002244002';
wwv_flow_imp.g_varchar2_table(10) := '35428006408D3424D5200112200112F03B017BFAD300B0C78BB949800448800448A02608D000A88966A4122440022440027E2760577F1A007689313F09900009900009D400011A0035D08854810448800448C0EF04ECEB4F03C03E339E41022440022440';
wwv_flow_imp.g_varchar2_table(11) := '029E274003C0F34D4805488004488004FC4EA014FD690094428DE79000099000099080C709D000F07803527C122001122001BF13284D7F1A00A571E35924400224400224E0690234003CDD7C149E0448800448C0EF044AD59F0640A9E4781E0990000990';
wwv_flow_imp.g_varchar2_table(12) := '00097898000D000F371E45270112200112F03B81D2F5A701503A3B9E49022440022440029E254003C0B34D47C1498004488004FC4E6036FAD300980D3D9E4B022440022440021E254003C0A30D47B1498004488004FC4E6076FAD300981D3F9E4D022440';
wwv_flow_imp.g_varchar2_table(13) := '022440029E244003C093CD46A1498004488004FC4E60B6FAD300982D419E4F022440022440021E244003C0838D4691498004488004FC4E60F6FAD300983D439640022440022440029E234003C0734D4681498004488004FC4EA01CFAD300280745964102';
wwv_flow_imp.g_varchar2_table(14) := '2440022440021E234003C0630D4671498004488004FC4EA03CFAD300280F479642022440022440029E224003C053CD4561498004488004FC4EA05CFAD3002817499643022440022440021E224003C0438D4551498004488004FC4EA07CFAD300281F4B96';
wwv_flow_imp.g_varchar2_table(15) := '44022440022440029E214003C0334D4541498004488004FC4EA09CFAD30028274D9645022440022440021E214003C0230D4531498004488004FC4EA0BCFAD300282F4F9646022440022440029E204003C013CD4421498004488004FC4EA0DCFAD3002837';
wwv_flow_imp.g_varchar2_table(16) := '519647022440022440021E204003C0038D4411498004488004FC4EA0FCFAD300283F53964802244002244002AE274003C0F54D4401498004488004FC4EA012FAD300A804559649022440022440022E274003C0E50D44F1488004488004FC4EA032FAD300';
wwv_flow_imp.g_varchar2_table(17) := 'A80C57964A02244002244002AE264003C0D5CD43E1488004488004FC4EA052FAD300A81459964B022440022440022E264003C0C58D43D1488004488004FC4EA072FAD300A81C5B964C02244002244002AE254003C0B54D43C1488004488004FC4EA092FA';
wwv_flow_imp.g_varchar2_table(18) := 'D300A8245D964D022440022440022E254003C0A50D43B1488004488004FC4EA0B2FAD300A82C5F964E02244002244002AE244003C095CD42A1488004488004FC4EA0D2FAD300A83461964F022440022440022E244003C0858D4291488004488004FC4EA0';
wwv_flow_imp.g_varchar2_table(19) := 'F2FAD300A83C63D64002244002244002AE234003C0754D4281488004488004FC4EC009FD6900384199759000099000099080CB08D000705983501C122001122001BF1370467F1A00CE70662D24400224400224E02A0234005CD51C14860448800448C0EF';
wwv_flow_imp.g_varchar2_table(20) := '049CD29F068053A4590F09900009900009B888000D0017350645210112200112F03B01E7F4A701E01C6BD64402244002244002AE214003C0354D4141488004488004FC4EC049FD690038499B7591000990000990804B08D000704943500C122001122001';
wwv_flow_imp.g_varchar2_table(21) := 'BF1370567F1A00CEF2666D24400224400224E00A0234005CD10C14820448800448C0EF049CD69F0680D3C4591F09900009900009B880000D0017340245200112200112F03B01E7F5A701E03C73D6480224400224400255274003A0EA4D40014880044880';
wwv_flow_imp.g_varchar2_table(22) := '04FC4EA01AFAD300A80675D6490224400224400255264003A0CA0DC0EA498004488004FC4EA03AFAD300A80E77D64A0224400224400255254003A0AAF85939099000099080DF09544B7F1A00D522CF7A49800448800448A08A04680054113EAB26011220';
wwv_flow_imp.g_varchar2_table(23) := '0112F03B81EAE94F03A07AEC593309900009900009548D000D80AAA167C52440022440027E27504DFD690054933EEB26011220011220812A11A0015025F0AC960448800448C0EF04AAAB3F0D80EAF267ED244002244002245015023400AA829D95920009';
wwv_flow_imp.g_varchar2_table(24) := '900009F89D40B5F5A70150ED1660FD2440022450228129755E3297435F2A8DCBA363B834328A81F1714C4E498A4AE48B044C08D0003081C32412200112702B81746E12DD6349D5E98FE1A6EAF447272630A68C815E650C882190A711E0D6A6FB44AEEAFF';
wwv_flow_imp.g_varchar2_table(25) := 'A20150FD36A00424400224A04540C6F523AAA3EF52A3FDF32323B893CD624AFD7BF0E4F4E4242E2A6FC0B8FAFD601ABF93C05D023400EE92E06F12200112703181BB237E19F58B116025AA1801574693C8E6F35659995E05026EA89206801B5A81329000';
wwv_flow_imp.g_varchar2_table(26) := '0990401102631339E5E61FC5DD11BF9DF9FD4C7EB2702E3D0145E0FAFC300D009F5F00549F0448C07D0464FE3EA5E6F3AFAA39FEAEB1B1C2DC7EA9528A0740CAC9703AA054841538CF1D45D20070473B500A12200112281090117F7732A9E6F0C70A73FC';
wwv_flow_imp.g_varchar2_table(27) := '620C141266F19F78002E8D8E8146C02C20D6E0A934006AB051A952F90848D095DC80C5ED2ABFE57BF94A674924F03101B9B68632595C1819C5A5D1510C6727305370DFC7B94BFB7F229F47D76812124B505A093CAB5C04DC520E0D00B7B404E570848074';
wwv_flow_imp.g_varchar2_table(28) := 'E0D299E7A6A60AA321593A3598C9E0667A1CB27CEA5A32851E35FA129769971A315D2EDC90C70A6BAC2FABEF724CD2AEAB7CB2F65ACEBBADCE97686C19B9C9484BCA967A1C518895789E80B8FAAF28577F8FBAA6E4732515929800B9BEC5E0A8643D2CDB';
wwv_flow_imp.g_varchar2_table(29) := '1B04680078A39D28E52C0888DBF3D67806D2B9CBFAE873C323383D348CB3EAB774EA72E3ED4BA70B1BA848673EA84662D2A14BA4B5ACAB969BB2BC65C315311824ED96EAF465EDB59C27E58A5170498DDCA4EC53437770F6CE30C4489032C4209885F83C';
wwv_flow_imp.g_varchar2_table(30) := 'B54609C87574415D8332EA97EBAA9411BF110A61E9F215D8F8E4A7B06ECBA3A88BC62C69C9EA00F93BE0756989AA4219DC532C0D00F7B4052529130119DD889BB35F8DEAE5067B7164AC30BA97CE5D3A7171859672B3B5239E045E89912086C1C5E1D1C2';
wwv_flow_imp.g_varchar2_table(31) := '862D43CAB0104382375E3B246B2BAF5C9BE229BAACBC49DD6329A44A0CCC0B058358DCDA8A0DBB7663D963DB105B301F8D2B57A273D72E4422114B6852EFADF171CB7CCC50DB046800D476FBFA4A3BE9D807D5C85CDCA917D568FC861AD5CB8D2E37952F';
wwv_flow_imp.g_varchar2_table(32) := 'FB7CAA2E58B9E18BDB75289B45B79A5A1063E48ABAF98B7122D305BAE5309FF709C8285F3AFE4BEADA94CF2519A18681F96AC4BFFEB3CF60C5F61D882F580075E81E9C4473333AF63C85808611207106F74EE407C708B8A9221A006E6A0DCA629B808CA8';
wwv_flow_imp.g_varchar2_table(33) := '651EFEBC72A59E566EF71E358F2A3757E9786D17E6C00972D3172F841827E79567E0BC925B3C13B929460D3880DFF12A24DE6448797E6457BECBCAF093B62F4588603882A5AB5661CBF32FA063DB36441B12458B493435A2AD734DD1F4BB09BCF9DF25E1';
wwv_flow_imp.g_varchar2_table(34) := 'DFDFBC06FCDBF69ED55C6EAA327F2AEE7519EDCB3CBCCC6B7A4D213106446E892110AFC0A0F25E8817C36B7A50DE99094867DFA53A7D314AE5F3CCB9CC8F068221CC5FD68A753B7762D9A6CD8844A3E627A85443BD23D17A18EA9FFA58F4551F0A164D63';
wwv_flow_imp.g_varchar2_table(35) := '42A508B8AB5C1A00EE6A0F4A634160488DA664D42C9DBF1801B5D2614A07211D850411F6A652DCBED5E23A7073B25C97728DCAA85FDA550C3DBBF21A8681256DEDD8F4D9A7D1B143B9FAE7CFB7E8CEA7D590CF63A0FBAAE9B4971807CDE1F0B493F8D18F';
wwv_flow_imp.g_varchar2_table(36) := '046800F8B1D53DA8B3DC48A5D3974E5202ECCAAD4240DD70434600E14000914010F5C12062EA9D0885D0505787B8FA2DC7EA547A50E545857EC4BB31309E817420B25CAB560C9C0AE1724DB1D26ED2F14B44BF5CA7E2D929453871F52FEE5885479E7E06';
wwv_flow_imp.g_varchar2_table(37) := 'CB1FDD8A8889ABBF58F9A9FE7EDCBE39502CB970BC295C57B8A6C11F4709B8ADB280DB04A23C24309D80CCE5CB7A7B993F951B6C29A3A9E9E5153EAB8E5E5CABE1483D120D0D58A85CACCBD7AF47DBD6ADE8D8B51B6B3FF319AC7F6E2F367CE18BD8F0D2';
wwv_flow_imp.g_varchar2_table(38) := '97B0E18B5FC6235FFC12D63DBB171D3B7763C5A62D685DBB0E0B5A97A369DE7C351FDB80707D1401652840190F853A66F99F7428B21C513A14D17B96C5F1F40A129015273285231DBFC4A4945295A18CCD39EA7A5AABAEBF159B3723D6D808FD213FEEFB';
wwv_flow_imp.g_varchar2_table(39) := 'B971F912A69417E0BE830F7C59501F8118BD0F1CE6579F11A001E0B306F78ABAD2F18BBB5F5CE2B2DE5EBECF46F6682482856D6DE878620F367FE5ABD8F65FFE19DBFEC7FF8DCDFFED7FA0F39BDFC2B217BE80C59F7906F376ED41C3A3DB10DBB0099155';
wwv_flow_imp.g_varchar2_table(40) := '9DA85BB90AA1B695A86B5F85F8239B307FF71E2C5586C08ACF7F116BFEE6EFF0C83FFE131E55656CFBEFFF1776FCB7FF8E1DFFF08FCA78781E4B56AD46BCBE7E362217CE150F802C1793B964E9680A07F99F6B08489B5C1C1D2D79AFFE80F22C2D59B50A';
wwv_flow_imp.g_varchar2_table(41) := 'EB9F7916ABB76F4762DEDC59E996BA7D1B4316A37FF16AC554BDB3AA88279740C07DA7D000705F9BF85E2289E297E0BE59B9FBD5483CD23C07F3D7ADC7AAE79EC7BABFFF07ACFEF2D7B0443AF8F60E849B9AD5603D08C33066C5DB308CC2482A100C2214';
wwv_flow_imp.g_varchar2_table(42) := '8D213C6F01E62A0F4187F21CACFFF63F62EDE75EC2E2471F436CD16204427528E547BC1EB2AB6C4E740000100049444154A1D095B131C88A8152CAE039E52720EB3606331994629C06C211CC695F89759FFE0C5A95619988C761CC564435EAEF3D7B16B9';
wwv_flow_imp.g_varchar2_table(43) := 'A97CD19264FA6A4174F68669D10A98E0290234003CD55CB52DACB8BD65F73C71F78B11201D9F2D8D0D036175235DB4BA131BF6BE80AD5FFF9B8F3B60D521C7E6CC85110CD92A6E5699C500696AFED80079FA593CAA64D9F8C52F61C5E33B9158B21486EA';
wwv_flow_imp.g_varchar2_table(44) := '0060D8BBE54BEC83AC18905DDCB887C0AC5AA72C27E754876BB71DC4D53F7FF972ACDFB3079D8F3E8A8472F51B017BD74131E1C7878670BBFF46B1E4C27119F94B4C4BE10BFF7394801B2B0BB85128CAE43F0232772AF3A8B27B5E29DAC79BE760E5A73E';
wwv_flow_imp.g_varchar2_table(45) := '83CDDFFD67ACFEE2573067C32308AA0E182EF931EAA368509E87D6273F8D8D7FFBF7D8AA3C122B9E780AF54D4DB62594ED89BB46C70A5B178BD164BB009E501602B9FC94F66A8DA032F816742857BF3206576EDB8E7873735964B85B886C23D17FFEFCDD';
wwv_flow_imp.g_varchar2_table(46) := 'AF457FCF5773FFE531378A56C1040F11A001E0A1C6AA5551C5852AF3DCD2B1D9D2518DA0230B17A15D8DF637FEC377B174DB0E4454476BAB8C2A640E060288CE9D8BD69DBBF0E877BE8BB6A79F41447928EC8822DE80DE541ADD6349ED4EC84EF9CC6B4D';
wwv_flow_imp.g_varchar2_table(47) := '408CAF9CF4BC26590DD5D6F3567660EDA73E85F64D9B9148C451890E3875A30F0337FB4D240164EE9FA37F5344154C7467D13400DCD92EBE924AE6B765BB5C6DA555C7DFB0AC156BBEF4156CFDE6DFA165E36684EAC2DAA7BB296330528F658F6EC3D66F';
wwv_flow_imp.g_varchar2_table(48) := '7D1BCB77ED467DA33D8F80B09340C901EEEBEEA666BD274BFB63DBD1B1790B64B589BA6CEF1D2FF787DE8B173169F25C0143991D8B6351F57FB96B66795E264003C0CBAD5723B24B24B51D55228B97608972F72FE8580D71ADDA39D7AD7983CA73B15C4D';
wwv_flow_imp.g_varchar2_table(49) := '09ACFFFADF60A9EA300201FD3F4DF1A08837804680BB5A37545787390B17A2921DBF689CB93D88A101F375FFB15090EBFE055695DE6EAD56FF2EE3560D2897E7094834B51D2526076E62F2A29AEF9CC8DA39CD1379636A2A60E5B3CFE3B17FFE3FB078CB';
wwv_flow_imp.g_varchar2_table(50) := '560442FA2B07C408909502566E694F80A80121236ADE3F10AA6CE0E9D4641EBD172F58EEFAB79091FF357045955F051A00E567CA126D1248D4D9BB49E6723974EDDF8FCB3FF921D2979421909FB459A3FBB347D454C0AA679EC3D66FFF03E6A9E90E5D89';
wwv_flow_imp.g_varchar2_table(51) := 'E5096F121760373A5DB77CE6D32750E991BF4892BE730703BDD7E563D17763385498FF2F9A81091526E0DEE203EE158D92F985800427352A77A91D7DF3536AE4D3DF8FA3BFFD0DBA5F791993B76FD939DD3379EBE7CDC7BA6F7C138B366C040CBD3F5759';
wwv_flow_imp.g_varchar2_table(52) := '4229BBD2D10840CDFFF45F3887298B40C4F9917A040CA3E6595041FB04F4EE28F6CBE51924A04D406E4EED0D09C85BF6DFD73E51659CCCE7D17DFA240EFFE7BFA3F7DDB791CF66D4D11A7B058258FDC2E7B0EA9967110806B59493CE5F960A8E4DE4B4F2';
wwv_flow_imp.g_varchar2_table(53) := '3393F708A4D4BCFFE0CD9BA682CBBA7FBB1E36D30299689B809B4FA001E0E6D6F1996CE205685386C0C2FA7AC84377ECA89F999CC4E5031FE1CC0FBE87E1A38780DC849DD33D9177F1E647B1FEEBDF44447905740496A582D753298831A0939F79BC45E0';
wwv_flow_imp.g_varchar2_table(54) := 'C685F390E9B062528B612D7F4BC5D2799C046800F01A701501E9F897C4A258DDD880F991886DD986060771E2CD3771E6E73F45AAF79A3ADF6E88A13AC5C5AFE665ADD8F8D5AF63CECA0E2D29A5F3979D15C540D23A81993C412033A4E6FE6F98EFFA274F';
wwv_flow_imp.g_varchar2_table(55) := 'B06C0CEB07917A4271CF09E96E816900B8BB7D7C2B9D18022DF118562A8F806C5E62C0D0673195C7EDEBD770F2A73FC69597FF88ECF01DFD733D9053F60AE87CE9CB108F80A1C1451E2824CF55A011E081C6D511313F85818B172C73CEAF8F685C1D96C5';
wwv_flow_imp.g_varchar2_table(56) := '30430D13A00150C38D5B0BAA49E72FB1012DF1A8ED6981AC9A16B876EA244E7EEFDF70EB83F730359EAE0524051DEA4221AC7A762FDAF73E8F6034563866F65F3297831801798B8031B33298E60E02A9A141DCB088FC97C05AF9DB7187C4FE95C2ED9AD3';
wwv_flow_imp.g_varchar2_table(57) := '00707B0B51BEC228669E9A0E58D3D40899D30C19F62EDB54368BB3CA0038F5B39F60F0C43160B27602E3966EDC8C2D5FFE0AEAE7CEB3BC52C408B832968478042C3333836B09F49E3F0FB35DFF4470EEFA2714F8B62260EF4E6A551AD349A08204828601';
wwv_flow_imp.g_varchar2_table(58) := '890F686B88A349CD6DEAB8BFA78B73E7663FCEBDFE2A2EFEFE779818199E9EE4E9CFD1A5CBB0E6851711AEB77ECCAB2C11EC4BA5515B91119E6E3E5BC2676EDFC6A0C5DCBF44FECBFCBFAD8299B90204DC5F240D00F7B711257C8080DCDCDA1209743426';
wwv_flow_imp.g_varchar2_table(59) := '6C6F6F2ACB066F5C3C8F83FFFB7FA1FBB59791AF91698186252D58F5E2E78180F532C121E5111123E001ACFCEA01023D67CE606A2A5F545243F9CB1645AD0DC1A20530C157046800F8AAB96B4BD98221D090404B2C867ACDF5F177094CE627D17DFC188E';
wwv_flow_imp.g_varchar2_table(60) := 'FDEBBFE0E6818F6AC21098BB7215DAF73C0918D67FD6F2DC80D189DA5B2A891AFE490D0DE1B6F26299A9D8180E71D73F33400EA679A1AA801784A48C24508C40C83020D1CE1228287102C5F2153B9E4CA770FEDDB771EEB7BF46FA6A97CAE66DE778CB8E';
wwv_flow_imp.g_varchar2_table(61) := '9D58B8798BD2C3FA25CF0E90BD02AC733247D509E4F3E8BFA011F9CF5DFFAADE545E12800680975A8BB21625100E04B02C1E43676323E684C3CA116A14CD3B53C2ED9E6E1CFBC5CF71E977BFC1F89DC199B278E6D8CACF7C167356B459CA2B7B04F4A652';
wwv_flow_imp.g_varchar2_table(62) := '96F998A13402E53425C76EDD5273FF7DA682C8DC3F77FD3345E460A237AAA201E08D76A2949A04A2A1205A13712C4FD89F16C8A9B9D5BEF3E770EA87DF47FFBB6F219F4A6AD6EAAE6CA160081D2F7E1E9139732C051BC9E6C0A9004B4C256598C84E20AF';
wwv_flow_imp.g_varchar2_table(63) := 'AEA9924E7EE0A45EEEFAF700117E2D07011A00E5A0C8325C4540C6FECDCA0BD0D9D458880FB0BB6C309D4EE3C281FD38FEA31F60E8EC194F2E1BAC8F27B0FAE967118CC74DDB660A539080C01CF70730E5544A62369BC1F8F03072133908DEA9BCA26DE7';
wwv_flow_imp.g_varchar2_table(64) := 'AD5C0893EADCC16BD730D4DF6F2A82C4C33486EB4CF330D139025EA9890680575A8A72DA26208680C407C86A01890F90BDD1ED1432766708A7FFF03B9CFEE5CF3ED956D8CED9D5CFDBDCB612EDBBF700162B03D2939318488F575F608F491030AC053EF3';
wwv_flow_imp.g_varchar2_table(65) := 'E77771F24F7FC469F53EF3CA9F60EBADCE39A1DE17F67F6459915CE71AE25896C30CFE224003C05FEDED4B6D658580C407B42712888542B618A8311B06BBBB71ECC73F44F71F7F8F098FC5072CDEB819AD8F6CB4D4F95626C30D822C29DD9F410DE60B23';
wwv_flow_imp.g_varchar2_table(66) := 'FBFB8FDEFF2DAF86FE99C91CC632E3181DB7F956E7C8B9F797F8F03719FD73D7BF87B954EF88776AA601E09DB6A2A4B324200152AB1A1B207B08D8350426D58DBCFBCC291CFBC98FD1FBDE9F31E995FD0302012CFFD4A711B7D824483A2A990A9825625F';
wwv_flow_imp.g_varchar2_table(67) := '9D3E9CCDAA0914E5A7AFA2D6068CC2E65846156560D5DE254003C0BB6D47C94B2020374AD945B02D11C702D5291AEA066AA798F1B1515CDEF701CEA96981B1AE4B409982BCECC86037AF11A9C7D2AD8F294D0DD3536583A08C9A0E30CDC4C402813BAAF3';
wwv_flow_imp.g_varchar2_table(68) := '175E852F55FC2F160ADADE0CAB8AE2FAA26A2F294903C04BAD4559CB46409E36B83416C5DAE646C8B241BB050FF6F5E1D82F7F81733FFF29C687DCBF6C70FEB61D68505320567AF6729B602B4418CA6471752C09F10A5966AE6006439974DCF5AF82807D';
wwv_flow_imp.g_varchar2_table(69) := '50340D001F3432552C4E40F60F906583ABD5D480CCA516CFF9708AC4070C745FC5B1FFF857F4BCF53AB277861ECEE49223C170042B76EEB494662C97C348963B0416033598C9408CA462E94E1E9F13A943A2AECEC92A599725016F65A001E0ADF6A2B415';
wwv_flow_imp.g_varchar2_table(70) := '2060A832252640E2039644A3B0BB6C7042B9CDAF1E3E84936A5A60F0D811555A75E785950033BE1AD73F82E6969619D3EE1E945880A16CE6EE57FE9E4640DCFED79269E45C30ED231EAC45EA5A956B779A88FC4802B608D000B0858B996B9DC0C2683D3A';
wwv_flow_imp.g_varchar2_table(71) := '9B1AB048FD0E18F66EAFA9A1219C96A70DBEF1BA2B63030CE50558FAD87658E93592CD7145C00317FA6D35F2EF49A6B483FE0CE59E17CEE57807D575180D060B73FD8950A8706DAE6C4840BC570F88C9AF5526E0B5EA690078ADC5286FC509C8E86AB11A';
wwv_flow_imp.g_varchar2_table(72) := '5DC9B241594268B7C21B470FE3EC2F7F8EA99CFB5CE9735775A279F1125395646A6348CD739B66F251A28CFC6585447ECADAB323D78E7891A4835ED5D0800ED551CFF62D65C932D6D6780CCB1371C8B559CA75E9A326A3AA9A04680068826236FF1148D4';
wwv_flow_imp.g_varchar2_table(73) := '85B0A6A911F2A0211981D92170EB4A17CEFCEA17307B74AB9DF2CA96F7936581861A519A952911EE13F9E28F9D353BB796D264E4AF1BF0275347B2BA44BC4872ED4443C1C2BE1331356A2FC73BA2DA4C0C8C5AE25B5BBA784F1B1A00DE6B334AEC3081C6';
wwv_flow_imp.g_varchar2_table(74) := 'BA3A7434364046767293D7AD7EB0FB2A7AF77DA89BDDB17CF19656CC5DBEC2B43E7950908C7C4D33D578E2A072FBCBC85F47CD4820A80CC578A1C3D7C9CF3C24E006023400DCD00A94C1F504641E5646769D4D0D981B09AB195E434BE6BE23875C371560';
wwv_flow_imp.g_varchar2_table(75) := '18065AB76D47201231D5E18E8FA701C4F891803F9DA57E322A1717BD8CF24D8132B1A6097851391A005E6C35CA5C350272B36F8DC7B1AEB911B2A1909520E3A9146E1C3B6A95CDF1F4C48A7634CC9B6F5A6F363FE5CB604071FBEB06FCC9F520B122E2F2';
wwv_flow_imp.g_varchar2_table(76) := '3785C944127021011A002E6C148AE47E0272E35F91481422B20DE50F3093F8F6F973C8A5536659AA92D6B4628569BD32FAF5DBA38265E42F6EFFBC66C05F4B2C86A89AEB3705C9441F10F0A68A3400BCD96E94DA05040C258344642F4FC4D4A7E2AFF164';
wwv_flow_imp.g_varchar2_table(77) := '12E383B78B67A8524AE38A36D32581B21A6074225725E99CAF76484D79D80DF8D3F10239AF096B24013D023400F43831170914252041821223502C4376740479D5B9144BAFD6F1D89CB948584C038C29034067345C2D1DCA55EF60467F873F597FDFD610';
wwv_flow_imp.g_varchar2_table(78) := '67C05FB9E0D740395E55810680575B8E72BB86806CF6120914FF53CA4F4E627222EB1A79EF0A128EC7D1BCB2E3EED7197FCBAE77390D77F88C277BE4A0B8FD25E02FA7B1C35FD03020017F76B78DF6080A8AE93302C5EF5A3E03417549A05402B23D4CC6';
wwv_flow_imp.g_varchar2_table(79) := '64CDBC2C1D9477A9E557EE3C034D6DED80EAD460F23336E1BE0D8D4CC4B5956437E04F36E569A8ABB3550733D73A01EFEA4703C0BB6D5715C9A5B39377552A7769A549E5269780B962E2D527E2083735164BAEEAF1F8D2A50844EA4D6548E66A330E4046';
wwv_flow_imp.g_varchar2_table(80) := 'FE7603FE62A190292B2692809708D000F0526B5559D621358FDD339684BC65E464D6E9555954C7AA1763A83F9D36ADAF79C952442CE6DA4D0BA86062285487E6254B4C6BC84CE66B6E39E0A09AF3EF1E4B693DD257BC37B2C31F03FE4C2F13DF267A5971';
wwv_flow_imp.g_varchar2_table(81) := '1A005E6E3D0765979192AC8D962D62E57D3D99C6E5D131F8DD10908E64CC62843CA75DCDB3AB8ED6C1E6B255D59CF676986D0D9CCB4F216B32C561AB3217649636EB4B8D4356395889130904C1803F2B4A4CF72A011A005E6D3907E5BE9E4CE1E6F8FD37';
wwv_flow_imp.g_varchar2_table(82) := '4CB979A654C7774DA5752943607C72D24189DC51556E6A0A37D3E3A6C20495CB38D1A10C00D35CD54D6C6A5B89482C51548889A93C3235D2BEE2F6BFA68CD79CD2A9A8C29F24C85E0F0CF8FB04067F1521E0EDC33400BCDD7E15975E9680C988DFAC2299';
wwv_flow_imp.g_varchar2_table(83) := '233E3F3C0A3114FC6408DC524691D5C8787EE75A046371337C554F8BCD9D8748A2B88C720D58E95975253404102500A32F00001000494441546F9578B1C478B5CA2E9DBFB8FDB9C39F1529A67B99000D002FB79E03B2E7D4285767AE5F6EAAB7D4BCAA78';
wwv_flow_imp.g_varchar2_table(84) := '03FAD5A8583A0D07C4AB5A15C2E5D678C6B4FE682482654FEC31CDE396C470CC7C33A3ECA4B79F0C28237F99C6D2B92EA5F397913F03FEDC7275BA570EAF4B4603C0EB2D5861F9EDBA7E65A478239D867804E4A65B61F1AA567C7F2A6D1940B674F31644';
wwv_flow_imp.g_varchar2_table(85) := '9B9AAB26A39D8AEBA251D3EC66CB1C4D4F7441A25C87BA017FB2CE7F85F286C8E64E2E109D2290404509D000A8285EEF173E5162F057263F0971B7CAD6AA122BE07D127FD5403A94C1ACF9C63ED1C6462CDCBAEDAF27B9FC53286AEE01C895781D545BED';
wwv_flow_imp.g_varchar2_table(86) := 'A14C564D4DA5B502FE0A3BFC2512E0263FD56E35AFD4EF7D39690078BF0D2BAAC1445E16BA955685B85BA5B3BC383206F10AE84C25945693B3670D28D7BFE856AC560306566CDF8160A2A15816D71D0FD59BEF05206D57FA95501D754726260A46684E23';
wwv_flow_imp.g_varchar2_table(87) := 'E04F46FEE2F6E79C7F75DA8AB55687000D80EA70F74CADE518F94DA9F197C4055C181EC5C0F8B8A5EBDCCD70644469E5D198B76205E66FDA326B3526D5A87B70E026067A7A3061E171986D65618B2980D996EFF4F983990CBAC792EACAB3365B64CE9F3B';
wwv_flow_imp.g_varchar2_table(88) := 'FC39DD42DEAFAF1634A001500BAD58411D7253D63750DDEA655AA057CD9DCBB4403AE7BD6583120F713D953255376004D0B2E7492038BB1DE3D223C338F8D31FE3F4F7BF87733FFB110EFCCBFFC4F9575F467664C4B4FE5213431606805C05665E8F52EB';
wwv_flow_imp.g_varchar2_table(89) := 'ADC47932F297EB4CBC1656E54BE7DF128BF1C13E56A0985E93046800D464B39647A9093502D5B989DAAD6D54B966CFAB8EAC2799F4D406333A9DCA92356BD0B0A4C52E92FBF2CBC3834EFFE2A798B8DE03E495A1A48CB07C3A899B278EE1D0F7FE15D70F';
wwv_flow_imp.g_varchar2_table(90) := 'ECC354D67C05C27D056A7C0986C38061C0ECC70B06804C395D194D6A7999824A5F59EAC71DFECC5A9D693313A88DA334006AA31D2BA2452E3F6579239DD3D68E392B3B5057A73A109B520C66B2B834320A991E28A7A7C1A6185AD9C5ED6FB5E35F7D4313';
wwv_flow_imp.g_varchar2_table(91) := '963FF31C66FB3370FA24D28383331633A95CDB5DEFBE8323CA3B70E7FC199547C6E6EAD72C5F8148040523C0A49CF2D46452C12C9386D4F5743D99D672FBDF0DF8E352BF5942E7E99E264003C0D3CD5759E1F3EA566A36EA933DD2173FF208D67DF96BD8';
wwv_flow_imp.g_varchar2_table(92) := 'F4F7DFC1DCF695B605BABB6C500C0171DDDA2EC0A113C44831632162B4EEDA85607D543E96FECE4DE0D6C50B96E7A7FA6FE0E4EF7E8B33CA10181FBC6D99DF2A43201C41A8B1A96836E5848095FE454F762041AE1D59759263C09F03B45945AD10A00150';
wwv_flow_imp.g_varchar2_table(93) := '2B2D59013DE4862F1D74B1A20306105473DD01E54A8DCE9B8FF5CA10D8FCB56FA079690B0CF5AFD879331D971D04C5752BCF17189B70D7D3E7A47391F74C72DF3DD6BC7809E6ADEEBCFBB5F4DF01F527A978EA1670BBA71B877EF09FE87EF3354CA5CDE3';
wwv_flow_imp.g_varchar2_table(94) := '13CCCA0C2A0F4E246EBE1450AE07B332AA9536A8BC220CF8AB167DD6EB6502EA6EE365F1297B250988CBD7F2A63F7D8F78D57935B4ADC4BAAF7C0D6DDBB723AADCCA76E49B521E07890F90204159366859B79DC24BCC9B53435F19FD5B9DBE6CF7130859';
wwv_flow_imp.g_varchar2_table(95) := 'ACA5B72AA3901E0862D1FA0D3042FA4184120FD07DE4300EFFE8FB48DE1A281463F7BFA0EAFCC3D1E2DB014B796A46487EB9EA2D86993CD847275685017FAE6A3A0F0B533BA2D300A89DB6745C13311072332C4F133778CBA73E8B47BFFBCF58B1790B42';
wwv_flow_imp.g_varchar2_table(96) := 'CA30B0235C4EB971A5D33D736704B2DDAED463E7FC72E61D1CCF40E6FFCDCA9CA7A63E9A57AE32CB622B6D7EE75A2CDFB90B664FE89BA9C0F4D0104EFDFA97C88DDA5F29601801357D1199A9D87BC7644AE8DE17177CB81BF09753D78B953841C3C0F278';
wwv_flow_imp.g_varchar2_table(97) := '1C0CF8B322C5743F11A001E0A7D6AE80AE7993E57C8144035A9F7D1E8F7CEBDB58D8B10A01D5C9D811416EECB2ECEEE2F008AA312D9053A37F79BE8199CCE160102B3EF519B32C25A5B5EE7C02EBBEF177882E596AEBFCECE8286E5D386FEB1CC93CA574';
wwv_flow_imp.g_varchar2_table(98) := '0D04BC733B90CE5F566588D748E4377BCBC87F79220E6EF263468969BA046A299F77FEE26B89BA477431949C060CF5FFCC2F71D1E735465F89454BD0F9D297B0EEAB5F437CD162408DC660E327A5A6192EA98EED5A3205599A68E3D4596595FDFEADEA5B';
wwv_flow_imp.g_varchar2_table(99) := 'A8E6FD63F317CCAA9E6227CF6D69C1D6AFFF0D563CF124428944B16C0F1DD7E9141F3AC94307649A4802FEACDA46540AAA6B6D999ADEE0DEFE42836F12B89F40E0FEAFFC46027F2560C0405DC0F8EB81073EC9BCEB94860150382D18C29CB695D8A2BC01';
wwv_flow_imp.g_varchar2_table(100) := 'AB76EE46CC62E319CCF0238F733DA7BC0132F2D3B9F9CF5084F621E9646E672CF6FB9F3B0F4BF63CA55D6629198D7004ADBB9EC0D66FFC2D16B677A81629DE1E52BE110EA369F112F95893EF21D526F2609FBCF258582928AB54DA94E1C4CEDF8A14D3F5';
wwv_flow_imp.g_varchar2_table(101) := '09D4564E1A00B5D59E65D546464F210BB7F064CE5EC4BE110862B11AD16EF8C77F42CBC64D08A8119A1DA1C5E890ED84AF8C8E4102C02A111F20658AB16135926EDBB11391E63976C42F396F58191B9D5FFD3A367DE92B689A37AF6839CDCB5720B6B4A5';
wwv_flow_imp.g_varchar2_table(102) := '68BA9713A4BDC5F8CB69189DE2F66F894741B7BF975B9CB2579A000D804A13F670F9C18001310260F22391E1531AA3B1078B88C41368DFFB22B67CFD9B98DFBA1C4630F86016D3EF322DD0A58C80CB23A348DA34424C0B568977D42873246B6ED83429F7';
wwv_flow_imp.g_varchar2_table(103) := 'FCBCB56B556E675F0DAB5663E377BE8B759F7D16D1E95E14C340444D45743E2B1B1119CE0AE5406D32E72FAB43743A7FB96697C7E36856DE10074463153E22506BAA066A4D21EA533E02328A0AA98EC5B444D5F91A46E91D4E4C8D58D7A891EDBABD2FA0';
wwv_flow_imp.g_varchar2_table(104) := '718EFDD1B4ECCE775919027DA934722518220FEA2665F4A5D3301BFD07951763B904FE85EA1E3CDDFE7719CD4E9A1B1B0F15AAA653E66D7D0C5BBEF60DAC7F742B566C7804AB3FF3596CFAC63751578EA5880F5558DD03D2F9CBC85FC7ED2FD7EC0A06FC';
wwv_flow_imp.g_varchar2_table(105) := '55B7C158BB6708D000F04C53392FA874EB21E50530AB79D2E2E13866E7DE4D33427598BBFE116C54D302ED3B77D9DE56583A869BE3E3383F3C82C14C4675DE774BB6FF5B96FD59C5172C58BB064D4B97D92FFC8133C66EF6A3EB8DD771FAB7BFC68DFDFB';
wwv_flow_imp.g_varchar2_table(106) := '306973F95E70D112CC7DFA39B4BEF0792CDABA1D9198F93AFE07AAF7C45789C5B013F0270FF669A82B8361E6093A14D25902B5571B0D80DA6BD3B26A14B018DDA7076FA39429809984348221B4ECF9141EFDEFFF175AB76EB36D0848C72D9DC5056508C8';
wwv_flow_imp.g_varchar2_table(107) := '7CB1CCE5CF544FB163B21BA1CCFD174B97E3C1FA7A2CDFF9847C9CD57BF4F2451CFFE17FE2FAB12318BC7C0917FFFC0E0EFEFBBFA2E7E53F203F363AABB24B3D3960739966A9F5E89E27237FBB017F5CE7AF4B97F94800A001C0ABC094405DC0FC12498D';
wwv_flow_imp.g_varchar2_table(108) := '0CABF3ED76B5EA14935758CDDDAEF8EC3358FBE2E7D548BB05B0D931A5272771653489EBC914E411BED0FCB9991EB77C3A61CBA6CD90803CCD2267CC265BF69E53237F79EADFF40C13D90CAE9E3A89C33FFA016E9F3B03E426A62757FCB3A17C27068CA2';
wwv_flow_imp.g_varchar2_table(109) := 'F5946186A568D90F268801773D9956D33AF907931EFA2ED72803FE1EC2C2036526508BC599DFDD6B5163EA648B802CA5323B21ABE6DE272B34626D5ADD898DDFFC16D6EFDD8BB84DF7B6CCE1CB68FEDCF0287AD534854C1398E92181844333EC6A38FD9C';
wwv_flow_imp.g_varchar2_table(110) := 'FA050BD0B273F7F443257DBEDD7519E305C369E6D325EDCCEF7F8B133FFC3EC4533073AEF21E350C030113636F4A1907F286033F32F267C09F03A05985EF09D000F0FD25600E201234BF44F2F949A46EDC302F6436A9AA539AFBC8666CFCA7FF8A8EDD4F';
wwv_flow_imp.g_varchar2_table(111) := 'A02E12B1559A745A03E3195C1A192D6CE93B93AF425CFFD795B7C0AAE056E5FA0F86EDD53F5399C37DBD331D7EE8D8F0C04D1CFBD52F70FE173FC1F80DBD731E2A44F3804CF504A7AF2A98E13C2B236A86536C1F92CEBF5719953A75C9C89F3BFCD946CC';
wwv_flow_imp.g_varchar2_table(112) := '134A22509B2799DFDD6B53676A658380DC64A573287A8AF20B0FF5F40012CD5E34D3EC1342917A2CD9FD24B67CE7BB58B86E1D02217B815EB26CF0823202AE8C8E15960D8A21206FE9FC256E40A60DCCA49CB7AC150B57AF36CBA29D56377FA1765EC978';
wwv_flow_imp.g_varchar2_table(113) := 'F3CA151CF9E98FD1FDFACB80DD15035280E6BB2E1235CD39A9DADA34C32C134B09F8E3263FB384CED37D4D800680AF9BDF5A79E9FC2301F3CB64B4F71A667A289075E9F673449A9AD1F9B92F62E317BF8479ADCB6D172073CB17952170E6CE30E47D6E78';
wwv_flow_imp.g_varchar2_table(114) := 'A4E019302B28140EA3ED339F8511089A65D34E5BBA762D220B176BE7978C931313E83E760C277FF34BF5554C17F5ABCCAFBA683D8CE2210098904D1FCA5CE7DDE286325930E0EF2E0DFE761B815A95C7FCCE5EAB5A532F6D02D21F4443E61DDFD8AD5B48';
wwv_flow_imp.g_varchar2_table(115) := '8F8D6997598E8C0DED1D58F38DBFC5EA173E87FAB8FDE56F13F9BCEAD0AC03CC44D6856BD721BAA87CDBEB8A3763F3D7BE8EA6850BA5785BEF3B5D5DE83F75D2D639BA9943D118A4BD8BE597804AD927A1587AA9C7C52813B77F4EC38B241E2906FC954A';
wwv_flow_imp.g_varchar2_table(116) := '9AE791C0FD046800DCCF83DF6620100F8554C750BC6BC8E572488F3ABF744DBC138B366CC4A3DFFE4714F60F501DD80CE2CFEA50C3E225682D43E0DF83428463716C5472777EE669C8E707D3CDBEA795D7C22CBDD4B43A0B432A3399C7A4329C4A2D7FA6';
wwv_flow_imp.g_varchar2_table(117) := 'F364CE9F017F3391E131F710A85D496800D46EDB964DB3445D1D4281E2068054347A6B407E55E51D4C3414F60FD8A446D5F3D4B4806198CB0ACD9F607D3D563DF32CEA1A9B34CFB099CD0860E163DB0B4FFC6B515E06DDED90EB2C82F56C4A712F7B3816';
wwv_flow_imp.g_varchar2_table(118) := '433050FC9690C94F625C1901F74E98E587E1EC0464E4CF80BF5982E4E924502281E27FED2516C8D36A8F4058750A75EA6DA6D9685F9F4AAECCDCB42A58EB256EFA757FF37778E4A52F233167AED639C5328542216CF8E297115FBCB45896B21D0F2D5888';
wwv_flow_imp.g_varchar2_table(119) := 'F6CF7F119BBFFC5534CEB778B4B0326EE6B7B595ADEEE90505EAC28834344E3FF4D0E77499821065D9654F32A9350D13543AF391BE0F35050F3844A096ABA10150CBAD5B46DD9A9417C0ACB8CCCD7E8CDFB96396C5B134D93F60CB7FF9E7C20373628DE6';
wwv_flow_imp.g_varchar2_table(120) := '1DDA8342196AB2A371690B367EF3EFD0D8BAE2C1E48A7E4FB4ADC4A66FFF03D6EE7D11F50D337B1D966DDA8CC82C8D9BA24A04024AE7D6A2C992303661F3B90572D2036F19F98BDB5F675541487949DA120930DAFF0188FC4A0265204003A00C10FD5044';
wwv_flow_imp.g_varchar2_table(121) := 'BC2E64AAE6C4D02006CE9F33CDE368A2EA38E481391B9447A0EDA94F21260F1A52C7CC6488A9A9840EE5F25FFFD5AF3B32F29F51966008F3376EC2A3DFFA7B2C57D30391C64604A27118CAEDBF60FD06B43D234FFB9BF1CCB21C6C5CD98140B078D0E7F8';
wwv_flow_imp.g_varchar2_table(122) := 'E4A4E56E896682C8C8BF3795D21AF94BE7DF128FF291BE664099566102B55D3C0D80DA6EDFB26927D30051938E412ABA71FA1472AA8390CF6E79CBB2C1653B76E1D1EF7C176B9E7E060B57AC402C1C5673DD41186AC41B0C0454075387156D6DD8F2CDBF';
wwv_flow_imp.g_varchar2_table(123) := 'C5E22D5B2151FAE5925FE6B7539971DBC5495CC3F2CF3C8DEDFFF4DFB0F92B5FC1E3FFE5BF62CD8B5F80121A95FC49B42E4734162F5A858CDA6F8F678AA69B25C83AFFAED1312D0322601810B77FB36A2BB33299460224503A011A00A5B3F3D59975AAA3';
wwv_flow_imp.g_varchar2_table(124) := '6C0CD799EA9C191CC4CDB3A74DF3542BD150F3DB0B54E7BEFA6BDFC423FFE3FFC1263545B0F1EB7F8347BEF60D6CF8AFFF275AD5F19463F790000010004944415440F3ECE2061ED4EDAA62F1D1F7FE0D47FFE3DFB0FF07DFC3D5FD1F61D2EEFEFEC110E2';
wwv_flow_imp.g_varchar2_table(125) := '4B5A10AAC00A8707E595EF91FA2864E5837C2EF6962D96651965B1F4998ECB52BFEBC934C48098297DFA3119F9B7C663E0837DA653E1E76A10A8F53A6900D47A0B9751BF26D5899A16979FC48D238751EEA562A675DA4C340C03E190EA549BE7A051CDF1';
wwv_flow_imp.g_varchar2_table(126) := '372C6F439DC988D766F1F7B2DF387502D7DE781D93B706901F1D41F6461F7AFEF22E0EFFE887E85769F732BAF04363CB5253A9A4131723C034D3B44471FBF78CA520AB08A61D9EF1A38CFCC5EDCF91FF8C78789004CA4A2050D6D258584D13900D81ACA6';
wwv_flow_imp.g_varchar2_table(127) := '0152FD3770BBBFBFA639582937399EC6D57D1F624AFDBE2FEF541E999B3770F1B55770FCB7BF46521906F7A5BBE4CBDCF695085BEC09203BF7493C8095C812F0D73D96D47AAA5F501967CB55BDECFCADA832DD1902B55F0B0D80DA6FE3B26A6879739E9A';
wwv_flow_imp.g_varchar2_table(128) := '42EF47AAF353DE80B256ECA1C26E9F3D8B89E1E1A2124F4D4E62E4C2391CFDDFFF1397DE7E03B96C6973EA452B98654268EE3C2C686B372D259BCFE3463A6D9A4746FE12F027794D33AA44E9FC5B6274FB2B147C9180630468003886BA362A9A1309C3CA';
wwv_flow_imp.g_varchar2_table(129) := '0B90BCD68DA14A3E21D0E528B3B22DB23284ACC41443A0EFD0411CFC97FF89DE43078089ACD529CEA41B012CDBBD07F5E188697D32BABF53E411CA7603FE5AD5C85FAE2DD30A9948020E12F04355013F28491DCB47408201E746CC3B86A9F171F49F3EE9';
wwv_flow_imp.g_varchar2_table(130) := 'EA5880F21179B8A439CB5A60D49B339A7E562E9DC2E577DEC2B15FFF0AA9819BD393AAF6B9AEA9194B1FDB6659BF3CC047A603A6679480BF6BC914245660FAF1993E33E06F262A3C4602CE10A001E00CE79AAAA55979012458CB4CA9A173E770E7A63F63';
wwv_flow_imp.g_varchar2_table(131) := '01E2CA7DBE62E32640CD6943F747790C46BBAFE0E8AF7F89F4E0A0EE5915CDB778FB0E442D96E14D610AD752A9C2D23EE9F0C5ED2F73FE3A6E7FB98618F057D12664E12513F0C7893400FCD1CE65D532A43AB639161D435E8D6AAF1DD85FD67ABD539881';
wwv_flow_imp.g_varchar2_table(132) := '654F7D066BBEF045D435CDB125B6AC18B876E0235BE7542A73404D01B4EF790AD2519BD5217B1DC8FA7E79EBEEF02773FE2B127158C6949855CC341220815911A001302B7CFE3D7961B41E321D604660ECE2790CF7F59A65A9E9B4059D6BF1D8DF7F1B2D';
wwv_flow_imp.g_varchar2_table(133) := '8F3E8640A45E4F57E509C88E140F20D42BA47CB9E66E79148BD6ACB52C505604C8E85F677F00E9FC97C6A2DCDED7922A33548B805FEAA501E097962EB39EB233A09517606A7212177FF71B4CB874B95B9991CC585C281A43FBD3CFE2D16FFE1DE64B47AA';
wwv_flow_imp.g_varchar2_table(134) := 'BC2733669C7630D1D43CED5B953F068258F1D4A73167FEFCB2081250FA2F57237FAB3892B254C6424880044C09D00030C5C3443302F3EA2388A80EC22C4F5A75FE57DF7A5365A9EE93029500557D45172CC4DA2F7C099BFEE66F9158B4B8A82CA1BA3A2C';
wwv_flow_imp.g_varchar2_table(135) := 'DEBAB5687A3512428D4DE878F1F3A8AB0BCFAAFABB017F8D4AC75915C49349A0A204FC5378C03FAA52D37213102FC02235156055EE8D4B1771FDF021AB6CBE486F5CB61C5B9437A0F3B9E751FFC048DF501DE39ACF3E83C8FC85AE6351BF7031563FF32C';
wwv_flow_imp.g_varchar2_table(136) := '024669B70C19F933E0CF75CD4A817C4EA0B4BF669F43A3FA7F25206BB71B54C7F5D723337CCA4FE2EAFE7D18BD333443A20F0FA991F4C24D5BB0F56FFF0EAB76ECC4BC65CBB0B8730D1EF9C2173167E366D70299BB612356CAEA069B124AE7CF1DFE6C42';
wwv_flow_imp.g_varchar2_table(137) := '63F6AA11F053C53400FCD4DA15D255BC00E2DE352B3E3F3686CBAFBE8C895CCE2C9BAFD20289462C56F3EBEBBEF9F758F5D297D1B47295EBF55FFCDC5EADA0C0E98AC48241583D486A7A7E7E260112708640C0996A584B2D13888742104F80958EA33DDD';
wwv_flow_imp.g_varchar2_table(138) := 'B8BAEF7DAB6C4C77350103AB3FF7926D23606ACADF3120AE6E520A378D80BF3ED200F0577B574CDB05F511CB658152F9CD234770FBD205F9C8B75709040258F9B92F60F1EA355A1A8C29AF4F7F7A1CB25F80D609CC440224E008011A008E60AEFD4A644F';
wwv_flow_imp.g_varchar2_table(139) := '0099E795F95E336DF399715C7AF76DA487EF9865639ACB09040341747CE125CC6B5FA925E94DD91E5A19015A99998904AA44C06FD5D200F05B8B5750DF445D082DB1A8650DD9C1415CFCCDAF20BB055A666606D712309411B0E64B5FC5E20D8F68C92846';
wwv_flow_imp.g_varchar2_table(140) := '803C1D909E002D5CCC440215274003A0E288FD55816CF032CFE26141426478E026CEBDFC07E45349F9CAB74709048241ACDCFB021674EA4D070C8C6720D3018C08F06883D7B4D8FE538E0680FFDABCE21AB7C46390C86FAB8A6E5FBE8CB3AFBF86FC44D6';
wwv_flow_imp.g_varchar2_table(141) := '2A2BD35D4C20209E8097BE84859A3101054F4032E5628D281A09F883000D007FB4B3A35A1AAAB625B11864A320F5D1F43578E11CCEFCFEB7C84D7279A02928D7271AE8F8FC17B4A7036E6532B8914E3330D0F5EDEA1F01FDA8290D003FB6BA033A4B3CC0';
wwv_flow_imp.g_varchar2_table(142) := '128D78001165E8F2251CFFF5AF30911C93AF7C7B9440301842C7732F60E19A755A1AC85480BCB5323313099040D909D000283B521678974073380C79E4ABD52641923F75E5324E284FC0E8CD7EF9CAB7470918C120562B4FC01279F091860E85E980540A';
wwv_flow_imp.g_varchar2_table(143) := '8C09D080C52C1524E0CFA26900F8B3DD1DD35A8C80A5CA1310306462C0BCDAD4B51E9CFEEDAF31D8DB6B9E91A9AE26601801B47DEE0B58A0E90990C0C09BE9711A01AE6E550A578B046800D462ABBA4C27D925503C013A46C0C4F01D9CFDC54FD07DE238';
wwv_flow_imp.g_varchar2_table(144) := 'B87B9CCB1AD28638B24FC01A65042C5AAFB74450E2017A1918688330B39693805FCBA201E0D7967758EFC6BA3AB4C6635ABB05E6B359F4BCF5062EFEE55DA4D369872565756523100860E5DEE7B1B873AD56910C0CD4C2C44C245036023400CA86920559';
wwv_flow_imp.g_varchar2_table(145) := '1190E9003102743C01531359F4EFDF87D37FFC1D6EF6F5D11B6005D7A5E985C0C02FBC84F99AFB044850A0BC5DAA0EC5AA4902FE558A06807FDBBE2A9A37284F407B22814820A8557FFA4A172EFCECC738A5BC018323235C36A645CD5D99242660CDE75F';
wwv_flow_imp.g_varchar2_table(146) := 'C2920D1BB504BB1B18C81D03B570311309944C800640C9E87862A9046489604B3CAA351D20758837E0CE81FDB8F0DB5FE3F2E993488F735A40B878E92DDB06B73DB7170B343D011218289E00AE0EF0522B7B53563F4B4D03C0CFAD5F45DDED7A023095C7';
wwv_flow_imp.g_varchar2_table(147) := '447F1FFADF781DC75F7D05972E9C472A93A9A206ACDA2E01990E58F3D297B048D308104F40CF5892AB03EC82667E12D0244003401314B3959F403414C4F2440C620CE8962EDE80890BE770E38FBFC399375EC3B5DEEBC84D4EEA9ECE7C5527607CFC28E1';
wwv_flow_imp.g_varchar2_table(148) := 'F51BB42419CA66D1974A71EA478B1633D927E0EF336800F8BBFDABAE7D2C14425B228E05F5F5B66499CAE5903E730A577FF50B1CFFFD6F71E3E279E4B99DB02D86D5CA2C9E808EBD2F62FE5ABDD501321DD097E2B44FB5DA8BF5D62E011A00B5DBB69ED1';
wwv_flow_imp.g_varchar2_table(149) := '4C5605C86641AB1A1B2006811DC1A7C6D348A9CEFFD29FFE88833FF9312E1CD88F819BFD85E9010691D921E96C5ED931B0F3732F61B1E603846489604F32494F80B3CD54F3B5F95D411A007EBF025CA47F5C7903563624B050790374B60F9E2EFA543683';
wwv_flow_imp.g_varchar2_table(150) := '6CDF75F4BFFB162E28AFC0B9B75E47D785F3B875670859E52D989E979FDD41206004B0529608AEECD012683093C50DEE18A8C58A99484087000D001D4ACCE31881A061401E22B4BAA9014DE1BA92EACD8F8D2279EA24FA7EFF1B9CFFE10F7044190427DE';
wwv_flow_imp.g_varchar2_table(151) := 'FB0BAEF5F5622C9D0677182C096B454E924709AFFDD257B1689D5E4CC0C0F83818185891A6F061A154990600AF01571208070258914840A606EC7A03EE293435857C3A8989EE2B1839B00FDDBFF915CEFCFA1738FDFAABB8F2C17BE83B7618B72F9CC3E8';
wwv_flow_imp.g_varchar2_table(152) := 'B51E24076E627C681013CA7898CCE76924DC83E8C007D5D62B9F7F01BAD3017703032755FB3A201DAB20819A254003A0669BD6FB8A194A05090EEC9C8537401551784D4D4E229F1C43A6F73A868E1FC53565005C7AFD359CF9EDAF71EC673FC1895FFE1C';
wwv_flow_imp.g_varchar2_table(153) := '275FFE13CEBCF60A2EBDF22774BFFD26FADE7B178387F663F4C45124CF9C46B6E72A7203FDC8AB6985A95412539971C8AA04E426000940CC4F0253F9427DFCCF1E814260A09A0E98D7B652EBC481F10C6E3030508B1533CD4C80478100219080DB09D4A9';
wwv_flow_imp.g_varchar2_table(154) := '11629BF206743636221AD4DB41D0964EAAE3CEA991FF78EF358C5CBE849BA74FA2E7F0415CDEB70F67DF791B275F7B1527FEF4071CF9F94F71F8FBDFC3917FFFDF38FABFFE5F9C54EF73FFFEAFB8FCE3EFA35B4D33F42A03E2D69FDFC1883A77E2E60D1A';
wwv_flow_imp.g_varchar2_table(155) := '03B61A01300241ACF9CA57B144F301421218783D99626020F84302A511A001501A379E550502D15010ED0D09C883859CA87E0A5385CE455CCD3935B29F50530359F54E2B6F423297C37026835B23C3E8EDBF89EEAB5770F9CC295C3C74B0F010A3F3BFF8';
wwv_flow_imp.g_varchar2_table(156) := '19AEFEE07B187AF33564CF9D417EE836A00C0D27E4F6721D1213D0BEF7052C5ADDA9A5861801DC31500B1533DD47805F84000D00A1C0B767088837408C80F5CD4D581E8F1702054B8E1140F97F72CA40484D4C602895424F7F3F4E1D398CC37FF83D4EFE';
wwv_flow_imp.g_varchar2_table(157) := 'F217E852BF878E1D41EEF62D14A60DCA5F7D4D94180806B1FA8B5FE68E8135D19A54C2CD046800B8B975285B51026208CC89840B46404763022DB158C13320C183068CA2E7552341BC0723778670FDFC599C93AD8C9567E0EC4F7E54883148A9690728A3';
wwv_flow_imp.g_varchar2_table(158) := 'A11A72B9BB4E032B3FFF1216AF5FAF25E6C7818169E41918A8C5CBEF99A8FFC70468007CCC81FF7B94806C2254AF468CF3EB2385E981D54D8D58168F42F614305C660840FD8831201E825B37FA7069DF8738FAE31FE1ECBFFD2F240F1F2C0415AA2C7C7D';
wwv_flow_imp.g_varchar2_table(159) := '4220180862D50B9FC7C2757A46C0C0F8386EA4B963E027F8F88B042C09D000B044C40C5E2210320CCC8D4420BB0AAE6B6E846C2C2453058BA351CC53C7257E20160C6A3F891015FEC94FE571EBCE1D1C7FE72D74FDFA9748292F016305A641370258FDC2';
wwv_flow_imp.g_varchar2_table(160) := 'E7B0648DFEB6C1B263A0C46D4C2B851F49601A017EBC4B8006C05D12FC5D7304649A401E342453058BA2F5CA3310435B4302AD8978E1F3B278ACB0EBE09C70B8E031901506B211513540C8DE03BDD77A70E68FBFC7F53FFD1E931227500D415C58A7AC0E';
wwv_flow_imp.g_varchar2_table(161) := '6857D3010B349F2238283B06A6D29C0E70615B5224771108B84B1C4A4302952560A8E265CA403C01E211905D07972B83403C069D6AFAE09139CD85A904311E50851F5961D075F62C0E7FFF3FD0F7EA9F901F1BAD8214EEAB32A03C016BBEF0452C7E64A3';
wwv_flow_imp.g_varchar2_table(162) := '9670B23AA02799C294566E66F21301EAFA57023400FECA829F48A040203991832CF92B7CB1F82F9E4860D59A35E8D8B8092D2BDAD0D4DC8CFABA30826A2AC2E254D3E44C2E87CB274EE0F80FFF13B73EFA0053C931D3FCBE48544640FBB37BB1E4914D80';
wwv_flow_imp.g_varchar2_table(163) := '06DF3BD92C7A9511C0E900F087046624400360462C3CE85702D2690C8C67B4D48F47A3E8DCF138E66D7804F357AFC6B2AD8F15BEAFDBBE1DABD7ADC7B2254BD1148B211C0C6A95F760A629357E1D1B1DC5D9BFFC19E77FFD0B8C5FB9FC6016DF7D971D03';
wwv_flow_imp.g_varchar2_table(164) := '57EE7D010B349F1D209E80DE54CA779CA87031023C3E9D000D80E934F8D9D7040633195C532346E978AD40444321ACD9FD04C26AC47F2FAF9A5F082412082F5E8CA6B56BD1B26B17D63CF73C367DE669AC53A3D6852A6F24509A313070E3064EFCEA97B8';
wwv_flow_imp.g_varchar2_table(165) := 'FEE6ABAA3A7F3BB60DC3C0EA175EC4922D8F2A16D62F8909E81E4B829E006B56CCE12F023400FCD5DED4B60881E1EC047A5369AD4E22A146F56B9FD883436E4A5B0000100049444154BAA6A622A5FDF5B01130106C6C4063E76AB43DF529ACDDBD1B6D1D';
wwv_flow_imp.g_varchar2_table(166) := '1D686A6C422060EFCF2F939FC495234771F58FBF433E95849F7F024600ED4F3F8B856AEA45673A40F609906707E4B94F809F2F1B50F9FB09D8BB03DD7F2EBF91404D1018CA64D19D4C6A75FEF1FA28D6A9CE3F3C6F9E6DDD0DE535A85FB8108B366FC19A';
wwv_flow_imp.g_varchar2_table(167) := '279FC4E66DDBB174690BECEC6428DE899E336770F6F7BF436E64D8B60CB5748218019D7B9527409E1DA0BC0256BAC974404FC1C3639593E924E00F023400FCD1CED4B2080199F39791BFCEC8B0A1A1A1D07107D4EF22C5691F36221184972D43EBCE9D58';
wwv_flow_imp.g_varchar2_table(168) := 'FFE94F63D1A24530D43FDD02067BAEE2E4CF7F8A34970BA2FDF917B174D3662D7485F6564600A703B470D55826AAF320011A000F12E177DF1010B77FF7580AB23B9F95D2B14403566D7F1C7565E8FC1FAC2B3A670E56A8B23BB76C412C967830B9E8F7B1';
wwv_flow_imp.g_varchar2_table(169) := 'A1419CFAD94F307AE942D13C7E48081806563EBB170B348D00F104F43230D00F970675B4204003C00210936B93C0A08D80BF783486B56AA41E6EB69EF32F959611AE43F3CA9558BB7B1796B52CD39E16184F8EE1E4CB7FC4C09143A5565D23E71958AD8C';
wwv_flow_imp.g_varchar2_table(170) := '00DD25820C0CAC9166B7A106B33E4C8006C0C34C78A4C609C8C8BF3795D61AF927D4887FD5EE2750D7D8E80815A9A7E5F1C7B1EEC927D1AC196730393E8E736FBD89EBEFFF59C9E8DF15021213D0BEF7052C5CBF4171B07E3130D09A1173D436011A00B5';
wwv_flow_imp.g_varchar2_table(171) := 'DDBED4EE0102433602FE62F1043A956BBEBEC999CE7FBAA8B1F9F3D1B96B3796C91EF8CAC53D3D6DC6CF5379747DF801BA5E7F4D25FBD90830D0F9C2E7B078CB56C5C1FA25D3010C0CB4E6E4FD1CD4602602340066A2C2633549A01000A646FE3A017F09';
wwv_flow_imp.g_varchar2_table(172) := 'E5F65FB36B17EA2AE8F6B7826C84C368D9B001ED9BB7C0300CABEC85F4EBC78FE2EA6BAF60CAD7CBDD0CB47FF6692CD9B8190A1CAC7E0AD7050303AD3031BD0609046A5027AA44020F11189D98807EC05F23562BB77FD821B7FF43C23E7060E1CA9558B3';
wwv_flow_imp.g_varchar2_table(173) := 'E749049441F040D2C35F55C7DF73FC18AEBCE16F4F403010C4CAE79EC782B5EB1F6634C311F104F43230700632B571885ACC4C8006C0CC5C78B48608C808EF6337AFB56B3C118F63CD8EED0857C1ED6F86BC69C102ACDDF504C291A859B67B69D78F1DC1';
wwv_flow_imp.g_varchar2_table(174) := '9537DF509E80FCBD637EFB60180656BFF8392CD9FCA896EA77030373CA88D23A819948C0E304680078BC0129BE3981B1895C61873F9D87FB24623174CA263FCDCDE6855629B561DE5CACFDEC67109B334F4B826B470EA1A7E009D0CA5E9399024600ED4F';
wwv_flow_imp.g_varchar2_table(175) := '3F8385321DA0A1E1DDC0C0491A011AB4BC92857216234003A018191EF73C0189F6BF3236A6F564BF5834A646D8BB5197D05F875F0D40D16814EB76EFC29C9616ADEABBD57440D7AB2FABBCD6DE0F95A9265F01351DD0B9F779E82E11BC9DC9E02A9F1D50';
wwv_flow_imp.g_varchar2_table(176) := '93D70295BA9F000D80FB79F05B8D10185173FE32A7AB33928B854258BD6D1B824D955BE75F4EACA148046D5BB662CEE2C5D6C5AA91ECF513C7D0F79777555EFF1A0180015922B8549E1D00EB1F8919B99E4C69198FD6A531473509B0EEE20468001467C3';
wwv_flow_imp.g_varchar2_table(177) := '148F1210B7BF8CE0B279EBF9EF68A41E6B958BB85ECDB17B49DD70248C8E9DBB3177A99E27E0D247FB70E5B557BCA462D9652DEC182881819BB768952DD301D75329F8D96CD202C54C9E254003C0B34D47C1672220017FDDC9247496FAC5E371ACDDADDC';
wwv_flow_imp.g_varchar2_table(178) := 'FEEAF74C65B9FD5830A046B55B1FC382156D5AA25E3B711C575F7BD9D78181509E80D5CF3CA73D1D5098461A1D030303E1D11F8A6D46800680191DA6798A808CFC7B53692DB76D4CB9D13BB6ED4078CE1C4FE9F8A0B0A1701D966FDA8C66CDE9005922D8';
wwv_flow_imp.g_varchar2_table(179) := 'F3F69BC094B577E4C1BA6AE57B2130D0C68E81329DD4A73C013AD349B5C2887AF883000D007FB473CD6B5918A96906FCD5AB39FFB57B9E4274DE5C47B94C4CE691CB97DFA11CAA0BA163C74ECC5FBE424B9FEEC387D0F5C6EB2A6FF96551857AE215308C';
wwv_flow_imp.g_varchar2_table(180) := '8F770CB4B14450A695680478A279EF09C90FE604680098F361AA0708C808AD577384165723FF353B77A1CEC175FEB9B124CE1F3B86136AE47DFCEDB770E1C8114CA4D365251B0A0595276013E62D6BD52A57F609E87EED55F87EC7C0A79FC1924D5B0065';
wwv_flow_imp.g_varchar2_table(181) := '10C0E2878181168098EC390234003CD76414783A0171FBCBC84C27E02F120CA15375FEF50B174E2FA2A29FC76FDEC4A90FDEC7D0A58B981819C1C4F01D0C765DC685FDFB3199C994B5EEBA7018ED8F6E45F3E2255AE5769F3886AB6FBCAAF2FAD713203B';
wwv_flow_imp.g_varchar2_table(182) := '06764860A0E68E810C0C54978B675E14D48A000D002B424C772D0171FB6B07FC45A3D8F0A94F23ACF984BD72289DE9EB539DFF07181F1B7DA8B8D1DBB770E3E2C5878ECFF640B04EA6037660A1CE74C0D414AE1D3B8AABCA3331E5E3980061BEFAC5CF7F';
wwv_flow_imp.g_varchar2_table(183) := 'EC09902F166FB9EEAE3030D0821293BD40800680175A89323E442095CB4196684D682CF58BC762E8D8FEB8A30FF649F7F5E2F4E1C36ACE7FF221D9EF1EB83D38A85CF077BF95EF77281442EB26351DA0B944B0E7D041EE18A8A600DA9F7D0E0B653A40A3';
wwv_flow_imp.g_varchar2_table(184) := '2964DA8981811AA0AA9885555B13A00160CD88395C46406EBE97D5084CA7F317B7FF9A1D8F233A5F6FFBDC72A89AB9750B670F1F4136336E5A9C38DEE56D9AA9C4C4909A0E58B96D1B166A1A01DC311090D5019DCFEDC5E20D1BA1131320CF0E90E92706';
wwv_flow_imp.g_varchar2_table(185) := '06823F1E254003C0A30DE757B1EF0662E9DC74E3B2BDEF934FA16EEE5CC77015E6FCDF7FDFB2F317819A972C559D8E7CAACC3B209E80C7B66181E674C0F513C7D0EDFBE900A3B0636061DB608D66B97B3DEA18A31AC5314BD908B0201D0234007428318F';
wwv_flow_imp.g_varchar2_table(186) := '2B0888DBFFCA58123A017FD1FA1856EFD881FAB9731C935DE6FCCF1E388089C99C659DF54DCD68695D66996FB619648960DB9A3568D6DCEFA05B4D075C7DE3B5D956EBE9F38381003AF63E8F059BB768E9C1C0402D4CCCE4420234005CD82814E9610212';
wwv_flow_imp.g_varchar2_table(187) := '7825EED6FC94B5D33CAA46BE6B77ED44C4C180BFF181019C3E7408190BB7BF6816320258A3E6E84391887CADFCBB3EAABC20F39457DBD0AAEBDAF163DC3110065673C740ADEBC58D9928931E011A007A9C98AB8A0464E42F017F3A23FF584C8DFC773FE1';
wwv_flow_imp.g_varchar2_table(188) := 'E80E7F99FE1B38FDE187C866AD97F585EBC278E4892750EFE0B30792376EE04ED7654C69184F856656F90A3B06BEF586FA6A6D70A94C35F992988076D93170DD062DFD24368581815AA898C925046800B8A42128C6CC04E4A6AA1BF0276EFFCEED12F037';
wwv_flow_imp.g_varchar2_table(189) := '7FE6C22A70745C75AE670E1DC6446EC2B2F4703882758F3F8E8883FB100C5FBF8E0BC78F6A6D8FFCA002DD470EE332770C44E78B9FC362EE18F8E0E5E1E2EF144D97000D005D52CCE73881BB01563A017F31E54E5FB37B17220E6EEF3B7EEB16CEA839FF';
wwv_flow_imp.g_varchar2_table(190) := 'CCB8F5AE7E75A13AACDFB50B4E6E42347673005DAA139F98C58643BD470FA39B3B06A2FDE967B078D366ADBF01B96EAF255325195D5A153013099489000D8032816431E525206E7FDD80BF582C81CE5DBB11696E2EAF1026A565D4C8BFE0F69FC89AE4FA';
wwv_flow_imp.g_varchar2_table(191) := '3829128D61C39E3DCA3899F7F10107FE1FEBEDC3D90FDF47266B2D9F9538851D035F7F4565F3EF74403010C42AD93150A6030CEB588A3B8A7B8F3202FC4B4C5D2E557AB15A7D023400F45931A74304C4EDDF3D96824EC05FBCBE1E9D3B7620E2E4523FD5';
wwv_flow_imp.g_varchar2_table(192) := 'F99F39ACDCFE1A9D7F38528FB5DBB73B2A9FB8FD2F1E3D82C9C9E29B10D96ACAA929486060CF3B6FA9D3FCDCA51958FDE2E7B1D48627E0F2C8283D01EAAAE1CB9D046800B8B35D7C2B553A3789EB6AE494C95B775E51E5F6EFD8FD84EA5CE738C62B3334';
wwv_flow_imp.g_varchar2_table(193) := '84D3BA6EFFBA30363CB107F5F39D8B49480E0CE0F2A183D099969027E2458341043546B402F8EAC103E82B0406CA377FBE8559DB33CF41372660CCC68E95FE245A6EAD599E1D02013B999997042A4940E64EBBC6C6F4D6F9C7E258A3DCFED1E6E64A8A74';
wwv_flow_imp.g_varchar2_table(194) := '5FD9E3376FE2F4071F624263E41F51F26DD8BD1BE1E6A6FBCAA8E49791EBD795DBFF036455A763558F0103ADF1183A1A1BB04ABDE3A190D52985F44B470EE3EA6BAFA8CFFEF504048C00563DAB8C8047F4760CBCBB845527964581E58B041C234003C031';
wwv_flow_imp.g_varchar2_table(195) := 'D4ACC88C4052755AD793692D77694C8DFC3BB73BECF65723EBB3CAED9FCD5807FCC952BF75DBB621E2E03E04236ACEBFEBD831E4144733CE9226FB102C4FC4D01C0E1746FFF5CA0B20C6404CFD9674D3B79A0EE8397E943B062A03AAFDB917B078C323A6';
wwv_flow_imp.g_varchar2_table(196) := 'B8EE26CAF5CDC0C0BB342AF79B25DB2310B0979DB949A0FC040A017FA349E8B8FDEBC311AC79F229D43B18ED2F6EFF33FBF621934A5A2A5F27D1FE4F3D8588836EFFD4C02D9CDFBF0FE31AAB1164E4DF128F163AFFE9CA4454E7DFAE3C015A46803A5176';
wwv_flow_imp.g_varchar2_table(197) := '0CBC525822A8BEF8F4150C284FC0F32F6AEF18788781813EBD52DCAB360D00F7B68D2F2413B7BF04FCE5341E479B8827B04ECDF9871B1B1D6333AEDCFED2F9676DB8FD234D4D8EC9276EFF731F7D88498DA72206D55C7F5B431C32F29F49C0904A5FD190';
wwv_flow_imp.g_varchar2_table(198) := '40435DDD4CC90F1DBB7EEC889A0E78597F83A1874AA88503C6C73B066EDC0C287EB0F891EBBD4BF34156164531F921023C6097000D00BBC498BF6C0424E04FDCA23A23FF9872FB776CDF8EB0837BFB676FDFC659D9DE379DB2D4B9AE2E8C754A3E2747FE';
wwv_flow_imp.g_varchar2_table(199) := 'B2C3DFE563479155234B2B01A5F35F1A8BA2D1A2730FAB51EDB2780CBA9E809E13C7D1F3D6EBAA7A7FC704B43FF73C16CA124145C2EA2546406F2A8D9C9A4EB1CACB7412A824011A0095A4CBB28B12909BA076C05F7D146BC5EDEFE052BFCCE0104E7EF0';
wwv_flow_imp.g_varchar2_table(200) := '01321A9D7F584D4B6C10B7BF8373FEA3FDFD38BBEF4364C6CD1F392C0D60C0C0F2441C73951125DFADDE6204B4294F40422730507562B26360D79B6FA862FD6C0418851D039768EE187847196D579527808181EAB229D38BC5D82710B07F0ACF2081D911';
wwv_flow_imp.g_varchar2_table(201) := '189BC84137E04FDCFE9D3B77A2CE49B7BFEA5CCFECFF483BDA7FBD92CF49B7FF586F2FBA0E1E444EC3ED7F37E0CF6AE4FF608BD6DDF504E81801EAE4EB470EA1C7E74F118432B4DA9F79162D5BB642E74796088A076C42A31D75CA631E12B04B2060F704';
wwv_flow_imp.g_varchar2_table(202) := 'E62781D91010B7BF3CD54FC7ED2F017FAB76EC40BDC323FFB3478E402BE0AF2E8C754A3E27DDFEA99B377141C997D678EAA08CFC670AF8D36DBF4260A0F204E84E075C55D3113DAFBFAA8AF7B32720003102166FD05B22289E00EE18A82E9959BF584029';
wwv_flow_imp.g_varchar2_table(203) := '04680094428DE7944440DCFED2F9E73402FEE2D118D6C9F6B9739CDBE447E6FC4FBDFF9E56E71F8E44B161CF938838689C88DBFFBC3C7550A3F397397FB3803FDD06B41518A8A603AE1E3B829E77DF56C5FBD70880F204743CFF2296D9D831908181E04F';
wwv_flow_imp.g_varchar2_table(204) := '1508D000A802743F569999941DFED25A4BFDE2B1180A017FCDCD8EA11A1F18C0E9FDFBF5DCFE629C3CBE039139CEC997EAEDFB7887BFC99C2513E9FC7502FE2C0BFA2483C404B4C663905D033F3964FAEBEA81FDB856880930CD56D38986616085EC18A8';
wwv_flow_imp.g_varchar2_table(205) := '391D20C63103034BBF2478666904680094C68D67D92020EBFCBB34D7F947945BBDF3F15D883AB88E3E333C622FDA7FC7E38E6EEF3BD6DF8F73870F61BC02017FBACD283101ED6A3A402B3050157AA5F014C157D427FF7A020C2380551213A0B94450A603';
wwv_flow_imp.g_varchar2_table(206) := 'AE8C8E21A73C290A1C5F2450710234002A8ED8DF15C89CBF043AE9CCF927D4C87FAD72FB871D1C59676E0FE2F49FDFD572FB47EA95DBFF8927107170132259EA7771DF3E64D930963C0000100049444154B319CB0B4946FECB1331D80DF8B32CF8930C62';
wwv_flow_imp.g_varchar2_table(207) := '04149608EA0406AA4EACFBF8515C7BFB2D4063CAE7932A6AF097F2043CF73C5A1ED9A4A59BEC18D83396D4DA0E5BAB405F64A292A512A001502A399E674940DCFEB2D42FADDCFF5699EBEBEBB16AFB0ED43B38E72F6EFFB3070F406B931FD5F93BFD54BF';
wwv_flow_imp.g_varchar2_table(208) := 'E4F5EB382FFB1068B8FD25E04F3AE7629BFC58F1D74DB71B1878E5D001F4881100FF7A02E40142ED7B9FD77E80D0C74FC34C6A3D0D53B7DD988F046622400360262A3C366B02329291803F9D254EB148A4B0C35FC4C175F405B7FF8103184F8E59EA5AD8';
wwv_flow_imp.g_varchar2_table(209) := 'E467D72ED42F586099B75C1946070670F1C811643502FE64A95F3902FE7465B71518A80ABD7AF8207A5E7F4D7DF2F3CB40879A0E58B6E551C03060F5237F3F97D47440964B04AD5081194A274003A074763CB3080119F98BDB5F67E41F8F27B06AD71308';
wwv_flow_imp.g_varchar2_table(210) := '37371729ADFC8733B76FE3F45FFE8C8CC6DEF991680C1B9ED88388839E89545F1F2E7EF03EC635DCFED2F9CB52BF4AB9FD8BD1B71D1828D3016FBEAE8AF3AF27C0300258F1F47358BCFE1140C30890D899EBC994D603B2C01F122881000D8012A0F194E2';
wwv_flow_imp.g_varchar2_table(211) := '04E4A625017FE31A6EFF58348AD5CAED1F75707BDFCCAD5B387BF02074E6D465A9DFC76EFF39C5152E738A6CF273EED0616435F8C99CFF8A441C9576FB1753516202B40303A7A670E5C82174FB7C3AC0300CAC7AE145B46CDA520CEB7DC7653A40020375';
wwv_flow_imp.g_varchar2_table(212) := '3C69F79DE89B2F547436046800CC861ECFBD8F809D803F71FB77AA917FC4C9CE7F7804A73FFA48DBEDBF7EF76ED43BB81A419EEA7749CDF967B3D6DBFB4AE7BB5C75FE89BAD07D6DE0F41791A355C911D7090C54C2751F3A806B054F80FAE2DB9781156A';
wwv_flow_imp.g_varchar2_table(213) := '3AA0E5D1C7B408A49431289B05713A400B1733D9204003C0062C662D4E20A36E52BA017FB158026BA4F36F6E2A5E609953C6D5C8FFF47BEF69CDA9476271E5F67F42B9FD9D9B9648F6F6E2CC07EF615CE3A98301358A94803FA7DDFEC59A44A603563624';
wwv_flow_imp.g_varchar2_table(214) := '10D33402AE1C3D82EED75F51C5F9773A206004D0FEF43358FC88DE8E81B24F40F7180303D54573DF8B5F66478006C0ECF8F16C45400296EC04FCADD9B1C3D1A7FA650607714E46D699B492D6FC254BFDD62BF99CDCE16F4475FE978E1E434E1951E6D201';
wwv_flow_imp.g_varchar2_table(215) := '32E7DF9E48546CA99F55FDC5D2C52869539E002DA3444D0774CBB6C1EFBCA58AF3AF110018E8D8FB22966DDC049D1FF93B93C0404E07E8D0621E1D02019D4CCC4302C508C8CD4802957402FEA291083AF73CE56CE72F6EFF0F3ED072FB8723F590A7FA85';
wwv_flow_imp.g_varchar2_table(216) := '1DDCDE37353080CB070F203D6EFDC861E9FC5BE25154DBED5FEC5A90E900F14C683F3B40E9DDF3D61BC58AF3C571C350D301CFEEC562CD1D0325C646026CB959905C1E7CCF96000D80D912F4F1F912E8D7353A06ADCE5FB9D5D7ECDA8D4853A363C4649D';
wwv_flow_imp.g_varchar2_table(217) := 'FF990FDED70AF8AB4F3462FD134FA04E8DAE9D125002FECEEEDB874C4E6F7B5F2797FA95CA408C80F6C60634D4D5691571F5C86174BFF68A56DE5ACD64A8E9003B3B064A60E055F57797579E945A6542BD9C214003C019CE35578BCCF94B60924EE72F01';
wwv_flow_imp.g_varchar2_table(218) := '7F12EDEFA45B3D73E70ECE1D39824CDA7A645D17AEC7DAEDDB10696E76AC9DC6FAFA7059B9FD2734E6FCA55395803FDD403BC794285291EC13209E002D79552756D831B0E009F0F774C08AC28E811B8B50BDFFB03C4A589E1D30A9F8DD9FE29F6FD474F6';
wwv_flow_imp.g_varchar2_table(219) := '046800CC9EA1EF4A10B77FD76812E28EB4523EAADCEA9D7B9E44D4C1ED7365939FD3EFBF8FF1B1512BF1108E44B1F1D39F8693EBFCC53371FEA38FB4DCFE32B72E0FE2D19A5BB7D4D6B90CB6030365B3209F2F1194B66EDFFB82F68E81B73319DC4859C7';
wwv_flow_imp.g_varchar2_table(220) := 'B538D7EAACC96B04680078ADC5AA2CAF2CF5BB3296D47BAA5F3C818FDDFE4D8E492D8FF43DBBEF43AD687F71FB6FD8BD4BB9FDE38EC9276EFF73AAF39FC84F5AD62973FE12F0A7EB4EB72CD0E10CD2A16907062AD9AE1E3AC01D0361A0E3E967B04C760C';
wwv_flow_imp.g_varchar2_table(221) := '544CAC5EB7335988216095AFF6D2A9513908D0002807459F942123FF6B49BD917F7D388295DBB623E2E43A7FE5F63F7DF01074B6F70D2BCFC4BA1DDB11767087BFF4CD9BCAED7F147676F8736BC09FEE252FD317321DA01D1878EC087A5EFE832ADEBFD3';
wwv_flow_imp.g_varchar2_table(222) := '01462088154F3F8BC51BACA703A63005990AC872CB6075CDF06597000D00BBC47C9AFF6EC09F6C4A6285A05E1E9CB3670F624EBAFDA5F3576EFF4CD2DAED5FD8DEF7A9A7106E6EB652A56CE9C9FE7E9CFDF003E5F6B776D9CAC8DF0B017FBA70C408B015';
wwv_flow_imp.g_varchar2_table(223) := '1878EA24BA7D1E13604860E00B9FC3E235EB2C314B30A0AC0CF093C964098519B408D000D0C2E4EF4C32BAD00DF88BC7E3582DEBE89B9B1D83266EFF331FEDD774FB3760DDE38F23DCD0E0987CB2C94FD7A1835ADBFBCADCF9F2440C5A01748E6930FB8A';
wwv_flow_imp.g_varchar2_table(224) := '6C0506AAEABA0F1FC28DB7DF549FFCFD6ADBFB3CE6B62EB784201B05F5A7AD8D4BCB8298C157046800F8AAB94B53B66B744C2BE02F1C0E63D5F6C7117370FB5C09F83B73F0207446FEE2F65F2BC68983EBFCC795DBFFC291C3488E5B6FEF1B340CB42A03';
wwv_flow_imp.g_varchar2_table(225) := 'CAAB73FE565797183776760CBCA88C806B6FBCAA8AF5EFD836A4A6D256BDF425841B9B1407F3D7C07806B23AC73C572DA452877211A001502E9235588EDC76AF275310F7BF957A51E5F65FB76B37EA9D9EF37FEF2F5A73FE91581CEBF73C894873B3952A';
wwv_flow_imp.g_varchar2_table(226) := '654B1FBB7143B9FD3F442693B12CB3E0266F48B876931F4B053433D80A0C9C9AC2D5A347D1F7E77754E97235AA5F3E7C85A3B142606028526FAABD4C058811E05F52A678983803011A003340E1A18F09F4A5D2B8A5D179D5D7D7A3E3B16DA89F37EFE313';
wwv_flow_imp.g_varchar2_table(227) := '1DF83F3B3888B3FB0FE8B9FDE309AC9391BF839B10A5659DFFE1C36A4466BDC98FCCF92F8D456BCEED5FEC32106347020375A63924C8EDD2FE8F70ED2D990EF06FD736AF633596EEDC550CE9BDE38399AC96B7EEDE091EFC4091CB47800640F958D65449';
wwv_flow_imp.g_varchar2_table(228) := '83AAE31FD0705B4794DB7FEDE33B115FB4D031FDB3C924CE1C3880F1B111CB3AC3CA85BA6EE74E441C74FB276F0EE09C9AF34F8F5BCFC98ADBBF9602FE2C1BE4930C6204B42B8F47B3BA7E3E3964FAEBCAE183E87E4DA6034CB3D57462EBD6C73077AD79';
wwv_flow_imp.g_varchar2_table(229) := '50A0184CC3D96C4D73A072E5234003A07C2C6BA624D96AF45AD2BAF38A2AD764A71A95441C1CF967868771FA2F7A6EFF7A35F25FFFE49308373539D63669E5F6BFB8EF0364346EC27581009627E2BE19F93FD80862FC88E74337E6A1FBC431E509906707';
wwv_flow_imp.g_varchar2_table(230) := 'F8D313600443E8FCF467118E461F4479DFF7E484B5D7E9BE133CF585C29693000D8072D2AC81B2E4D62AF3FE32923053A7AEAE0EAB1E7BCCD980BF3BC33877F01032A9A49968853499F35FBB7D3B220E76FEE3CAED7FEEF0218C6BEEEDBF3C1E77DD53FD';
wwv_flow_imp.g_varchar2_table(231) := '0AF01CFC4F8C20D92C28110A59D73A3505F1045C7BE76D9557AE54F5CB67AF50A2014B373F0AB39FF17C1E3A713B666530CD1F046800F8A39DB5B51C52AE7F59F6677682047215A2FD173AEBF63FABE682D3C34366A215D224DA5F02129D74FBA7066EE1';
wwv_flow_imp.g_varchar2_table(232) := 'BCEAFC331AD32632E72FEE6FAF6FF253805D86FFE47A124F88EE74C0D58307D0FBCA1FCB5073658BC84FE690CF5A0780DA95A2A17D258CBA70D1D3241870AC46BD0045956642490468009484AD364F921B477FDA7AB95AEB868D685CBCC8310819D9E4E7';
wwv_flow_imp.g_varchar2_table(233) := 'BDF7D49CBFF5263FF56A84244FF58B3819F0A7DCFE1764931F653C594191CEBF251EF5ADDBBF181FF104B4C463D0F1048877EAF2C993B8F6E66BAA38777902867BAFE1DC1F7F8F833FFC4F7CF41FFF8A8FBEF76F85CF97DE7B17A3033795BCB37FC5162D';
wwv_flow_imp.g_varchar2_table(234) := '4683C5B49B4CE3B98BCCECF56609E5274003A0FC4C3D5BE260260BABD1FFB2D59D58B47AB5633ACA9CFFB9438791498E59D61989C6B0769BB34FF5934D7ECE1D3E8CF1DC84A57CD2F9FB31E0CF12CC271964B3A0363B8181470EA347760C9CCA7F5242F5';
wwv_flow_imp.g_varchar2_table(235) := '7EE5272771E19DB770E2273FC6C0995318EFEBC5E4D0102687870B9FFBF67D88E33FFE212EBDF71725E4ECBAE63A355D3277459B2AA7F82BA9A6A1726A2AA0780E2FA650E67213A001506EA21E2D6F42DD2CAC1E2A128DC5B068ED3A1886334A6693C9C2';
wwv_flow_imp.g_varchar2_table(236) := '3A7A5DB7FFFA3D7B1C8DF61FBF750B970F1D444623DA5F36C1599E8871E46F71E9DC0D0CD47DFAE15535ED72FDB5972D4AAD6C725E1920A77EFE53F41FDC0F983CE4694A4D07F4ED7B1F277FF653D37C3AD2CE5DD961390D9099ACBE61A4A30BF3548F00';
wwv_flow_imp.g_varchar2_table(237) := '0D80EAB17755CDD2F98FAB514C31A10C2380B6CD8F2254A711AC55AC101BC733778671E6FD0F30AE11F05778AADF134FC0C9ED7D337D7D38A3DCFEA909EB91BF746AB5BCC39F8D66D5CA2AD301E20968A8ABD3CADF75E204AEFFE90F2AEFEC46D6AA8092';
wwv_flow_imp.g_varchar2_table(238) := '5E97DE791BC3D7BAB5CFBDD37D0517DF7E4B3BFF4C19A3F3E723BA70D14C49F78EA5276B6B35C03DC5F8A16C046800940DA5B70B1ACE9A7764CD0B16A061F1624794CC0C8FE0DCA1436ACE5F639D7F248A75DBB739FB601F99F33F7204598DCE5F46FEB2';
wwv_flow_imp.g_varchar2_table(239) := 'FD2D03FEEC5D3AE2646A8DC7A01B1878E5F429F45761C7C0E1EB3DE8575E087BDA01FDA74F62F4D680DDD3EEE53722F5882E987FEFFB4C1F26A7AA6310CD240B8FB99340C09D62512A270988FB3F63E22E0C84C358B86E3D9C70FD6795DB5F46D6698D68';
wwv_flow_imp.g_varchar2_table(240) := 'FFBA703D1EF9D4A7E0E4237D33CAED7F71FF47486AB8FD65242B3BDEC5D49CAD93ED592B75093F3B81811754BB5C7FF76DA5BE731D5FFFB1A3809A025095DA7A4D6532B8795C9D6BEBACFB334BCCCBFD47EEFF3699778EC3FD3557E21BCBAC04011A0095';
wwv_flow_imp.g_varchar2_table(241) := 'A0EAB132E5496212595D4CECC4E225883737174B2EDBF1CC9D3B38FBC1075AEBFC3F76FBEF465D225EB6FAAD0A4AF5F6E2B472FB8FE7AC5DAB12F0D79E4840D78D6D55B75FD36D07061E38809ED75F730CD7E888F5CA9462C28CA8EB09F9D2E7E983E148';
wwv_flow_imp.g_varchar2_table(242) := 'B1A20BC7E9012860E07F2604680098C0F14392DC24ACDCFF735B962114ACECA5921D1B8344D3A74775DCFEF558BB633B2273E638D644B2C3DF6535DAD375FBAF5086493414744CBE5AAE48622864C7409DC0403164AF1E3B826BB24F400923733B1CA794';
wwv_flow_imp.g_varchar2_table(243) := '8B7D229BB173CA7D7933CADB8559CCD3072CE2716A69FC7F1F387E291B81CADED5CB26260BAA1481AC72FDCB92A162E507EAEA90501DADCCC916CB33DBE3D9640AA7DF7B0FE93BD69BFC44EAA305B77FA4B979B6D56A9F3F3E3080B31FED43326DBD3DB2';
wwv_flow_imp.g_varchar2_table(244) := '7456D2F973CE5F1BAF5646990E90C0401D23400ABC72F204AE1502ED2AD70DCA94981801525F49EFFC246673BE6C0D5C52BD3C89043E214003E013107EFD95513721F10214D33F366F3EEAC3C5771D2B769EEEF1DC440E178E1ED572FB47E20D58B76B97';
wwv_flow_imp.g_varchar2_table(245) := '72FB27748B9F753E59E77FF1C07E644D5648DCAD4402FE3A1A1A10E39CFF5D2465FD2D4668ABF2ACCC8DE85D8F570F1FC2F5375F2FAB0CF7176620525F7FFF211BDFEAE7CE83A10C6C1BA7DC97D5B0F0CA09AFFB4EF0EC170A5E2902814A15CC72BD4140';
wwv_flow_imp.g_varchar2_table(246) := '3C00C524350C03B1850B110C54EE56D2DF731563FD7DC544B877BCB0BDEF8E1D8EBAFD65E42F6EFFA4C6F6BE32429580BF28DDFEF7DAAC121F42EA9A5C1A8B69C5564C610A5D478F28234062022AE309685EBEA23435951E733A3B01A3F45BB09507C0A8';
wwv_flow_imp.g_varchar2_table(247) := 'DC9F2DF8531B044ABFFA6A437FDF6B9153F398C520186A241B6D6A2E965C96E3035D572CCB91A7FA6D78F249D5F9575696E982246FDEC4D90F3F404AC3EDCF80BFE9E42AFFF9EE34CB1C1DCF94FF9D6D9A0000100049444154BABEAF1C39829E77DE5282';
wwv_flow_imp.g_varchar2_table(248) := '95DF0858B8761D0251FB81A8013595B570ED062553E9AF9CF2DE957EB677CEA4A495234003A0726C3D51F2A449A054205487BA68B4A27A042DDCB912EDBF568DFCC38D8D1595637AE1A9DE3E74C90E7F1AD1FEE2F697397F8EFCA713ACFC67310296C663';
wwv_flow_imp.g_varchar2_table(249) := '680A5B6F16249E80C203840A3101E5952D31672E966CDD6AAF5035346F797C17A2B3FCDB4A0FDF31AD3700BA004C0131110132F037814935422A46C050EEECE02CE6288B953BFD78F382E24F1414B7FFDAC79D77FB9F3F72483BE06FB99A9366C0DFF416';
wwv_flow_imp.g_varchar2_table(250) := '75EEB34C07AC4824B41FA97CF9D001F4FCE1774AC0F27A02DA77ED86D5DEFCAAD27BAF051B3761855DA3E1DED97FFD3026CB08FFFAF5A14F959CBA7BA8B28A1D60C195244003A092743D50F6A4C96621462000C3A8EC2862497B3BE2F3163C442ADAD888';
wwv_flow_imp.g_varchar2_table(251) := '82DBBFA9E9A1B44A1D48DDB881F3CAED9FC9582FEDAA536CDA1B12DCDBBF528DA159AE5C9D760203BBCF9EC1B5575F2969F39EE2221958FF95AF61E996AD308AADCD577F47465D18ADBB9FC09AA79F0502C1E2C569A464866E23ABA6A9CCB2468321B364';
wwv_flow_imp.g_varchar2_table(252) := 'A691000264E06F026663212338BB9B940ED9909AC79551FEDC858B1089C751DFD08805ADAD58BF73179C74FB8FF7DFC0A5238791D670FB4BE72F017FF150484745E6A93001F104D8090CBC72E218FACB1D13A03ADB95CF3C87CD7FFB2DB46CDC8C86E52B';
wwv_flow_imp.g_varchar2_table(253) := '109EBF00613545D0B0BC0DCB76ECC2966F7F072B763F09A8BCB34532AA46FF93B28F804941F541EFDFDE4DD463521908F00A2903442F17619809AF462D327F6A96A51C69A1FA7AACDEB3079BD5C868F3A73E8D95DB7720A45CBBE5285BA78CD4AD5B3877';
wwv_flow_imp.g_varchar2_table(254) := 'F0A0AD803FDDF5E83AF533CFEC0904D5B52AB118BA4B042F1E3A848FB70D9E7DDDD34B48A829ADF6BD2F60F3D7BE81EDDFFA36B6FFFD770A9FDB9E7C0AF1B9F3A7679DD5E7E1CB974CBD18212380806232AB4A7872CD13A00150F34D6CAEA0D94D223F31';
wwv_flow_imp.g_varchar2_table(255) := '01931902F3824B48959803680475955074D153C6FBFB7179DF8718D770FB33E0AF284657248811B024A61F18D875F0003E7E94B0991FAC44D5024188CBDF88D4036ABAA8C452663C2D9BCD60444D57CD98F8C9C1785D10A132D7FB49D10EFE6255952640';
wwv_flow_imp.g_varchar2_table(256) := '03A0D2845D5E7EC0649430353989BC7ABB5C8592C51B576EFFF3870F2399CD5A96219DCB0A06FC5972AA7606990E90C0409DD501989A42D7F163E87DF71D2576058C00556A255EC98B179132D932DB808139E188FABF12B5B3CC5A224003A0965AB3045D';
wwv_flow_imp.g_varchar2_table(257) := '822606405ECD87E7343AC712AAADFA2929E5F6BFA0DCFEE974CA521619F973873F4B4CAEC960284996C5E3D09D0EE83AB01FFDEFFD599DE581D7441657DFFF33A64C1E2224D76BA3C39EB44A906399952710A87C15ACC1CD04CC0C00F1008C8F8DB959FC';
wwv_flow_imp.g_varchar2_table(258) := '9264CB2AB7FFC58FF621A5E1F6BF1BF0C775FE25A1AEDA49E20990C0C0E6B0F5B6C15398C205753D5C7FF7ADAAC9AB5B71FFE183181B1E36CDDE5017E2E8DF941013EF12A0017097844F7F8702325E9A59F929E50118BF7D0B664B05673ED3BD47E5A97E';
wwv_flow_imp.g_varchar2_table(259) := 'E724DA5FA3F397402A3ED2D7BD6D69259918B7ADF118E64722B0FC51D301572426E0BD775556774E074CDE1EC05565A828018BBE0CD5F53747AC8D9EA205B8268182384180068013945D5C47381034952EAD0C807165089866F24862E6F66D5C3A7410A9';
wwv_flow_imp.g_varchar2_table(260) := '949EDB5FE6FC39F2F748E3161133A0A6B816C7A25AD301F264BEAE7D1F62E0C3F7E1BA1FE5F2EFFDCB9F91B598929B5F1F0197A7BAAEF55C2B50C0B59251304708448201D499440B6795BB712C99524E5278FA2773E306CE7EF821921A237F19394AE79F';
wwv_flow_imp.g_varchar2_table(261) := '50AE544F2B4DE10B04A43D5BE371CCD1980E9013CE7DF03EAE15F609906FEE78DFDAF7017A2E5D3215463C560BA3F5A679BC9248399D214003C019CEAEAD25AC3AFF4428545C3EE51A1D19BC858C875703A4FB6FE2E2B1A318CF5AEFF0170D06B1AEB909';
wwv_flow_imp.g_varchar2_table(262) := '313326C56931C5C5045AD474C0023542B614515DF3570F1DC0B5D7CABD63A065CD336498C2C8F1A338FFD187C89B3CB7434E5C188D40621FE433DF24A0438006800EA51ACE232E52AB88E1747F3F92D99C272964C5EDBF7F1FC62C764D13E5C4185A9E88';
wwv_flow_imp.g_varchar2_table(263) := '23A8DCC6F29DEFDA2220EDBA381A855660A03202AEA88EB7EFCDD74C37DCA934A191E3C770EECDD72D97E3CAC654F3EB6B65F45F69AA2CFF2E011A007749F8F877A2AECE74D7B0F1819B18EEEB555E80BCA728A56FF4E1FCFE8F909C98B0945BDCA76D89';
wwv_flow_imp.g_varchar2_table(264) := '04EA9507C032333378968018BCADCA13A01518A8B4BC74F428CEFFEC2798181B55DF9C7D0DA96BF7D49B6FA8BFBB49D38A0D1810EF86619A8B8924F030011A000F33F1DD11711BC64C3ABE29E5FE1FE9BE82A16CD633B100999B3771F9D831ADA7FAC9C8';
wwv_flow_imp.g_varchar2_table(265) := '5FE6FCA3A1A0EFDADE8F0A8B11A01B18287C6EF674E3EC2F7F8ED16B3DEA6BE557084CA592B8F1977771F6FDBF6072D2DAF326817F720D2BE16AE245259C234003C039D6AEAE696E24A2C611C5C71099C1418CF5DF403A673E1A718392D95BB770769F9E';
wwv_flow_imp.g_varchar2_table(266) := 'DB5F022065E49F60C09F1B9ACE3119643AA0D54660E0B0F2829DFCE5CFD0FDCEDBC88FA72B23673E8FD1F3E770EAE73FC54535E7AFD3F9178C1906FE55A63D7C502A0D001F34B28E8AB275AA552778E7CC69DC191975F5BE00A9BE3E5C387800E3396BB7';
wwv_flow_imp.g_varchar2_table(267) := 'BF04FCAD696A0447FE3A57486DE611D7B95660A0527F524D25751FDC8F23FFF2FFE1D6F9B39828D3F258E9E8472F5FC4C91F7C0FC77FF71BDC51C686AACEF2259DFF7265C4C86FCBCC9EC940419D244003C049DA2EAE4B6E22F39417C04CC4C9741A8397';
wwv_flow_imp.g_varchar2_table(268) := '2E60444D0598E5AB569A8CFCBBD49CED98E63A7F06FC55ABA5DC53AF78022430D0EADA9F2E713A93C1D93FFC1E677EFB2B5C5706C168F755E494DB7E7A9EE29FA7309519475679D3864F9DC0B53FFD1E67BFF76F38F95BD5F1DFEC57536CFA530CAD71BD';
wwv_flow_imp.g_varchar2_table(269) := '071F159785297E274003C0EF57C034FDC50B60B5894852CD83DEB8701E6313D67393D38AAEF8C77135E77FF6C30F30A6B9B77F7B0303FE2ADE281EA9408CDF65AA336D89C54CA7C1EE53273F8991AECBE87AE72D1C5786C0E15FFD12675EFD132E7FF81E';
wwv_flow_imp.g_varchar2_table(270) := '7A8E1D41FFD9D3B8D5750943D7BA3178ED1A6E5E3C8FAB073EC299575EC6915FFC1C077FF2439C78F98FB872FA1486D4F4DAA4C65CFFDDFA23812056AAEB576735C3DD73BCF29B723A4B800680B3BC5D5FDB9258D4FC26383585D1CB97D07FA3CF3546C0';
wwv_flow_imp.g_varchar2_table(271) := 'B872FB5F92ED7D958BD60A7044DD3C65E4CF687F2B52FE4B9760BA8EC684E9C658335199521E81EC8D5EDC3E711CBDEFBF87ABAFBF8A0B7FF85D2170F0D44F7E84D33FF901CEFFE657E879F76DDC3E791CA9BEEBC86B5CAB33D525D7EDF2440C0D757533';
wwv_flow_imp.g_varchar2_table(272) := '25F31809D8224003C016AEDACF2C1E8068D0FCB2989A9CC4EDA34771EBCE1D351D505D4F405A75FE670F1DD45AE72F017F12ED2F3AD67E4B52C35208C8B5B1AAB1016E8CAA8F8542E850B2C9EF527473FF3994D06902E6777AA7A5617DAE20B02C1EB7DC';
wwv_flow_imp.g_varchar2_table(273) := '0C676A228B817D1FA0EF6A17EE64B398D49FBA2C9B8E0367CFE2F4BE7DC8A8FAAD0A9591BFB84DA35CEA6785CAF7E9D2F9AF6E6A84B8D80DE50FAB3610D9A362617D3D64DA4A96EC565B1ED65F3B046800D44E5B964D13E924E5666355A0B831874F9D44';
wwv_flow_imp.g_varchar2_table(274) := 'EF9933B8353282ECA4331B054D66B2E855A3FECB6AFE3467B13DAAE82037F4656A8E57DCA7F29D6F12B022201DAD788B24D04E8C47ABFC954A178F445B431C3235273255AA1E37944B199C274003C079E69EA8516E3C72F3B31A014DC9DAE54B17D177F4';
wwv_flow_imp.g_varchar2_table(275) := '30AE0D0C605075CE93F9CAB803F2B9490C7675E1D4DB6FA1E7EA552D8E327AE23A7F2D54CC340381399130D634376249346AE9159BE1F4920EC9DF9C3CB8A8B3B111321D217F8B2515C49348C08240C0229DC93E26209B03B5C4A35A04E451BB031FBC87';
wwv_flow_imp.g_varchar2_table(276) := 'EB470EA3EFD62DA454675D2E3B603297C390EAF04FBFFA0A2E1E3982B4E6922B19B9C9284E3C1A5A4A301309CC40C050C7E4297B1D0D0D98AB0C02F12819659E1A90E58872BDCAB443BB1AF1B726E23EDB9F4241E6CB710234001C47EEAD0A657DF4D298';
wwv_flow_imp.g_varchar2_table(277) := '9E11209AA57AAFE3C6818F70591902BDFD3731941E47464D0DD8F509886721353A8ABE0B1770FABDF7705EB9FC939971ED75D272936E533752ABCD8D4466BE494087801892ADF13864F328E9A4C51890C0529D7367CA23E7CA48BF554D4FC9485F3C0D62';
wwv_flow_imp.g_varchar2_table(278) := 'B04A84BF31D3093C460265264003A0CC406BB1B805F5F5901B93AC97D6D16F329341B2A71BD73F7C0F57F67D88AE73E7717D700837953130389E2D040D8E647385658463131FFF1E496730349AC4C0ADDBE8B97C19673EFC10A7DE7C13DD278E2335785B';
wwv_flow_imp.g_varchar2_table(279) := 'A7DA7B79E4C9687293E69CFF3D24FC504602F277209DF432650C743635160C02F9FB5814AD2F7808E4FA13B77D34182C3C5C4A1EB72D237BD971508C6989AF91EB53CE9591FEDC48A490CF28A38C5E2B8AF25687000D80EA70F75CAD72036B536E49C38E';
wwv_flow_imp.g_varchar2_table(280) := 'EB736A0AD9A1410C9F3D85DE3FBF83EEB7DE40D7BB6FE3D25B6FE1C2DB6FE09CFA7EEE8DD771F6B55770EECDD771511DEB7AEFCFE83D7A04A3FD3790CFDB7FEE80C8293763B9497B0E3205F6140143492B81796268CA75273B0AB62AA3403A7859AEB7B2';
wwv_flow_imp.g_varchar2_table(281) := 'B1012B1B1290DF724D2E8DC520C6B41808728E9C2B65803F245025023400AA04DE8BD5CAA8A7B3A90132BAB12BFF543E0FF10CE49263856D5373C9240AEF74AA703C9FCD20AFE6FA259FDDB225BF74F82DEA062B375AF92CC7F826816A11908E5D3A7871';
wwv_flow_imp.g_varchar2_table(282) := 'F3CBE76AC9E18D7A2965B508D000A816798FD62B23973635AA991B093B16156D852A1208A255CDA3CA4E6E5679994E0224400224F031011A001F73E0FF3608C8C8A655B93AC5BD295E011BA79635AB8CF465DE55BC12E2822D6BE12C8C0448C01102ACA4';
wwv_flow_imp.g_varchar2_table(283) := '7A046800548FBDE76B8E854285DDC90AEBECD567C34E7CC02CB417B7EAFC48046B9B1A21F3AE6208CCA2389E4A02244002BE2410F0A5D654BA6C040C55923C4550A60596C6A285F80059D3AC0E97FD25E5CAB2C4F644022DCAE52F8640D92B6181244002';
wwv_flow_imp.g_varchar2_table(284) := '0E126055D5244003A09AF46BA86EE99C650E5ED6336F98D38CD58D0D85D1B92C81324AF40CC8DCBEC41A2C57D30D32DA977297A98E3FCAFDFC6BE8CAA12A244002D52210A856C5ACB77609184AB5989A1290F9F9E589383A1A1385203DF92E1DBA1805B1';
wwv_flow_imp.g_varchar2_table(285) := '6010D2C1CB5BD64B4B7E591E25AE7DD97655A615DA1BE26889C520DBB146547E2917FC210112A8190254A4BA0402D5AD9EB5D73A0171D3CBB2C1B96ACE5EE6EB2578B0437907E4696B6B9B1B216FD910453C06B27E5A5CFBB2EDAA4C2B48A7CFF9FD5ABF';
wwv_flow_imp.g_varchar2_table(286) := '42A81F099040B508D000A81679D64B02244002BE2640E5AB4D800640B55B80F593000990000990401508D000A802745649022440027E2740FDAB4F800640F5DB80129000099000099080E3046800388E9C159200099080DF09507F3710A001E08656A00C';
wwv_flow_imp.g_varchar2_table(287) := '24400224400224E030011A000E03677524400224E07702D4DF1D046800B8A31D280509900009900009384A800680A3B8591909900009F89D00F5770B011A006E6909CA41022440022440020E12A001E0206C5645022440027E2740FDDD438006807BDA82';
wwv_flow_imp.g_varchar2_table(288) := '9290000990000990806304680038869A159100099080DF09507F3711A001E0A6D6A02C24400224400224E010011A000E81663524400224E07702D4DF5D046800B8AB3D280D09900009900009384280068023985909639FD81E0000074049444154099000';
wwv_flow_imp.g_varchar2_table(289) := '09F89D00F5771B011A006E6B11CA43022440022440020E10A001E000645641022440027E2740FDDD47800680FBDA84129100099000099040C509D000A838625640022440027E2740FDDD488006801B5B853291000990000990408509D000A83060164F02';
wwv_flow_imp.g_varchar2_table(290) := '2440027E2740FDDD498006803BDB855291000990000990404509D000A8285E164E022440027E2740FDDD4A8006805B5B867291000990000990400509D000A8205C164D022440027E2740FDDD4B8006807BDB86929100099000099040C508D000A8185A16';
wwv_flow_imp.g_varchar2_table(291) := '4C022440027E2740FDDD4C8006809B5B87B291000990000990408508D000A81058164B022440027E2740FDDD4D800680BBDB87D291000990000990404508D000A80856164A022440027E2740FDDD4E800680DB5B88F291000990000990400508D000A800';
wwv_flow_imp.g_varchar2_table(292) := '541649022440027E2740FDDD4F800680FBDB88129200099000099040D909D000283B521648022440027E2740FDBD40800680175A893292000990000990409909D0002833501647022440027E2740FDBD4180068037DA895292000990000990405909D000';
wwv_flow_imp.g_varchar2_table(293) := '282B4E1646022440027E2740FDBD42800680575A8A7292000990000990401909D00028234C1645022440027E2740FDBD4380068077DA8A929200099000099040D908D000281B4A1644022440027E2740FDBD44800680975A8BB292000990000990409908';
wwv_flow_imp.g_varchar2_table(294) := 'D0002813481643022440027E2740FDBD45800680B7DA8BD292000990000990405908D000280B461642022440027E2740FDBD46800680D75A8CF292000990000990401908D0002803441641022440027E2740FDBD47800680F7DA8C1293000990000990C0';
wwv_flow_imp.g_varchar2_table(295) := 'AC09D0009835421640022440027E2740FDBD48800680175B8D3293000990000990C02C09D0009825409E4E022440027E2740FDBD4980068037DB8D5293000990000990C0AC08D00098153E9E4C022440027E2740FDBD4A800680575B8E72930009900009';
wwv_flow_imp.g_varchar2_table(296) := '90C02C08D00098053C9E4A022440027E2740FDBD4B80068077DB8E929300099000099040C9046800948C8E279200099080DF09507F2F13A001E0E5D6A3EC244002244002245022011A002582E36924400224E07702D4DFDB04680078BBFD283D09900009';
wwv_flow_imp.g_varchar2_table(297) := '900009944480064049D8781209900009F89D00F5F73A011A005E6F41CA4F022440022440022510A0015002349E42022440027E2740FDBD4F800680F7DB901A90000990000990806D0234006C23E30924400224E07702D4BF1608D000A88556A40E244002';
wwv_flow_imp.g_varchar2_table(298) := '244002246093000D009BC0989D04488004FC4E80FAD706011A00B5D18ED482044880044880046C11A001600B17339300099080DF0950FF5A214003A0565A927A90000990000990800D0234006CC0625612200112F03B01EA5F3B046800D44E5B52131220';
wwv_flow_imp.g_varchar2_table(299) := '0112200112D0264003401B15339200099080DF0950FF5A224003A0965A93BA900009900009908026011A009AA0988D04488004FC4E80FAD716011A00B5D59ED48604488004488004B408D000D0C2C44C24400224E07702D4BFD608D000A8B516A53E2440';
wwv_flow_imp.g_varchar2_table(300) := '0224400224A0418006800624662101122001BF13A0FEB547800640EDB5293522011220011220014B0234002C11310309900009F89D00F5AF450234006AB155A913099000099000095810A001600188C924400224E07702D4BF3609D000A8CD76A5562440';
wwv_flow_imp.g_varchar2_table(301) := '0224400224604A800680291E269200099080DF0950FF5A254003A0565B967A910009900009908009011A0026709844022440027E2740FD6B97000D80DA6D5B6A46022440022440024509D000288A860924400224E07702D4BF9609D000A8E5D6A56E2440';
wwv_flow_imp.g_varchar2_table(302) := '02244002245084000D802260789804488004FC4E80FAD736011A00B5DDBED48E044880044880046624400360462C3C48022440027E2740FD6B9D000D805A6F61EA47022440022440023310A0013003141E2201122001BF13A0FEB54F800640EDB7313524';
wwv_flow_imp.g_varchar2_table(303) := '011220011220818708D0007808090F9000099080DF09507F3F10A001E08756A68E24400224400224F000011A000F00E15712200112F03B01EAEF0F023400FCD1CED49204488004488004EE234003E03E1CFC42022440027E2740FDFD428006805F5A9A7A';
wwv_flow_imp.g_varchar2_table(304) := '92000990000990C034023400A6C1E04712200112F03B01EAEF1F023400FCD3D6D49404488004488004EE11A001700F053F9000099080DF09507F3F11A001E0A7D6A6AE24400224400224F009011A009F80E02F12200112F03B01EAEF2F023400FCD5DED4';
wwv_flow_imp.g_varchar2_table(305) := '96044880044880040A0468001430F03F12200112F03B01EAEF37023400FCD6E2D4970448800448800414011A000A025F24400224E07702D4DF7F046800F8AFCDA931099000099000098006002F0212200112F03D0102F023011A007E6C75EA4C02244002';
wwv_flow_imp.g_varchar2_table(306) := '24E07B0234007C7F091000099080DF09507F7F12A001E0CF76A7D62440022440023E274003C0E71700D5270112F03B01EAEF57023400FCDAF2D49B0448800448C0D7046800F8BAF9A93C099080DF09507FFF12A001E0DFB6A7E62440022440023E264003';
wwv_flow_imp.g_varchar2_table(307) := 'C0C78D4FD5498004FC4E80FAFB99000D003FB73E75270112200112F02D011A00BE6D7A2A4E0224E07702D4DFDF04FE7F000000FFFF04AF9461000000064944415403002998F84AD234A1A90000000049454E44AE426082';
wwv_flow_imp_shared.create_app_static_file(
 p_id=>wwv_flow_imp.id(95883184241454758933)
,p_file_name=>'icons/app-icon-512.png'
,p_mime_type=>'image/png'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883172801031758920)
,p_plugin_type=>'DYNAMIC ACTION'
,p_plugin=>'NATIVE_OPEN_AI_ASSISTANT'
,p_version_scn=>15659873373027
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883173158930758921)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_as', 'POPUP',
  'mode', 'FULL')).to_clob
,p_version_scn=>15659873373034
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883173415309758921)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_DATE_PICKER_APEX'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'appearance_behavior', 'MONTH-PICKER:YEAR-PICKER:TODAY-BUTTON',
  'days_outside_month', 'VISIBLE',
  'show_on', 'FOCUS',
  'time_increment', '15')).to_clob
,p_version_scn=>15659873373037
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883173774746758921)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_GEOCODED_ADDRESS'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'background', 'default',
  'display_as', 'LIST',
  'map_preview', 'POPUP:ITEM',
  'match_mode', 'RELAX_HOUSE_NUMBER',
  'show_coordinates', 'N')).to_clob
,p_version_scn=>15659873373037
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883174005251758922)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_SELECT_MANY'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_values_as', 'separated')).to_clob
,p_version_scn=>15659873373040
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883174363621758922)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_SINGLE_CHECKBOX'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'checked_value', 'Y',
  'unchecked_value', 'N')).to_clob
,p_version_scn=>15659873373040
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883174678437758922)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'default_icon', 'fa-star',
  'tooltip', '#VALUE#')).to_clob
,p_version_scn=>15659873373049
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883174958352758923)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_style', 'SWITCH_CB',
  'off_value', 'N',
  'on_value', 'Y')).to_clob
,p_version_scn=>15659873373049
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883175280481758923)
,p_plugin_type=>'PROCESS TYPE'
,p_plugin=>'NATIVE_GEOCODING'
,p_attribute_01=>'RELAX_HOUSE_NUMBER'
,p_version_scn=>15659873373049
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883175584827758923)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'include_slider', 'Y')).to_clob
,p_version_scn=>15659873373052
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883175810610758923)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'actions_menu_structure', 'IG')).to_clob
,p_version_scn=>15659873373055
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883176102139758923)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_MAP_REGION'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'use_vector_tile_layers', 'Y')).to_clob
,p_version_scn=>15659873373055
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883176471001758923)
,p_plugin_type=>'WEB SOURCE TYPE'
,p_plugin=>'NATIVE_ADFBC'
,p_version_scn=>15659873373055
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(95883176722928758924)
,p_plugin_type=>'WEB SOURCE TYPE'
,p_plugin=>'NATIVE_BOSS'
,p_version_scn=>15659873373055
);
end;
/
prompt --application/shared_components/security/authorizations/administration_rights
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(95883185838529758934)
,p_name=>'Administration Rights'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return true;'
,p_error_message=>'Insufficient privileges, user is not an Administrator'
,p_version_scn=>15659873373367
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/admin_only
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(96279249140421442925)
,p_name=>'Admin Only'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT 1',
'  FROM MEMBERS',
'  WHERE USERNAME = :APP_USER',
'    AND ROLE = ''ADMIN'''))
,p_version_scn=>15660210935221
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/is_admin
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(96459148281503127883)
,p_name=>'Is Admin'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  v_count NUMBER;',
'BEGIN',
'  SELECT COUNT(*) INTO v_count',
'    FROM members',
'   WHERE username = :APP_USER',
'     AND LOWER(role) = ''admin'';',
'',
'  RETURN v_count > 0;',
'END;',
''))
,p_version_scn=>15660400314456
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/adminonly
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(96487743654831423746)
,p_name=>'AdminOnly'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'    v_role VARCHAR2(10);',
'BEGIN',
'    SELECT role',
'    INTO v_role',
'    FROM members',
'    WHERE username = :APP_USER;',
'',
'    IF v_role = ''admin'' THEN',
'        RETURN TRUE;',
'    ELSE',
'        RETURN FALSE;',
'    END IF;',
'EXCEPTION',
'    WHEN NO_DATA_FOUND THEN',
'        RETURN FALSE;',
'END;',
''))
,p_version_scn=>15660414342915
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/admin_onlyy
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(102701685134187973773)
,p_name=>'Admin Onlyy'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'RETURN :GLOBAL_ROLE = ''ADMIN'';'
,p_error_message=>'Access Denied, Admins Only'
,p_version_scn=>15664997905295
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items/global_role
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(102700735435694275675)
,p_name=>'GLOBAL_ROLE'
,p_protection_level=>'I'
,p_version_scn=>15664995676496
);
end;
/
prompt --application/shared_components/logic/application_items/global_user
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(102702212237722997615)
,p_name=>'GLOBAL_USER'
,p_protection_level=>'I'
,p_version_scn=>15664997236719
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(95883186343707758935)
,p_group_name=>'Administration'
);
end;
/
prompt --application/comments
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_imp_shared.create_menu(
 p_id=>wwv_flow_imp.id(95883177625822758924)
,p_name=>'Breadcrumb'
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(95883177886064758925)
,p_short_name=>'Home'
,p_link=>'f?p=&APP_ID.:1:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(95885886083645544066)
,p_short_name=>'TOOL ISSUE'
,p_link=>'f?p=&APP_ID.:8:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(95887788772457568551)
,p_short_name=>'TOOLS ISSUE'
,p_link=>'f?p=&APP_ID.:9:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(95922496330143851090)
,p_short_name=>'DashBoard'
,p_link=>'f?p=&APP_ID.:11:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(96019491507522441141)
,p_short_name=>'TOOLS'
,p_link=>'f?p=&APP_ID.:14:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(96023915465188960905)
,p_short_name=>'TOOLS RETURN'
,p_link=>'f?p=&APP_ID.:17:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(96269334743813061857)
,p_short_name=>'Members'
,p_link=>'f?p=&APP_ID.:3:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(96271819201029834256)
,p_short_name=>'Member Registration'
,p_link=>'f?p=&APP_ID.:2:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>2
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(96278962282204097447)
,p_short_name=>'AdminOnly'
,p_link=>'f?p=&APP_ID.:22:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>22
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(102906885899419204680)
,p_short_name=>'TOOLS'
,p_link=>'f?p=&APP_ID.:7:&APP_SESSION.::&DEBUG.:::'
,p_page_id=>7
);
end;
/
prompt --application/shared_components/navigation/breadcrumbentry
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
null;
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_imp_shared.create_theme(
 p_id=>wwv_flow_imp.id(95883178542261758926)
,p_theme_id=>42
,p_theme_name=>'Universal Theme'
,p_theme_internal_name=>'UNIVERSAL_THEME'
,p_version_identifier=>'24.2'
,p_navigation_type=>'L'
,p_nav_bar_type=>'LIST'
,p_reference_id=>4072363937200175119
,p_is_locked=>false
,p_current_theme_style_id=>2721322117358710262
,p_default_page_template=>4072355960268175073
,p_default_dialog_template=>2100407606326202693
,p_error_template=>2101157952850466385
,p_printer_friendly_template=>4072355960268175073
,p_login_template=>2101157952850466385
,p_default_button_template=>4072362960822175091
,p_default_region_template=>4072358936313175081
,p_default_chart_template=>4072358936313175081
,p_default_form_template=>4072358936313175081
,p_default_reportr_template=>4072358936313175081
,p_default_tabform_template=>4072358936313175081
,p_default_wizard_template=>4072358936313175081
,p_default_menur_template=>2531463326621247859
,p_default_listr_template=>4072358936313175081
,p_default_irr_template=>2100526641005906379
,p_default_report_template=>2538654340625403440
,p_default_label_template=>1609121967514267634
,p_default_menu_template=>4072363345357175094
,p_default_calendar_template=>4072363550766175095
,p_default_list_template=>4072361143931175087
,p_default_nav_list_template=>2526754704087354841
,p_default_top_nav_list_temp=>2526754704087354841
,p_default_side_nav_list_temp=>2467739217141810545
,p_default_nav_list_position=>'SIDE'
,p_default_dialogbtnr_template=>2126429139436695430
,p_default_dialogr_template=>4501440665235496320
,p_default_option_label=>1609121967514267634
,p_default_required_label=>1609122147107268652
,p_default_navbar_list_template=>2847543055748234966
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(42),'#APEX_FILES#themes/theme_42/24.2/')
,p_files_version=>64
,p_icon_library=>'FONTAPEX'
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#APEX_FILES#libraries/apex/#MIN_DIRECTORY#widget.stickyWidget#MIN#.js?v=#APEX_VERSION#',
'#THEME_FILES#js/theme42#MIN#.js?v=#APEX_VERSION#'))
,p_css_file_urls=>'#THEME_FILES#css/Core#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/globalization/translations
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(95883177068382758924)
,p_build_option_name=>'Commented Out'
,p_build_option_status=>'EXCLUDE'
,p_version_scn=>15659873373055
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/security/authentications/oracle_apex_accounts
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(95883177347207758924)
,p_name=>'Oracle APEX Accounts'
,p_scheme_type=>'NATIVE_APEX_ACCOUNTS'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_version_scn=>15659873373059
);
end;
/
prompt --application/shared_components/security/authentications/xyz
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(96275910810651293606)
,p_name=>'XYZ'
,p_scheme_type=>'NATIVE_CUSTOM'
,p_attribute_05=>'N'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'v_count NUMBER; -- variable declaration',
'BEGIN',
'    -- SELECT must be inside BEGIN',
'    SELECT COUNT(*) INTO v_count',
'    FROM MEMBERS',
'    WHERE USERNAME = :P101_USERNAME',
'      AND PASSWORD = :P101_PASSWORD;',
'',
'    IF v_count = 1 THEN',
'        DBMS_OUTPUT.PUT_LINE(''Login successful'');',
'    ELSE',
'        DBMS_OUTPUT.PUT_LINE(''Login failed'');',
'    END IF;',
'END;'))
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_version_scn=>15660203963170
);
end;
/
prompt --application/shared_components/security/authentications/admin
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(96461185311112180441)
,p_name=>'Admin'
,p_scheme_type=>'NATIVE_CUSTOM'
,p_attribute_03=>'authenticate_user'
,p_attribute_05=>'N'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_version_scn=>15660406998657
);
end;
/
prompt --application/shared_components/security/authentications/members_authentication
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(96487396817869101024)
,p_name=>'Members Authentication'
,p_scheme_type=>'NATIVE_CUSTOM'
,p_attribute_03=>'check_user'
,p_attribute_05=>'N'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_version_scn=>15660414203147
);
end;
/
prompt --application/shared_components/security/authentications/tool_lib_auth
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(102685641588483579766)
,p_name=>'Tool Lib Auth'
,p_scheme_type=>'NATIVE_CUSTOM'
,p_attribute_03=>'TOOL_LIB_AUTH'
,p_attribute_05=>'N'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_version_scn=>15664979677125
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_imp_page.create_page(
 p_id=>0
,p_name=>'Global Page'
,p_step_title=>'Global Page'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
,p_page_component_map=>'14'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_imp_page.create_page(
 p_id=>1
,p_name=>'Home'
,p_alias=>'HOME'
,p_step_title=>'TOOL LENDING LIBRARY'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'13'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95883198516256758944)
,p_plug_name=>'TOOL LENDING LIBRARY'
,p_region_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>2674017834225413037
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_num_rows=>15
,p_region_image=>'#APP_FILES#icons/app-icon-512.png'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML',
  'show_line_breaks', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95924114072811941828)
,p_plug_name=>'New'
,p_title=>'Welcome'
,p_plug_display_sequence=>10
,p_location=>null
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div style="text-align:center; padding: 30px;">',
'  <h1 style="color:#003366;">Welcome!</h1>',
'  <h3>Empowering members to borrow, use, and return tools efficiently.</h3>',
unistr('  <p>Hello <b>&APP_USER.</b> \D83D\DC4B <br>Your role: <b>&GLOBAL_ROLE.</b></p>'),
'</div>',
''))
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95924114140549941829)
,p_plug_name=>'New'
,p_title=>'About'
,p_plug_display_sequence=>20
,p_plug_item_display_point=>'BELOW'
,p_location=>null
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div style="padding:20px; background-color:#f7f9fc; border-radius:10px; box-shadow:0 2px 8px rgba(0,0,0,0.1);">',
'  <h2 style="color:#003366;">About the Tool Lending Library</h2>',
'  <p style="font-size:16px; line-height:1.6;">',
'    The Tool Lending Library is a digital platform designed to simplify how members borrow, use, ',
'    and return tools. It helps maintain accurate records, reduces paperwork, and ensures tools are ',
'    efficiently utilized and well-tracked within the community.',
'  </p>',
'  <p style="font-size:16px; line-height:1.6;">',
'    Developed using <b>Oracle APEX</b>, this system supports role-based access, real-time reports, ',
'    and a clean user interface for both administrators and members.',
'  </p>',
'</div>',
''))
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_imp_page.create_page(
 p_id=>2
,p_name=>'Member Registration'
,p_alias=>'MEMBER-REGISTRATION'
,p_step_title=>'Member Registration'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>2101157952850466385
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_protection_level=>'C'
,p_page_component_map=>'02'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96271818751717834255)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_location=>null
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96271820607898834445)
,p_plug_name=>'Member Registration'
,p_icon_css_classes=>'fa-user-plus'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>2674157997338192145
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'MEMBERS'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96271827529589834452)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CHANGE'
,p_button_condition=>'P2_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96271827160852834452)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_execute_validations=>'N'
,p_confirm_message=>'&APP_TEXT$DELETE_MSG!RAW.'
,p_confirm_style=>'danger'
,p_button_condition=>'P2_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96271827902259834452)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Register'
,p_button_position=>'NEXT'
,p_button_condition=>'P2_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96271826535328834451)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Cancel'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:9999:&SESSION.::&DEBUG.:::'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(96271828210229834452)
,p_branch_name=>'Go To Page 1'
,p_branch_action=>'f?p=&APP_ID.:9999:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271820903077834445)
,p_name=>'P2_MEMBER_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_source=>'MEMBER_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271821386557834447)
,p_name=>'P2_NAME'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_prompt=>'Name'
,p_source=>'NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271821705570834447)
,p_name=>'P2_ADDRESS'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_prompt=>'Address'
,p_source=>'ADDRESS'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>500
,p_cHeight=>4
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'auto_height', 'N',
  'character_counter', 'N',
  'resizable', 'Y',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271822139291834447)
,p_name=>'P2_MOBILE_NUMBER'
,p_source_data_type=>'NUMBER'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_prompt=>'Mobile Number'
,p_source=>'MOBILE_NUMBER'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271822525750834448)
,p_name=>'P2_EMAIL_ID'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_prompt=>'Email Id'
,p_source=>'EMAIL_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271822925672834448)
,p_name=>'P2_USERNAME'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_prompt=>'Username'
,p_source=>'USERNAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_warn_on_unsaved_changes=>'I'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271823383185834449)
,p_name=>'P2_PASSWORD'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_prompt=>'Password'
,p_source=>'PASSWORD'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>100
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_warn_on_unsaved_changes=>'I'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'submit_when_enter_pressed', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96271823750711834449)
,p_name=>'P2_ROLE'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_item_source_plug_id=>wwv_flow_imp.id(96271820607898834445)
,p_source=>'ROLE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'N')).to_clob
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(98278333371481164401)
,p_validation_name=>'P2_MOBILE_NUMBER_FORMAT'
,p_validation_sequence=>10
,p_validation=>'RETURN REGEXP_LIKE(:P2_MOBILE_NUMBER, ''^[0-9]{10}$'');'
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Mobile number must be exactly 10 digits and contain only numbers'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(98278333501685164403)
,p_validation_name=>'P2_EMAIL_FORMAT'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'    RETURN UPPER(:P2_EMAIL_ID) LIKE ''%@GMAIL.COM''',
'        OR UPPER(:P2_EMAIL_ID) LIKE ''%@SASTRA.AC.IN'';',
'END;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Email must be a valid Gmail address ending with @gmail.com'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(95924114402621941832)
,p_validation_name=>'P2_UNIQUE_EMAIL'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'    l_count NUMBER;',
'BEGIN',
'    SELECT COUNT(*)',
'    INTO l_count',
'    FROM MEMBERS',
'    WHERE LOWER(EMAIL_ID) = LOWER(:P2_EMAIL_ID);',
'',
'    IF l_count > 0 THEN',
'        RETURN FALSE;',
'    ELSE',
'        RETURN TRUE;',
'    END IF;',
'END;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Email Id should be unique'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96271829143688834453)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(96271820607898834445)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Member Registration'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Registration Successful'
,p_internal_uid=>96271829143688834453
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96271828761458834453)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(96271820607898834445)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Member Registration'
,p_internal_uid=>96271828761458834453
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_imp_page.create_page(
 p_id=>3
,p_name=>'MEMBERS'
,p_alias=>'MEMBERS1'
,p_step_title=>'MEMBERS'
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Scroll Results Only in Side Column */',
'.t-Body-side {',
'    display: flex;',
'    flex-direction: column;',
'    overflow: hidden;',
'}',
'.search-results {',
'    flex: 1;',
'    overflow: auto;',
'}',
'/* Format Search Region */',
'.search-region {',
'    border-bottom: 1px solid rgba(0,0,0,.1);',
'    flex-shrink: 0;',
'}'))
,p_step_template=>2526643373347724467
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(102701685134187973773)
,p_protection_level=>'C'
,p_page_component_map=>'03'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269334263459061856)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269335954196061858)
,p_plug_name=>'Search'
,p_region_css_classes=>'search-region padding-md'
,p_region_template_options=>'#DEFAULT#:t-Form--stretchInputs'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML',
  'show_line_breaks', 'Y')).to_clob
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(96269336726608061859)
,p_name=>'Master Records'
,p_template=>3371237801798025892
,p_display_sequence=>20
,p_region_css_classes=>'search-results'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'t-MediaList--showDesc:t-MediaList--stack'
,p_display_point=>'REGION_POSITION_02'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select "MEMBER_ID",',
'    null LINK_CLASS,',
'    apex_page.get_url(p_items => ''P3_MEMBER_ID'', p_values => "MEMBER_ID") LINK,',
'    null ICON_CLASS,',
'    null LINK_ATTR,',
'    null ICON_COLOR_CLASS,',
'    case when coalesce(:P3_MEMBER_ID,''0'') = "MEMBER_ID"',
'      then ''is-active'' ',
'      else '' ''',
'    end LIST_CLASS,',
'    (substr("NAME", 1, 50)||( case when length("NAME") > 50 then ''...'' else '''' end )) LIST_TITLE,',
'    (substr("EMAIL_ID", 1, 50)||( case when length("EMAIL_ID") > 50 then ''...'' else '''' end )) LIST_TEXT,',
'    null LIST_BADGE',
'from "MEMBERS" x',
'where (:P3_SEARCH is null',
'        or upper(x."NAME") like ''%''||upper(:P3_SEARCH)||''%''',
'        or upper(x."EMAIL_ID") like ''%''||upper(:P3_SEARCH)||''%''',
'    )',
'order by "NAME"'))
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P3_SEARCH'
,p_lazy_loading=>false
,p_query_row_template=>2093604263195414824
,p_query_num_rows=>1000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'<div class="u-tC">No data found.</div>'
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269337424012061863)
,p_query_column_id=>1
,p_column_alias=>'MEMBER_ID'
,p_column_display_sequence=>1
,p_column_heading=>'MEMBER_ID'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269337847819061863)
,p_query_column_id=>2
,p_column_alias=>'LINK_CLASS'
,p_column_display_sequence=>2
,p_column_heading=>'LINK_CLASS'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269338247966061864)
,p_query_column_id=>3
,p_column_alias=>'LINK'
,p_column_display_sequence=>3
,p_column_heading=>'LINK'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269338603379061864)
,p_query_column_id=>4
,p_column_alias=>'ICON_CLASS'
,p_column_display_sequence=>4
,p_column_heading=>'ICON_CLASS'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269339002813061864)
,p_query_column_id=>5
,p_column_alias=>'LINK_ATTR'
,p_column_display_sequence=>5
,p_column_heading=>'LINK_ATTR'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269339446215061865)
,p_query_column_id=>6
,p_column_alias=>'ICON_COLOR_CLASS'
,p_column_display_sequence=>6
,p_column_heading=>'ICON_COLOR_CLASS'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269339813077061865)
,p_query_column_id=>7
,p_column_alias=>'LIST_CLASS'
,p_column_display_sequence=>7
,p_column_heading=>'LIST_CLASS'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269340297245061865)
,p_query_column_id=>8
,p_column_alias=>'LIST_TITLE'
,p_column_display_sequence=>8
,p_column_heading=>'LIST_TITLE'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269340608314061866)
,p_query_column_id=>9
,p_column_alias=>'LIST_TEXT'
,p_column_display_sequence=>9
,p_column_heading=>'LIST_TEXT'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269341083199061866)
,p_query_column_id=>10
,p_column_alias=>'LIST_BADGE'
,p_column_display_sequence=>10
,p_column_heading=>'LIST_BADGE'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(96269345957542062212)
,p_name=>'Members'
,p_template=>4072358936313175081
,p_display_sequence=>10
,p_region_css_classes=>'js-master-region'
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--scrollBody'
,p_component_template_options=>'#DEFAULT#:t-AVPList--leftAligned'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'TABLE'
,p_query_table=>'MEMBERS'
,p_query_where=>'"MEMBER_ID" = :P3_MEMBER_ID'
,p_include_rowid_column=>false
,p_display_when_condition=>'P3_MEMBER_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>2100515439059797523
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'No Record Selected'
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269346503851062213)
,p_query_column_id=>1
,p_column_alias=>'MEMBER_ID'
,p_column_display_sequence=>1
,p_column_heading=>'Member Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_when_cond_type=>'EXISTS'
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from "MEMBERS"',
'where "MEMBER_ID" is not null',
'and "MEMBER_ID" = :P3_MEMBER_ID'))
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269346978157062214)
,p_query_column_id=>2
,p_column_alias=>'NAME'
,p_column_display_sequence=>2
,p_column_heading=>'Name'
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'EXISTS'
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from "MEMBERS"',
'where "NAME" is not null',
'and "MEMBER_ID" = :P3_MEMBER_ID'))
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269347343056062214)
,p_query_column_id=>3
,p_column_alias=>'ADDRESS'
,p_column_display_sequence=>3
,p_column_heading=>'Address'
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'EXISTS'
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from "MEMBERS"',
'where "ADDRESS" is not null',
'and "MEMBER_ID" = :P3_MEMBER_ID'))
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269347793569062214)
,p_query_column_id=>4
,p_column_alias=>'MOBILE_NUMBER'
,p_column_display_sequence=>4
,p_column_heading=>'Mobile Number'
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'EXISTS'
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from "MEMBERS"',
'where "MOBILE_NUMBER" is not null',
'and "MEMBER_ID" = :P3_MEMBER_ID'))
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269348037307062214)
,p_query_column_id=>5
,p_column_alias=>'EMAIL_ID'
,p_column_display_sequence=>5
,p_column_heading=>'Email Id'
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'EXISTS'
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from "MEMBERS"',
'where "EMAIL_ID" is not null',
'and "MEMBER_ID" = :P3_MEMBER_ID'))
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269352104397062218)
,p_plug_name=>'Region Display Selector'
,p_region_css_classes=>'js-detail-rds'
,p_region_template_options=>'#DEFAULT#:margin-bottom-md'
,p_escape_on_http_output=>'Y'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_query_type=>'SQL'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_num_rows=>15
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P3_MEMBER_ID'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_region_icons', 'N',
  'include_show_all', 'Y',
  'rds_mode', 'STANDARD',
  'remember_selection', 'N')).to_clob
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(96269352510000062218)
,p_name=>'Issue'
,p_template=>4072358936313175081
,p_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_css_classes=>'js-detail-region'
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--scrollBody'
,p_component_template_options=>'t-Report--stretch:#DEFAULT#:t-Report--altRowsDefault:t-Report--rowHighlight:t-Report--inline'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'TABLE'
,p_query_table=>'ISSUE'
,p_query_where=>'"MEMBER_ID" = :P3_MEMBER_ID'
,p_include_rowid_column=>true
,p_display_when_condition=>'P3_MEMBER_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>2538654340625403440
,p_query_num_rows=>100
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'No data found.'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>5000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269354588602062392)
,p_query_column_id=>1
,p_column_alias=>'ROWID'
,p_column_display_sequence=>1
,p_column_heading=>'<span class="u-VisuallyHidden">Edit</span>'
,p_column_link=>'f?p=&APP_ID.:6:&APP_SESSION.::&DEBUG.:RP:P6_ROWID:#ROWID#'
,p_column_linktext=>'<span role="img" aria-label="Edit" class="fa fa-edit" title="Edit"></span>'
,p_heading_alignment=>'LEFT'
,p_report_column_width=>32
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269354980872062393)
,p_query_column_id=>2
,p_column_alias=>'MEMBER_ID'
,p_column_display_sequence=>2
,p_column_heading=>'Member Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269355384852062393)
,p_query_column_id=>3
,p_column_alias=>'MEMBER_NAME'
,p_column_display_sequence=>3
,p_column_heading=>'Member Name'
,p_heading_alignment=>'LEFT'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269355742400062393)
,p_query_column_id=>4
,p_column_alias=>'TOOL_ID'
,p_column_display_sequence=>4
,p_column_heading=>'Tool Id'
,p_heading_alignment=>'LEFT'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269356196473062393)
,p_query_column_id=>5
,p_column_alias=>'TOOL_NAME'
,p_column_display_sequence=>5
,p_column_heading=>'Tool Name'
,p_heading_alignment=>'LEFT'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269356598127062394)
,p_query_column_id=>6
,p_column_alias=>'ISSUE_DATE'
,p_column_display_sequence=>6
,p_column_heading=>'Issue Date'
,p_heading_alignment=>'LEFT'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(96269356930776062394)
,p_query_column_id=>7
,p_column_alias=>'RETURN_DATE'
,p_column_display_sequence=>7
,p_column_heading=>'Return Date'
,p_heading_alignment=>'LEFT'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269373026315062482)
,p_plug_name=>'No Record Selected'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>70
,p_plug_source=>'No Record Selected'
,p_plug_display_condition_type=>'ITEM_IS_NULL'
,p_plug_display_when_condition=>'P3_MEMBER_ID'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML',
  'show_line_breaks', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269360138093062397)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(96269352510000062218)
,p_button_name=>'POP_ISSUE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI'
,p_button_template_id=>2349107722467437027
,p_button_image_alt=>'Add Issue'
,p_button_position=>'EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&APP_SESSION.::&DEBUG.:RP,6:P6_MEMBER_ID:&P3_MEMBER_ID.'
,p_icon_css_classes=>'fa-plus'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269373536141062482)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(96269345957542062212)
,p_button_name=>'EDIT'
,p_button_static_id=>'edit_master_btn'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>2082829544945815391
,p_button_image_alt=>'Edit'
,p_button_position=>'EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:5:&APP_SESSION.::&DEBUG.:RP,5:P5_MEMBER_ID:&P3_MEMBER_ID.'
,p_icon_css_classes=>'fa-pencil-square-o'
,p_security_scheme=>wwv_flow_imp.id(102701685134187973773)
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269335062644061857)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(96269334263459061856)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft:t-Button--gapRight'
,p_button_template_id=>2082829544945815391
,p_button_image_alt=>'Reset'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:3:&APP_SESSION.:RESET:&DEBUG.:RP,3::'
,p_icon_css_classes=>'fa-undo-alt'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269336456149061859)
,p_name=>'P3_SEARCH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(96269335954196061858)
,p_prompt=>'Search'
,p_placeholder=>'Search...'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_label_alignment=>'RIGHT'
,p_field_template=>2040785906935475274
,p_item_icon_css_classes=>'fa-search'
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--large:t-Form-fieldContainer--postTextBlock'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269351832863062217)
,p_name=>'P3_MEMBER_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(96269345957542062212)
,p_display_as=>'NATIVE_HIDDEN'
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'S'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(96269373880200062482)
,p_name=>'Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_imp.id(96269345957542062212)
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269374432152062483)
,p_event_id=>wwv_flow_imp.id(96269373880200062482)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(96269345957542062212)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269374995390062483)
,p_event_id=>wwv_flow_imp.id(96269373880200062482)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.message.showPageSuccess(''Members row(s) updated.'');'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(96269352686034062218)
,p_name=>'Dialog Closed'
,p_event_sequence=>40
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_imp.id(96269352510000062218)
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269360815065062398)
,p_event_id=>wwv_flow_imp.id(96269352686034062218)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(96269352510000062218)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269361398230062398)
,p_event_id=>wwv_flow_imp.id(96269352686034062218)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.message.showPageSuccess(''Issue row(s) updated.'');'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(96269373962706062482)
,p_name=>'Perform Search'
,p_event_sequence=>150
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P3_SEARCH'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'this.browserEvent.which === apex.jQuery.ui.keyCode.ENTER'
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'keypress'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269375774632062484)
,p_event_id=>wwv_flow_imp.id(96269373962706062482)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(96269336726608061859)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269376282954062484)
,p_event_id=>wwv_flow_imp.id(96269373962706062482)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CANCEL_EVENT'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_imp_page.create_page(
 p_id=>5
,p_name=>'Members'
,p_alias=>'MEMBERS'
,p_page_mode=>'MODAL'
,p_step_title=>'MEMBERS'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>1661186590416509825
,p_page_template_options=>'#DEFAULT#:js-dialog-class-t-Drawer--pullOutEnd'
,p_dialog_chained=>'N'
,p_dialog_resizable=>'Y'
,p_protection_level=>'C'
,p_page_component_map=>'02'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269324282186061846)
,p_plug_name=>'Members'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'MEMBERS'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_add_authorization_scheme=>wwv_flow_imp.id(102701685134187973773)
,p_update_authorization_scheme=>wwv_flow_imp.id(102701685134187973773)
,p_delete_authorization_scheme=>wwv_flow_imp.id(102701685134187973773)
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269328044861061850)
,p_plug_name=>'Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>2126429139436695430
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'TEXT',
  'show_line_breaks', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269328401282061852)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(96269328044861061850)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_button_alignment=>'RIGHT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269329891099061853)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(96269328044861061850)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:t-Button--danger:t-Button--simple'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_alignment=>'RIGHT'
,p_button_execute_validations=>'N'
,p_confirm_message=>'&APP_TEXT$DELETE_MSG!RAW.'
,p_confirm_style=>'danger'
,p_button_condition=>'P5_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269330267731061853)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(96269328044861061850)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P5_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(96269332288091061855)
,p_branch_name=>'Redirect to new'
,p_branch_action=>'f?p=&APP_ID.:3:&APP_SESSION.::&DEBUG.:RP:P3_MEMBER_ID:&P5_MEMBER_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(96269332611766061855)
,p_branch_name=>'Redirect to all'
,p_branch_action=>'f?p=&APP_ID.:3:&APP_SESSION.::&DEBUG.:RP,3::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_imp.id(96269329891099061853)
,p_branch_sequence=>20
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269324544958061847)
,p_name=>'P5_MEMBER_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_item_source_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Member Id'
,p_source=>'MEMBER_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269324976195061847)
,p_name=>'P5_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_item_source_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Name'
,p_source=>'NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269325390897061848)
,p_name=>'P5_ADDRESS'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_item_source_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Address'
,p_source=>'ADDRESS'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>500
,p_cHeight=>4
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'auto_height', 'N',
  'character_counter', 'N',
  'resizable', 'Y',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269325747399061848)
,p_name=>'P5_MOBILE_NUMBER'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_item_source_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Mobile Number'
,p_source=>'MOBILE_NUMBER'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269326154368061849)
,p_name=>'P5_EMAIL_ID'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_item_source_plug_id=>wwv_flow_imp.id(96269324282186061846)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Email Id'
,p_source=>'EMAIL_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(96269328569250061852)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(96269328401282061852)
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269329341788061852)
,p_event_id=>wwv_flow_imp.id(96269328569250061852)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96269331847739061854)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(96269330267731061853)
,p_internal_uid=>96269331847739061854
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95924114364438941831)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(96269324282186061846)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Members'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>95924114364438941831
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96269331082947061854)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(96269324282186061846)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Members'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>96269331082947061854
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_imp_page.create_page(
 p_id=>6
,p_name=>'Issue'
,p_alias=>'ISSUE'
,p_page_mode=>'MODAL'
,p_step_title=>'Issue'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>1661186590416509825
,p_page_template_options=>'#DEFAULT#:js-dialog-class-t-Drawer--pullOutEnd'
,p_dialog_chained=>'N'
,p_dialog_resizable=>'Y'
,p_protection_level=>'C'
,p_page_component_map=>'02'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269363084506062472)
,p_plug_name=>'Issue'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'ISSUE'
,p_include_rowid_column=>true
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96269368299206062478)
,p_plug_name=>'Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>2126429139436695430
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'TEXT',
  'show_line_breaks', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269368690317062478)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(96269368299206062478)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_button_alignment=>'RIGHT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269370064705062479)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(96269368299206062478)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:t-Button--danger:t-Button--simple'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_alignment=>'RIGHT'
,p_button_execute_validations=>'N'
,p_confirm_message=>'&APP_TEXT$DELETE_MSG!RAW.'
,p_confirm_style=>'danger'
,p_button_condition=>'P6_ROWID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269370441890062479)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(96269368299206062478)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P6_ROWID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96269370855357062479)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(96269368299206062478)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'NEXT'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P6_ROWID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269363358276062473)
,p_name=>'P6_ROWID'
,p_source_data_type=>'VARCHAR2'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Rowid'
,p_source=>'ROWID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269363794726062473)
,p_name=>'P6_MEMBER_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Member Id'
,p_source=>'MEMBER_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269364123281062474)
,p_name=>'P6_MEMBER_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Member Name'
,p_source=>'MEMBER_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269364532995062474)
,p_name=>'P6_TOOL_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tool Id'
,p_source=>'TOOL_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269364994559062475)
,p_name=>'P6_TOOL_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Tool Name'
,p_source=>'TOOL_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>60
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269365325610062475)
,p_name=>'P6_ISSUE_DATE'
,p_source_data_type=>'DATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Issue Date'
,p_source=>'ISSUE_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER_APEX'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'appearance_and_behavior', 'MONTH-PICKER:YEAR-PICKER:TODAY-BUTTON',
  'days_outside_month', 'VISIBLE',
  'display_as', 'POPUP',
  'max_date', 'NONE',
  'min_date', 'NONE',
  'multiple_months', 'N',
  'show_on', 'FOCUS',
  'show_time', 'N',
  'use_defaults', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96269365708076062476)
,p_name=>'P6_RETURN_DATE'
,p_source_data_type=>'DATE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_item_source_plug_id=>wwv_flow_imp.id(96269363084506062472)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Return Date'
,p_source=>'RETURN_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER_APEX'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>1609121967514267634
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'appearance_and_behavior', 'MONTH-PICKER:YEAR-PICKER:TODAY-BUTTON',
  'days_outside_month', 'VISIBLE',
  'display_as', 'POPUP',
  'max_date', 'NONE',
  'min_date', 'NONE',
  'multiple_months', 'N',
  'show_on', 'FOCUS',
  'show_time', 'N',
  'use_defaults', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(96269368725586062478)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(96269368690317062478)
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(96269369598559062479)
,p_event_id=>wwv_flow_imp.id(96269368725586062478)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96269371653437062480)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(96269363084506062472)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Issue'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>96269371653437062480
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96269372082609062480)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_attribute_01=>'P6_ROWID,REQUEST'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'CREATE,SAVE,DELETE'
,p_process_when_type=>'REQUEST_IN_CONDITION'
,p_internal_uid=>96269372082609062480
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96269371217827062480)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(96269363084506062472)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Issue'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>96269371217827062480
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_imp_page.create_page(
 p_id=>7
,p_name=>'TOOLS'
,p_alias=>'TOOLS1'
,p_step_title=>'TOOLS'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'03'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(102906885325221204679)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(102906886091222204680)
,p_name=>'TOOLS'
,p_template=>4072358936313175081
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--hideHeader js-addHiddenHeadingRoleDesc:t-Region--scrollBody'
,p_component_template_options=>'#DEFAULT#:t-Report--stretch:t-Report--staticRowColors:t-Report--rowHighlight:t-Report--inline:t-Report--hideNoPagination'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'TABLE'
,p_query_table=>'REC_TOOL'
,p_include_rowid_column=>false
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>2538654340625403440
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'no data found'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_prn_output=>'N'
,p_prn_format=>'PDF'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906886858744204808)
,p_query_column_id=>1
,p_column_alias=>'TOOL_ID'
,p_column_display_sequence=>0
,p_column_heading=>'Tool ID'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_hidden_column=>'Y'
,p_include_in_export=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906887209632204809)
,p_query_column_id=>2
,p_column_alias=>'TOOL_TITLE'
,p_column_display_sequence=>2
,p_column_heading=>'Tool Title'
,p_heading_alignment=>'LEFT'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906887641542204809)
,p_query_column_id=>3
,p_column_alias=>'TOOL_CATEGORY'
,p_column_display_sequence=>3
,p_column_heading=>'Tool Category'
,p_heading_alignment=>'LEFT'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906888094116204809)
,p_query_column_id=>4
,p_column_alias=>'TOOL_CONDITION'
,p_column_display_sequence=>4
,p_column_heading=>'Tool Condition'
,p_heading_alignment=>'LEFT'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906888497058204810)
,p_query_column_id=>5
,p_column_alias=>'TOOL_PUR_DATE'
,p_column_display_sequence=>5
,p_column_heading=>'Tool Pur Date'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906888818162204810)
,p_query_column_id=>6
,p_column_alias=>'PRICE'
,p_column_display_sequence=>6
,p_column_heading=>'Price'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(102906889263022204810)
,p_query_column_id=>7
,p_column_alias=>'AVALABILE_COUNT'
,p_column_display_sequence=>7
,p_column_heading=>'Avalabile Count'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_disable_sort_column=>'N'
,p_include_in_export=>'Y'
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_imp_page.create_page(
 p_id=>8
,p_name=>'TOOL ISSUE'
,p_alias=>'TOOL-ISSUE'
,p_step_title=>'TOOL ISSUE'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'02'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95885885532073544065)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95885886758782544283)
,p_plug_name=>'TOOL ISSUE'
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>4072358936313175081
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'ISSUE'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(95886492203924544289)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CHANGE'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P8_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(95886491269123544288)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_button_alignment=>'RIGHT'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&APP_SESSION.::&DEBUG.:::'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(95886492670487544289)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'CREATE'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P8_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(95886491827300544288)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_alignment=>'RIGHT'
,p_button_execute_validations=>'N'
,p_confirm_message=>'&APP_TEXT$DELETE_MSG!RAW.'
,p_confirm_style=>'danger'
,p_button_condition=>'P8_MEMBER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(95886492988885544289)
,p_branch_action=>'f?p=&APP_ID.:8:&APP_SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95885887021084544284)
,p_name=>'P8_MEMBER_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_item_source_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_prompt=>'Member ID'
,p_source=>'MEMBER_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95885887415348544284)
,p_name=>'P8_MEMBER_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_item_source_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_prompt=>'Member Name'
,p_source=>'MEMBER_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95885887866963544285)
,p_name=>'P8_TOOL_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_item_source_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_prompt=>'Tool Id'
,p_source=>'TOOL_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95885888215468544285)
,p_name=>'P8_TOOL_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_item_source_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_prompt=>'Tool Name'
,p_source=>'TOOL_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>60
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95885888656536544286)
,p_name=>'P8_ISSUE_DATE'
,p_source_data_type=>'DATE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_item_source_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_prompt=>'Issue Date'
,p_source=>'ISSUE_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER_APEX'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_as', 'POPUP',
  'max_date', 'NONE',
  'min_date', 'NONE',
  'multiple_months', 'N',
  'show_time', 'N',
  'use_defaults', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95885889036886544286)
,p_name=>'P8_RETURN_DATE'
,p_source_data_type=>'DATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_item_source_plug_id=>wwv_flow_imp.id(95885886758782544283)
,p_source=>'RETURN_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(95924112969957941817)
,p_validation_name=>'Validate Member ID Exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  v_count NUMBER;',
'BEGIN',
'  SELECT COUNT(*) INTO v_count ',
'  FROM members ',
'  WHERE member_id = :P8_MEMBER_ID;  ',
'',
'  RETURN v_count > 0;  ',
'END;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Member ID not found in Members table.',
''))
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(95924113004529941818)
,p_validation_name=>'Validate Tool ID Exists'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  v_count NUMBER;',
'BEGIN',
'  SELECT COUNT(*) INTO v_count ',
'  FROM rec_tool',
'  WHERE tool_id = :P8_TOOL_ID;  ',
'',
'  RETURN v_count > 0;',
'END;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Tool ID not found in Tools table.',
''))
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95886493861433544290)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(95885886758782544283)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form TOOL ISSUE'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>95886493861433544290
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95886493420218544290)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(95885886758782544283)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form TOOL ISSUE'
,p_internal_uid=>95886493420218544290
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95924113880498941826)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Auto-Fill Id, Name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'    v_member_id   MEMBERS.MEMBER_ID%TYPE;',
'    v_member_name MEMBERS.NAME%TYPE;',
'BEGIN',
'    SELECT MEMBER_ID, NAME',
'    INTO v_member_id, v_member_name',
'    FROM MEMBERS',
'    WHERE LOWER(EMAIL_ID) = LOWER(:APP_USER);',
'',
'    :P8_MEMBER_ID := v_member_id;',
'    :P8_MEMBER_NAME := v_member_name;',
'EXCEPTION',
'    WHEN NO_DATA_FOUND THEN',
'        NULL; -- or handle error',
'END;',
''))
,p_process_clob_language=>'PLSQL'
,p_internal_uid=>95924113880498941826
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95924112430100941812)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Available Count (After Issue)'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'    v_avail rec_tool.avalabile_count%TYPE;',
'    v_toolname rec_tool.tool_title%TYPE;',
'BEGIN',
'    SELECT avalabile_count, tool_title',
'      INTO v_avail, v_toolname',
'      FROM rec_tool',
'     WHERE tool_id = :P8_TOOL_ID',
'       FOR UPDATE;',
'',
'    IF v_avail < 1 THEN',
'        raise_application_error(-20001,',
'            ''Not enough "'' || v_toolname || ''" available'');',
'    END IF;',
'',
'    UPDATE rec_tool',
'       SET avalabile_count = avalabile_count - 1',
'     WHERE tool_id = :P8_TOOL_ID;',
'',
'END;',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(95886492670487544289)
,p_internal_uid=>95924112430100941812
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_imp_page.create_page(
 p_id=>9
,p_name=>'TOOLS ISSUED'
,p_alias=>'TOOLS-ISSUE'
,p_step_title=>'TOOLS ISSUED'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'03'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95887788266008568550)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(95887788991431568551)
,p_name=>'TOOLS ISSUE'
,p_title=>'TOOLS ISSUED'
,p_display_sequence=>10
,p_component_template_options=>'#DEFAULT#:t-Report--stretch:t-Report--staticRowColors:t-Report--rowHighlight:t-Report--inline:t-Report--hideNoPagination'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT ',
'    member_id,',
'    member_name,',
'    tool_id,',
'    tool_name,',
'    issue_date',
'FROM issue',
'WHERE return_date IS NULL',
'ORDER BY issue_date DESC;',
''))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>2538654340625403440
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'no data found'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_prn_output=>'N'
,p_prn_format=>'PDF'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(95887789474513568758)
,p_query_column_id=>1
,p_column_alias=>'MEMBER_ID'
,p_column_display_sequence=>1
,p_column_heading=>'Member ID'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(95887789868529568759)
,p_query_column_id=>2
,p_column_alias=>'MEMBER_NAME'
,p_column_display_sequence=>2
,p_column_heading=>'Member Name'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(95887790229599568759)
,p_query_column_id=>3
,p_column_alias=>'TOOL_ID'
,p_column_display_sequence=>3
,p_column_heading=>'Tool ID'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(95887790694719568760)
,p_query_column_id=>4
,p_column_alias=>'TOOL_NAME'
,p_column_display_sequence=>4
,p_column_heading=>'Tool Name'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(95887791000433568760)
,p_query_column_id=>5
,p_column_alias=>'ISSUE_DATE'
,p_column_display_sequence=>5
,p_column_heading=>'Issue Date'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_imp_page.create_page(
 p_id=>11
,p_name=>'DASHBOARD'
,p_alias=>'DASHBOARD'
,p_step_title=>'DASHBOARD'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'04'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95922495834134851089)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_location=>null
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95922496531539851090)
,p_plug_name=>'Chart 1'
,p_title=>'Top Borrowed Tools'
,p_region_template_options=>'#DEFAULT#:t-CardsRegion--hideHeader js-addHiddenHeadingRoleDesc'
,p_escape_on_http_output=>'Y'
,p_plug_template=>2072724515482255512
,p_plug_display_sequence=>10
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT tool_name AS label, COUNT(*) AS value',
'FROM issue',
'GROUP BY tool_name',
'ORDER BY COUNT(*) DESC',
'FETCH FIRST 10 ROWS ONLY',
''))
,p_plug_source_type=>'NATIVE_JET_CHART'
);
wwv_flow_imp_page.create_jet_chart(
 p_id=>wwv_flow_imp.id(95924111413979941802)
,p_region_id=>wwv_flow_imp.id(95922496531539851090)
,p_chart_type=>'bar'
,p_height=>'400'
,p_animation_on_display=>'auto'
,p_animation_on_data_change=>'auto'
,p_orientation=>'vertical'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hover_behavior=>'dim'
,p_stack=>'off'
,p_connect_nulls=>'Y'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_zoom_and_scroll=>'off'
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_legend_rendered=>'off'
);
wwv_flow_imp_page.create_jet_chart_series(
 p_id=>wwv_flow_imp.id(95924111533633941803)
,p_chart_id=>wwv_flow_imp.id(95924111413979941802)
,p_seq=>10
,p_name=>'New'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT tool_name AS label, COUNT(*) AS value',
'FROM issue',
'GROUP BY tool_name',
'ORDER BY COUNT(*) DESC',
'FETCH FIRST 10 ROWS ONLY',
''))
,p_items_value_column_name=>'VALUE'
,p_items_label_column_name=>'LABEL'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>false
);
wwv_flow_imp_page.create_jet_chart_axis(
 p_id=>wwv_flow_imp.id(95924111773901941805)
,p_chart_id=>wwv_flow_imp.id(95924111413979941802)
,p_axis=>'y'
,p_is_rendered=>'on'
,p_format_type=>'decimal'
,p_decimal_places=>0
,p_format_scaling=>'none'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_position=>'auto'
,p_major_tick_rendered=>'on'
,p_minor_tick_rendered=>'off'
,p_tick_label_rendered=>'on'
);
wwv_flow_imp_page.create_jet_chart_axis(
 p_id=>wwv_flow_imp.id(95924111609425941804)
,p_chart_id=>wwv_flow_imp.id(95924111413979941802)
,p_axis=>'x'
,p_is_rendered=>'on'
,p_format_scaling=>'auto'
,p_scaling=>'linear'
,p_baseline_scaling=>'zero'
,p_major_tick_rendered=>'on'
,p_minor_tick_rendered=>'off'
,p_tick_label_rendered=>'on'
,p_tick_label_rotation=>'auto'
,p_tick_label_position=>'outside'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95922499292469851093)
,p_plug_name=>'Chart 2'
,p_title=>'Tools Availability'
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>4072358936313175081
,p_plug_display_sequence=>20
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT TOOL_CONDITION AS label,',
'       COUNT(*) AS value',
'FROM REC_TOOL',
'GROUP BY TOOL_CONDITION',
'ORDER BY COUNT(*) DESC;',
''))
,p_plug_source_type=>'NATIVE_JET_CHART'
);
wwv_flow_imp_page.create_jet_chart(
 p_id=>wwv_flow_imp.id(95922499670233851093)
,p_region_id=>wwv_flow_imp.id(95922499292469851093)
,p_chart_type=>'pie'
,p_height=>'400'
,p_animation_on_display=>'auto'
,p_animation_on_data_change=>'auto'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hide_and_show_behavior=>'withRescale'
,p_hover_behavior=>'dim'
,p_value_format_type=>'decimal'
,p_value_decimal_places=>0
,p_value_format_scaling=>'none'
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_value=>true
,p_legend_rendered=>'on'
,p_legend_position=>'auto'
,p_pie_other_threshold=>0
,p_pie_selection_effect=>'highlight'
);
wwv_flow_imp_page.create_jet_chart_series(
 p_id=>wwv_flow_imp.id(95922500193148851094)
,p_chart_id=>wwv_flow_imp.id(95922499670233851093)
,p_seq=>10
,p_name=>'Series 1'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT TOOL_CATEGORY AS label,',
'       COUNT(*) AS value',
'FROM REC_TOOL',
'GROUP BY TOOL_CATEGORY;',
''))
,p_max_row_count=>20
,p_items_value_column_name=>'VALUE'
,p_items_label_column_name=>'LABEL'
,p_items_label_rendered=>true
,p_items_label_position=>'auto'
,p_items_label_display_as=>'LABEL'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95922500769115851094)
,p_plug_name=>'Chart 3'
,p_title=>'Tools Purchased per Year'
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>4072358936313175081
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT TO_CHAR(TOOL_PUR_DATE, ''YYYY'') AS label,',
'       COUNT(*) AS value',
'FROM REC_TOOL',
'GROUP BY TO_CHAR(TOOL_PUR_DATE, ''YYYY'')',
'ORDER BY label;',
''))
,p_plug_source_type=>'NATIVE_JET_CHART'
);
wwv_flow_imp_page.create_jet_chart(
 p_id=>wwv_flow_imp.id(95922501108561851095)
,p_region_id=>wwv_flow_imp.id(95922500769115851094)
,p_chart_type=>'line'
,p_height=>'400'
,p_animation_on_display=>'auto'
,p_animation_on_data_change=>'auto'
,p_orientation=>'vertical'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hover_behavior=>'dim'
,p_stack=>'off'
,p_connect_nulls=>'Y'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_zoom_and_scroll=>'off'
,p_tooltip_rendered=>'Y'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_legend_rendered=>'off'
);
wwv_flow_imp_page.create_jet_chart_series(
 p_id=>wwv_flow_imp.id(95922502871565851095)
,p_chart_id=>wwv_flow_imp.id(95922501108561851095)
,p_seq=>10
,p_name=>'Series 1'
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT ',
'    TO_CHAR(TOOL_PUR_DATE, ''YYYY'') AS LABEL,',
'    COUNT(*) AS VALUE',
'FROM REC_TOOL',
'WHERE TOOL_PUR_DATE IS NOT NULL',
'GROUP BY TO_CHAR(TOOL_PUR_DATE, ''YYYY'')',
'ORDER BY TO_CHAR(TOOL_PUR_DATE, ''YYYY'');',
''))
,p_max_row_count=>20
,p_items_value_column_name=>'VALUE'
,p_items_label_column_name=>'LABEL'
,p_line_style=>'solid'
,p_line_type=>'auto'
,p_marker_rendered=>'auto'
,p_marker_shape=>'auto'
,p_assigned_to_y2=>'off'
,p_items_label_rendered=>false
);
wwv_flow_imp_page.create_jet_chart_axis(
 p_id=>wwv_flow_imp.id(95922501693098851095)
,p_chart_id=>wwv_flow_imp.id(95922501108561851095)
,p_axis=>'x'
,p_is_rendered=>'on'
,p_baseline_scaling=>'zero'
,p_major_tick_rendered=>'auto'
,p_minor_tick_rendered=>'auto'
,p_tick_label_rendered=>'on'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
wwv_flow_imp_page.create_jet_chart_axis(
 p_id=>wwv_flow_imp.id(95922502291284851095)
,p_chart_id=>wwv_flow_imp.id(95922501108561851095)
,p_axis=>'y'
,p_is_rendered=>'on'
,p_baseline_scaling=>'zero'
,p_position=>'auto'
,p_major_tick_rendered=>'auto'
,p_minor_tick_rendered=>'auto'
,p_tick_label_rendered=>'on'
,p_zoom_order_seconds=>false
,p_zoom_order_minutes=>false
,p_zoom_order_hours=>false
,p_zoom_order_days=>false
,p_zoom_order_weeks=>false
,p_zoom_order_months=>false
,p_zoom_order_quarters=>false
,p_zoom_order_years=>false
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_imp_page.create_page(
 p_id=>14
,p_name=>'TOOLS'
,p_alias=>'TOOLS'
,p_step_title=>'TOOLS'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(102701685134187973773)
,p_protection_level=>'C'
,p_page_component_map=>'21'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96019491005959441140)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96019491717052441142)
,p_plug_name=>'TOOLS'
,p_region_template_options=>'#DEFAULT#:t-IRR-region--hideHeader js-addHiddenHeadingRoleDesc'
,p_plug_template=>2100526641005906379
,p_plug_display_sequence=>20
,p_query_type=>'TABLE'
,p_query_table=>'REC_TOOL'
,p_include_rowid_column=>false
,p_plug_source_type=>'NATIVE_IG'
,p_prn_page_header=>'TOOLS'
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019493192710441143)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'enable_multi_select', 'Y',
  'hide_control', 'N',
  'show_select_all', 'Y')).to_clob
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019493683863441144)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_label=>'Actions'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019494513126441146)
,p_name=>'TOOL_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOOL_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>30
,p_value_alignment=>'RIGHT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019495562172441147)
,p_name=>'TOOL_TITLE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOOL_TITLE'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Tool Title'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'auto_height', 'N',
  'character_counter', 'N',
  'resizable', 'Y',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019496582469441148)
,p_name=>'TOOL_CATEGORY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOOL_CATEGORY'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Tool Category'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>60
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019497581933441149)
,p_name=>'TOOL_CONDITION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOOL_CONDITION'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Tool Condition'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>20
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019498590303441150)
,p_name=>'TOOL_PUR_DATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOOL_PUR_DATE'
,p_data_type=>'DATE'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER_APEX'
,p_heading=>'Tool Pur Date'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'appearance_and_behavior', 'MONTH-PICKER:YEAR-PICKER:TODAY-BUTTON',
  'days_outside_month', 'VISIBLE',
  'display_as', 'POPUP',
  'max_date', 'NONE',
  'min_date', 'NONE',
  'multiple_months', 'N',
  'show_on', 'FOCUS',
  'show_time', 'N',
  'use_defaults', 'Y')).to_clob
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019499518313441150)
,p_name=>'PRICE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PRICE'
,p_data_type=>'NUMBER'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Price'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96019500503130441151)
,p_name=>'AVALABILE_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'AVALABILE_COUNT'
,p_data_type=>'NUMBER'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Avalabile Count'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>90
,p_value_alignment=>'RIGHT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_interactive_grid(
 p_id=>wwv_flow_imp.id(96019492213626441142)
,p_internal_uid=>96019492213626441142
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>true
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>true
,p_define_chart_view=>true
,p_enable_download=>true
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>false
,p_show_detail_view=>false
);
wwv_flow_imp_page.create_ig_report(
 p_id=>wwv_flow_imp.id(96019492665240441143)
,p_interactive_grid_id=>wwv_flow_imp.id(96019492213626441142)
,p_static_id=>'960194928'
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(96019492929752441143)
,p_report_id=>wwv_flow_imp.id(96019492665240441143)
,p_view_type=>'GRID'
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019494052717441145)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>0
,p_column_id=>wwv_flow_imp.id(96019493683863441144)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019494960085441147)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>1
,p_column_id=>wwv_flow_imp.id(96019494513126441146)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019495988311441148)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(96019495562172441147)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019496917475441148)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>3
,p_column_id=>wwv_flow_imp.id(96019496582469441148)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019497954650441149)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(96019497581933441149)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019498958465441150)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>5
,p_column_id=>wwv_flow_imp.id(96019498590303441150)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019499959779441151)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>6
,p_column_id=>wwv_flow_imp.id(96019499518313441150)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96019500929703441151)
,p_view_id=>wwv_flow_imp.id(96019492929752441143)
,p_display_seq=>7
,p_column_id=>wwv_flow_imp.id(96019500503130441151)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96019501533834441152)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(96019491717052441142)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'TOOLS - Save Interactive Grid Data'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>96019501533834441152
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_imp_page.create_page(
 p_id=>17
,p_name=>'TOOL RETURN'
,p_alias=>'TOOLS-RETURN'
,p_step_title=>'TOOL RETURN'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'02'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96023914942136960904)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96023921584379961092)
,p_plug_name=>'TOOL RETURN'
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>4072358936313175081
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'ISSUE'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96023927088633961097)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CHANGE'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P17_TOOL_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96023926072546961097)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_button_alignment=>'RIGHT'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&APP_SESSION.::&DEBUG.:::'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96023927442749961098)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'CREATE'
,p_button_alignment=>'RIGHT'
,p_button_condition=>'P17_TOOL_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(96023926681161961097)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_alignment=>'RIGHT'
,p_button_execute_validations=>'N'
,p_confirm_message=>'&APP_TEXT$DELETE_MSG!RAW.'
,p_confirm_style=>'danger'
,p_button_condition=>'P17_TOOL_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(96023927701883961098)
,p_branch_action=>'f?p=&APP_ID.:1:&APP_SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96023921898526961092)
,p_name=>'P17_TOOL_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_item_source_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_prompt=>'Tool ID'
,p_source=>'TOOL_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>30
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96023922255543961093)
,p_name=>'P17_MEMBER_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_item_source_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_prompt=>'Member Id'
,p_source=>'MEMBER_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96023922639846961094)
,p_name=>'P17_MEMBER_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_item_source_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_prompt=>'Member Name'
,p_source=>'MEMBER_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>50
,p_read_only_when_type=>'ALWAYS'
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96023923093129961094)
,p_name=>'P17_TOOL_NAME'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_item_source_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_prompt=>'Tool Name'
,p_source=>'TOOL_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>60
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96023923446256961094)
,p_name=>'P17_ISSUE_DATE'
,p_source_data_type=>'DATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_item_source_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_source=>'ISSUE_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(96023923832879961095)
,p_name=>'P17_RETURN_DATE'
,p_source_data_type=>'DATE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_item_source_plug_id=>wwv_flow_imp.id(96023921584379961092)
,p_prompt=>'Return Date'
,p_source=>'RETURN_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER_APEX'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>3031561932232085882
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'display_as', 'POPUP',
  'max_date', 'NONE',
  'min_date', 'NONE',
  'multiple_months', 'N',
  'show_time', 'N',
  'use_defaults', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(95924112782287941815)
,p_validation_name=>'Validate Member ID Exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  v_count NUMBER;',
'BEGIN',
'  SELECT COUNT(*) INTO v_count',
'  FROM members',
'  WHERE member_id = :P17_MEMBER_ID;',
'',
'  RETURN v_count > 0;',
'END;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Member ID not found in Members table.'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(95924112835266941816)
,p_validation_name=>'Validate Tool ID Exists'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  v_count NUMBER;',
'BEGIN',
'  SELECT COUNT(*) INTO v_count ',
'  FROM rec_tool',
'  WHERE tool_id = :P17_TOOL_ID; ',
'',
'  RETURN v_count > 0;',
'END;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Tool ID not found in Tools table.'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96023928662854961099)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(96023921584379961092)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form TOOLS RETURN'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>96023928662854961099
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96023928248567961099)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(96023921584379961092)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form TOOLS RETURN'
,p_internal_uid=>96023928248567961099
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95924113920494941827)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Auto-Fill'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'    v_member_id   MEMBERS.MEMBER_ID%TYPE;',
'    v_member_name MEMBERS.NAME%TYPE;',
'BEGIN',
'    SELECT MEMBER_ID, NAME',
'    INTO v_member_id, v_member_name',
'    FROM MEMBERS',
'    WHERE LOWER(EMAIL_ID) = LOWER(:APP_USER);',
'',
'    :P17_MEMBER_ID := v_member_id;',
'    :P17_MEMBER_NAME := v_member_name;',
'EXCEPTION',
'    WHEN NO_DATA_FOUND THEN',
'        NULL; -- or handle error',
'END;',
''))
,p_process_clob_language=>'PLSQL'
,p_internal_uid=>95924113920494941827
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95924112347272941811)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Available Count (After Return)'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'    v_avail rec_tool.avalabile_count%TYPE;',
'    v_toolname rec_tool.tool_title%TYPE;',
'BEGIN',
'    SELECT avalabile_count, tool_title',
'      INTO v_avail, v_toolname',
'      FROM rec_tool',
'     WHERE tool_id = :P17_TOOL_ID',
'       FOR UPDATE;',
'',
'    UPDATE rec_tool',
'       SET avalabile_count = avalabile_count + 1',
'     WHERE tool_id = :P17_TOOL_ID;',
'',
'END;',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(96023927442749961098)
,p_internal_uid=>95924112347272941811
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95924113699715941824)
,p_process_sequence=>20
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Issued Record'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DELETE FROM issue',
'WHERE member_id = :P17_MEMBER_ID',
'  AND member_name = :P17_MEMBER_NAME',
'  AND tool_id = :P17_TOOL_ID',
'  AND tool_name = :P17_TOOL_NAME;',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Tool Returned'
,p_internal_uid=>95924113699715941824
);
end;
/
prompt --application/pages/page_00022
begin
wwv_flow_imp_page.create_page(
 p_id=>22
,p_name=>'AdminOnly'
,p_alias=>'ADMINONLY'
,p_step_title=>'AdminOnly'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(102701685134187973773)
,p_protection_level=>'C'
,p_page_component_map=>'21'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96278961757678097446)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>2531463326621247859
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_imp.id(95883177625822758924)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>4072363345357175094
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(96278962440965097448)
,p_plug_name=>'AdminOnly'
,p_region_template_options=>'#DEFAULT#:t-IRR-region--hideHeader js-addHiddenHeadingRoleDesc'
,p_plug_template=>2100526641005906379
,p_plug_display_sequence=>20
,p_query_type=>'TABLE'
,p_query_table=>'MEMBERS'
,p_include_rowid_column=>false
,p_plug_source_type=>'NATIVE_IG'
,p_prn_page_header=>'AdminOnly'
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278963725376097449)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'enable_multi_select', 'Y',
  'hide_control', 'N',
  'show_select_all', 'Y')).to_clob
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278964259416097449)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_label=>'Actions'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278965234658097452)
,p_name=>'MEMBER_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MEMBER_ID'
,p_data_type=>'NUMBER'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>30
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
,p_enable_filter=>false
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278966279645097452)
,p_name=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'NAME'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278967227570097453)
,p_name=>'ADDRESS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ADDRESS'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Address'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'auto_height', 'N',
  'character_counter', 'N',
  'resizable', 'Y',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>500
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_control_break=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278968270916097454)
,p_name=>'MOBILE_NUMBER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MOBILE_NUMBER'
,p_data_type=>'NUMBER'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Mobile Number'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>60
,p_value_alignment=>'RIGHT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'number_alignment', 'left',
  'virtual_keyboard', 'decimal')).to_clob
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278969226708097454)
,p_name=>'EMAIL_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EMAIL_ID'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Email Id'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278970216177097455)
,p_name=>'USERNAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'USERNAME'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Username'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278971273425097456)
,p_name=>'PASSWORD'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PASSWORD'
,p_data_type=>'VARCHAR2'
,p_session_state_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Password'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>90
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'send_on_page_submit', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(96278972254262097457)
,p_name=>'ROLE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ROLE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Role'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'trim_spaces', 'BOTH')).to_clob
,p_is_required=>true
,p_max_length=>20
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_readonly_condition_type=>'EXPRESSION'
,p_readonly_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':ROLE != ''USER''',
''))
,p_readonly_condition2=>'PLSQL'
,p_readonly_for_each_row=>false
);
wwv_flow_imp_page.create_interactive_grid(
 p_id=>wwv_flow_imp.id(96278962931186097448)
,p_internal_uid=>96278962931186097448
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>true
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>true
,p_define_chart_view=>true
,p_enable_download=>true
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>false
,p_show_detail_view=>false
);
wwv_flow_imp_page.create_ig_report(
 p_id=>wwv_flow_imp.id(96278963318504097448)
,p_interactive_grid_id=>wwv_flow_imp.id(96278962931186097448)
,p_static_id=>'962789634'
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(96278963561441097449)
,p_report_id=>wwv_flow_imp.id(96278963318504097448)
,p_view_type=>'GRID'
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278964669885097450)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>0
,p_column_id=>wwv_flow_imp.id(96278964259416097449)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278965601302097452)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>1
,p_column_id=>wwv_flow_imp.id(96278965234658097452)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278966674578097453)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(96278966279645097452)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278967668968097453)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>3
,p_column_id=>wwv_flow_imp.id(96278967227570097453)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278968688747097454)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(96278968270916097454)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278969619959097455)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>5
,p_column_id=>wwv_flow_imp.id(96278969226708097454)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278970621602097455)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>6
,p_column_id=>wwv_flow_imp.id(96278970216177097455)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278971668635097456)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>7
,p_column_id=>wwv_flow_imp.id(96278971273425097456)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(96278972631212097457)
,p_view_id=>wwv_flow_imp.id(96278963561441097449)
,p_display_seq=>8
,p_column_id=>wwv_flow_imp.id(96278972254262097457)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(96278973243474097457)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(96278962440965097448)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'AdminOnly - Save Interactive Grid Data'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>96278973243474097457
);
end;
/
prompt --application/pages/page_09999
begin
wwv_flow_imp_page.create_page(
 p_id=>9999
,p_name=>'Login Page'
,p_alias=>'LOGIN'
,p_step_title=>'TOOL LENDING LIBRARY - Log In'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>2101157952850466385
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_protection_level=>'C'
,p_page_component_map=>'12'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(95883187323036758936)
,p_plug_name=>'TOOL LENDING LIBRARY'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>2674157997338192145
,p_plug_display_sequence=>10
,p_region_image=>'#APP_FILES#icons/app-icon-512.png'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML',
  'show_line_breaks', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(95883190596959758939)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(95883187323036758936)
,p_button_name=>'LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Sign In'
,p_button_position=>'NEXT'
,p_button_alignment=>'LEFT'
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(95924113725149941825)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_imp.id(95883187323036758936)
,p_button_name=>'SignUp'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_image_alt=>'Sign-up'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95883188576513758937)
,p_name=>'P9999_USERNAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(95883187323036758936)
,p_prompt=>'Username'
,p_placeholder=>'Username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>100
,p_tag_attributes=>'autocomplete="username"'
,p_label_alignment=>'RIGHT'
,p_field_template=>2040785906935475274
,p_item_icon_css_classes=>'fa-user'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95883189407144758938)
,p_name=>'P9999_PASSWORD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(95883187323036758936)
,p_prompt=>'Password'
,p_placeholder=>'Password'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>40
,p_cMaxlength=>100
,p_tag_attributes=>'autocomplete="current-password"'
,p_label_alignment=>'RIGHT'
,p_field_template=>2040785906935475274
,p_item_icon_css_classes=>'fa-key'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'submit_when_enter_pressed', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(95883189897294758939)
,p_name=>'P9999_REMEMBER'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(95883187323036758936)
,p_prompt=>'Remember username'
,p_display_as=>'NATIVE_SINGLE_CHECKBOX'
,p_label_alignment=>'RIGHT'
,p_display_when=>'apex_authentication.persistent_cookies_enabled'
,p_display_when2=>'PLSQL'
,p_display_when_type=>'EXPRESSION'
,p_field_template=>2040785906935475274
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'checked_value', '',
  'unchecked_value', '',
  'use_defaults', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95883193332866758941)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_INVOKE_API'
,p_process_name=>'Set Username Cookie'
,p_attribute_01=>'PLSQL_PACKAGE'
,p_attribute_03=>'APEX_AUTHENTICATION'
,p_attribute_04=>'SEND_LOGIN_USERNAME_COOKIE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>95883193332866758941
);
wwv_flow_imp_shared.create_invokeapi_comp_param(
 p_id=>wwv_flow_imp.id(95883194189990758941)
,p_page_process_id=>wwv_flow_imp.id(95883193332866758941)
,p_page_id=>9999
,p_name=>'p_username'
,p_direction=>'IN'
,p_data_type=>'VARCHAR2'
,p_has_default=>false
,p_display_sequence=>1
,p_value_type=>'EXPRESSION'
,p_value_language=>'PLSQL'
,p_value=>'lower( :P9999_USERNAME )'
);
wwv_flow_imp_shared.create_invokeapi_comp_param(
 p_id=>wwv_flow_imp.id(95883194667146758941)
,p_page_process_id=>wwv_flow_imp.id(95883193332866758941)
,p_page_id=>9999
,p_name=>'p_consent'
,p_direction=>'IN'
,p_data_type=>'BOOLEAN'
,p_has_default=>false
,p_display_sequence=>2
,p_value_type=>'ITEM'
,p_value=>'P9999_REMEMBER'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95883190934627758939)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_INVOKE_API'
,p_process_name=>'Login'
,p_attribute_01=>'PLSQL_PACKAGE'
,p_attribute_03=>'APEX_AUTHENTICATION'
,p_attribute_04=>'LOGIN'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>95883190934627758939
);
wwv_flow_imp_shared.create_invokeapi_comp_param(
 p_id=>wwv_flow_imp.id(95883191698492758940)
,p_page_process_id=>wwv_flow_imp.id(95883190934627758939)
,p_page_id=>9999
,p_name=>'p_username'
,p_direction=>'IN'
,p_data_type=>'VARCHAR2'
,p_has_default=>false
,p_display_sequence=>1
,p_value_type=>'ITEM'
,p_value=>'P9999_USERNAME'
);
wwv_flow_imp_shared.create_invokeapi_comp_param(
 p_id=>wwv_flow_imp.id(95883192472695758940)
,p_page_process_id=>wwv_flow_imp.id(95883190934627758939)
,p_page_id=>9999
,p_name=>'p_password'
,p_direction=>'IN'
,p_data_type=>'VARCHAR2'
,p_has_default=>false
,p_display_sequence=>2
,p_value_type=>'ITEM'
,p_value=>'P9999_PASSWORD'
);
wwv_flow_imp_shared.create_invokeapi_comp_param(
 p_id=>wwv_flow_imp.id(95883192987983758940)
,p_page_process_id=>wwv_flow_imp.id(95883190934627758939)
,p_page_id=>9999
,p_name=>'p_set_persistent_auth'
,p_direction=>'IN'
,p_data_type=>'BOOLEAN'
,p_has_default=>true
,p_display_sequence=>3
,p_value_type=>'API_DEFAULT'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95883196095940758942)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Clear Page(s) Cache'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_internal_uid=>95883196095940758942
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(95883195426417758941)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Username Cookie'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P9999_USERNAME := apex_authentication.get_login_username_cookie;',
':P9999_REMEMBER := case when :P9999_USERNAME is not null then ''Y'' end;'))
,p_process_clob_language=>'PLSQL'
,p_internal_uid=>95883195426417758941
);
end;
/
prompt --application/deployment/definition
begin
wwv_flow_imp_shared.create_install(
 p_id=>wwv_flow_imp.id(96462070055438238780)
);
end;
/
prompt --application/deployment/checks
begin
null;
end;
/
prompt --application/deployment/buildoptions
begin
null;
end;
/
prompt --application/end_environment
begin
wwv_flow_imp.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false)
);
commit;
end;
/
set verify on feedback on define on
prompt  ...done
